/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument.reader;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethodEntryOnly;
import com.sun.tdk.jcov.instrument.DataMethodInvoked;
import com.sun.tdk.jcov.instrument.DataMethodWithBlocks;
import com.sun.tdk.jcov.instrument.reader.Reader;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import com.sun.tdk.jcov.instrument.reader.ReaderFactoryStAX;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataClassStAX
implements Reader {
    private XMLStreamReader parser;
    private ReaderFactory rf;
    private DataClass clazz;

    public void readData(Object dest) throws FileFormatException {
        this.clazz = (DataClass)dest;
        try {
            this.readData();
        }
        catch (XMLStreamException ex) {
            throw new FileFormatException(ex);
        }
    }

    final void readData() throws XMLStreamException, FileFormatException {
        this.clazz.setSuperName(this.parser.getAttributeValue(null, "supername"));
        this.clazz.setSource(this.parser.getAttributeValue(null, "source"));
        boolean end = false;
        while (!end) {
            int type = this.parser.nextTag();
            switch (type) {
                case 1: {
                    if (this.parser.getLocalName() == "meth") {
                        this.parseMethod(this.parser);
                        break;
                    }
                    this.parseField(this.parser);
                    break;
                }
                case 2: {
                    end = true;
                }
            }
        }
    }

    private void parseMethod(XMLStreamReader parser) throws XMLStreamException, FileFormatException {
        String name = parser.getAttributeValue(null, "name");
        String vmSig = parser.getAttributeValue(null, "vmsig");
        String flags = parser.getAttributeValue(null, "flags");
        int access = Integer.parseInt(parser.getAttributeValue(null, "access"));
        String signature = parser.getAttributeValue(null, "signature");
        int id = 0;
        String s = parser.getAttributeValue(null, "id");
        if (s != null) {
            id = Integer.parseInt(s);
        }
        long count = 0L;
        s = parser.getAttributeValue(null, "count");
        if (s != null) {
            count = Long.parseLong(s);
        }
        int length = 0;
        s = parser.getAttributeValue(null, "length");
        if (s != null) {
            length = Integer.parseInt(s);
        }
        String scale = parser.getAttributeValue(null, "scale");
        parser.nextTag();
        if (parser.getEventType() == 2) {
            if (flags.contains("native") || flags.contains("abstract")) {
                DataMethodInvoked m = new DataMethodInvoked(this.clazz, access, name, vmSig, signature, new String[0], id);
                m.setCount(count);
                m.setScale(scale);
                DataMethodInvoked mthd = m;
            } else {
                DataMethodEntryOnly m = new DataMethodEntryOnly(this.clazz, access, name, vmSig, signature, new String[0], id);
                m.setCount(count);
                m.setScale(scale);
                DataMethodEntryOnly mthd = m;
            }
        } else {
            DataMethodWithBlocks m = new DataMethodWithBlocks(this.clazz, access, name, vmSig, signature, new String[0]);
            m.setBytecodeLength(length);
            m.readDataFrom();
            DataMethodWithBlocks mthd = m;
        }
    }

    private void parseField(XMLStreamReader parser) throws XMLStreamException, FileFormatException {
        String name = parser.getAttributeValue(null, "name");
        String vmSig = parser.getAttributeValue(null, "vmsig");
        String flags = parser.getAttributeValue(null, "flags");
        int access = Integer.parseInt(parser.getAttributeValue(null, "access"));
        int id = Integer.parseInt(parser.getAttributeValue(null, "id"));
        String val = parser.getAttributeValue(null, "val");
        DataField field = new DataField(this.clazz, access, name, vmSig, this.clazz.getSignature(), val, id);
        field.readDataFrom();
    }

    public void setReaderFactory(ReaderFactory r) {
        this.rf = r;
        this.parser = ((ReaderFactoryStAX)r).parser;
    }
}

