/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.DataMethodEntryOnly;
import com.sun.tdk.jcov.instrument.EntryCodeMethodAdapter;
import com.sun.tdk.jcov.instrument.ForkingMethodAdapter;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

class NativeWrappingMethodAdapter
extends ForkingMethodAdapter {
    private final ClassVisitor cv;
    private final MethodNode methodNode;
    private final DataMethodEntryOnly dataMethod;
    private final InstrumentationParams params;

    NativeWrappingMethodAdapter(MethodVisitor mv, MethodNode methodNode, ClassVisitor cv, DataMethodEntryOnly dataMethod, InstrumentationParams params) {
        super(mv, (MethodVisitor)methodNode);
        this.cv = cv;
        this.dataMethod = dataMethod;
        this.methodNode = methodNode;
        this.params = params;
    }

    private int computeMaxLocals(String descriptor, int accessFlags) {
        char type;
        int index = 1;
        int slot = 0;
        if ((accessFlags & 8) == 0) {
            ++slot;
        }
        while ((type = descriptor.charAt(index)) != ')') {
            switch (type) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'L': 
                case 'S': 
                case 'Z': 
                case '[': {
                    ++slot;
                    break;
                }
                case 'D': 
                case 'J': {
                    slot += 2;
                    break;
                }
            }
            index = this.nextDescriptorIndex(descriptor, index);
        }
        return slot;
    }

    private int nextDescriptorIndex(String descriptor, int index) {
        switch (descriptor.charAt(index)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return index + 1;
            }
            case 'L': {
                int i = index + 1;
                while (descriptor.charAt(i) != ';') {
                    ++i;
                }
                return i + 1;
            }
            case '[': {
                return this.nextDescriptorIndex(descriptor, index + 1);
            }
        }
        throw new InternalError("should not reach here");
    }

    public void visitEnd() {
        char type;
        int maxLocals;
        super.visitEnd();
        InsnList instructions = this.methodNode.instructions;
        String descriptor = this.methodNode.desc;
        this.methodNode.maxLocals = maxLocals = this.computeMaxLocals(descriptor, this.methodNode.access);
        this.methodNode.maxStack = maxLocals + 4;
        int slot = 0;
        if ((this.methodNode.access & 8) == 0) {
            instructions.add(new VarInsnNode(25, slot));
            ++slot;
        }
        int index = 1;
        while ((type = descriptor.charAt(index)) != ')') {
            switch (type) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    instructions.add(new VarInsnNode(21, slot));
                    ++slot;
                    break;
                }
                case 'F': {
                    instructions.add(new VarInsnNode(23, slot));
                    ++slot;
                    break;
                }
                case 'D': {
                    instructions.add(new VarInsnNode(24, slot));
                    slot += 2;
                    break;
                }
                case 'J': {
                    instructions.add(new VarInsnNode(22, slot));
                    slot += 2;
                    break;
                }
                case 'L': 
                case '[': {
                    instructions.add(new VarInsnNode(25, slot));
                    ++slot;
                    break;
                }
            }
            index = this.nextDescriptorIndex(descriptor, index);
        }
        int invokeOp = (this.methodNode.access & 8) == 0 ? 182 : 184;
        instructions.add(new MethodInsnNode(invokeOp, this.dataMethod.getParent().getFullname(), "$$generated$$_" + this.dataMethod.getName(), this.dataMethod.getVmSignature()));
        switch (descriptor.charAt(index + 1)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                instructions.add(new InsnNode(172));
                break;
            }
            case 'F': {
                instructions.add(new InsnNode(174));
                break;
            }
            case 'D': {
                instructions.add(new InsnNode(175));
                break;
            }
            case 'J': {
                instructions.add(new InsnNode(173));
                break;
            }
            case 'L': 
            case '[': {
                instructions.add(new InsnNode(176));
                break;
            }
            case 'V': {
                instructions.add(new InsnNode(177));
                break;
            }
        }
        String[] exceptions = this.methodNode.exceptions.toArray(new String[0]);
        MethodVisitor mvn = this.cv.visitMethod(this.methodNode.access, this.methodNode.name, this.methodNode.desc, this.methodNode.signature, exceptions);
        EntryCodeMethodAdapter ecma = new EntryCodeMethodAdapter(mvn, this.dataMethod, this.params);
        this.methodNode.accept(ecma);
    }
}

