/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.DataAbstract;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.CollectDetect;
import com.sun.tdk.jcov.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;

public class InstrumentationParams {
    private boolean detectInternal;
    private boolean dynamicCollect;
    private boolean classesReload;
    private boolean instrumentNative;
    private boolean instrumentSynthetic;
    private boolean instrumentAnonymous;
    private InstrumentationOptions.ABSTRACTMODE instrumentAbstract;
    private boolean instrumentFields;
    private String callerInclude;
    private String callerExclude;
    private String[] includes;
    private String[] excludes;
    private String[] callerIncludes;
    private String[] callerExcludes;
    private InstrumentationOptions.InstrumentationMode mode;
    private String saveBegin;
    private String saveEnd;
    private String[] savesBegin;
    private String[] savesEnd;
    private Utils.Pattern[] alls;
    private boolean innerInvocations = true;

    public InstrumentationParams(boolean dynamicCollect, boolean instrumentNative, boolean instrumentFields, boolean detectInternal, InstrumentationOptions.ABSTRACTMODE instrumentAbstract, String[] includes, String[] excludes, String[] callerIncludes, String[] callerExcludes, InstrumentationOptions.InstrumentationMode mode) {
        this(dynamicCollect, instrumentNative, instrumentFields, detectInternal, instrumentAbstract, includes, excludes, callerIncludes, callerExcludes, mode, null, null);
    }

    public InstrumentationParams(boolean instrumentNative, boolean instrumentFields, boolean instrumentAbstract, String[] includes, String[] excludes, InstrumentationOptions.InstrumentationMode mode) {
        this(false, instrumentNative, instrumentFields, false, instrumentAbstract ? InstrumentationOptions.ABSTRACTMODE.DIRECT : InstrumentationOptions.ABSTRACTMODE.NONE, includes, excludes, null, null, mode, null, null);
    }

    public InstrumentationParams(boolean instrumentNative, boolean instrumentFields, boolean instrumentAbstract, String[] includes, String[] excludes, InstrumentationOptions.InstrumentationMode mode, String[] saveBegin, String[] saveEnd) {
        this(false, instrumentNative, instrumentFields, false, instrumentAbstract ? InstrumentationOptions.ABSTRACTMODE.DIRECT : InstrumentationOptions.ABSTRACTMODE.NONE, includes, excludes, null, null, mode, saveBegin, saveEnd);
    }

    public InstrumentationParams(boolean instrumentNative, boolean instrumentFields, boolean instrumentAbstract, String[] includes, String[] excludes, String[] callerincludes, String[] callersexcludes, InstrumentationOptions.InstrumentationMode mode, String[] saveBegin, String[] saveEnd) {
        this(false, instrumentNative, instrumentFields, false, instrumentAbstract ? InstrumentationOptions.ABSTRACTMODE.DIRECT : InstrumentationOptions.ABSTRACTMODE.NONE, includes, excludes, callerincludes, callersexcludes, mode, saveBegin, saveEnd);
    }

    public InstrumentationParams(boolean dynamicCollect, boolean instrumentNative, boolean instrumentFields, boolean detectInternal, InstrumentationOptions.ABSTRACTMODE instrumentAbstract, String[] includes, String[] excludes, String[] callerIncludes, String[] callerExcludes, InstrumentationOptions.InstrumentationMode mode, String[] saveBegin, String[] saveEnd) {
        this(false, dynamicCollect, instrumentNative, instrumentFields, detectInternal, instrumentAbstract, includes, excludes, callerIncludes, callerExcludes, mode, saveBegin, saveEnd);
    }

    public InstrumentationParams(boolean classesReload, boolean dynamicCollect, boolean instrumentNative, boolean instrumentFields, boolean detectInternal, InstrumentationOptions.ABSTRACTMODE instrumentAbstract, String[] includes, String[] excludes, String[] callerIncludes, String[] callerExcludes, InstrumentationOptions.InstrumentationMode mode, String[] saveBegin, String[] saveEnd) {
        this(true, classesReload, dynamicCollect, instrumentNative, instrumentFields, detectInternal, instrumentAbstract, includes, excludes, callerIncludes, callerExcludes, mode, saveBegin, saveEnd);
    }

    public InstrumentationParams(boolean innerInvocations, boolean classesReload, boolean dynamicCollect, boolean instrumentNative, boolean instrumentFields, boolean detectInternal, InstrumentationOptions.ABSTRACTMODE instrumentAbstract, String[] includes, String[] excludes, String[] callerIncludes, String[] callerExcludes, InstrumentationOptions.InstrumentationMode mode, String[] saveBegin, String[] saveEnd) {
        this.innerInvocations = innerInvocations;
        this.detectInternal = detectInternal;
        this.dynamicCollect = dynamicCollect;
        this.classesReload = classesReload;
        this.instrumentNative = instrumentNative;
        this.instrumentAbstract = instrumentAbstract;
        this.instrumentFields = instrumentFields;
        if (includes == null) {
            includes = new String[]{""};
        }
        if (excludes == null) {
            excludes = new String[]{""};
        }
        this.includes = includes;
        this.excludes = excludes;
        if (callerIncludes == null) {
            callerIncludes = new String[]{};
        }
        if (callerExcludes == null) {
            callerExcludes = new String[]{};
        }
        this.callerIncludes = callerIncludes;
        this.callerExcludes = callerExcludes;
        this.savesBegin = saveBegin;
        this.savesEnd = saveEnd;
        this.mode = mode;
        this.saveBegin = InstrumentationOptions.concatRegexps(saveBegin);
        this.saveEnd = InstrumentationOptions.concatRegexps(saveEnd);
        this.callerInclude = InstrumentationOptions.concatRegexps(callerIncludes);
        this.callerExclude = InstrumentationOptions.concatRegexps(callerExcludes);
        this.alls = Utils.concatFilters(includes, excludes);
    }

    public boolean isDetectInternal() {
        return this.detectInternal;
    }

    public boolean isDynamicCollect() {
        return this.dynamicCollect;
    }

    public boolean isClassesReload() {
        return this.classesReload;
    }

    public boolean isInstrumentNative() {
        return this.instrumentNative;
    }

    public boolean isInstrumentFields() {
        return this.instrumentFields;
    }

    public boolean isInstrumentSynthetic() {
        return this.instrumentSynthetic;
    }

    public boolean isInstrumentAnonymous() {
        return this.instrumentAnonymous;
    }

    public boolean isInstrumentAbstract() {
        return this.instrumentAbstract != InstrumentationOptions.ABSTRACTMODE.NONE;
    }

    public void enable() {
        Collect.enableCounts();
        if (this.instrumentFields || this.instrumentAbstract != InstrumentationOptions.ABSTRACTMODE.NONE) {
            CollectDetect.enableInvokeCounts();
        }
        if (this.detectInternal) {
            CollectDetect.enableDetectInternal();
        }
        Collect.enabled = true;
    }

    public boolean isIncluded(String classname) {
        return Utils.accept(this.alls, null, "/" + classname, null);
    }

    public boolean isCallerFilterOn() {
        return !this.callerInclude.equals(".*") || !this.callerExclude.equals("");
    }

    public boolean isInnerInvacationsOff() {
        return !this.innerInvocations;
    }

    public boolean isCallerFilterAccept(String className) {
        boolean name = className.matches(this.callerInclude) && !className.matches(this.callerExclude);
        return name;
    }

    public boolean isStackMapShouldBeUpdated() {
        return this.mode.equals((Object)InstrumentationOptions.InstrumentationMode.BRANCH);
    }

    public InstrumentationOptions.InstrumentationMode getMode() {
        return this.mode;
    }

    public boolean isDataSaveFilterAccept(String className, String methodName, boolean isBegin) {
        return (className + "." + methodName).matches(isBegin ? this.saveBegin : this.saveEnd);
    }

    public boolean isDataSaveSpecified() {
        return this.saveBegin != null || this.saveEnd != null;
    }

    public static InstrumentationParams mergeParams(InstrumentationParams first, InstrumentationParams other) {
        boolean detectInternal = first.detectInternal || other.detectInternal;
        String[] includes = InstrumentationParams.mergeFilter(first.includes, other.includes, true);
        String[] excludes = InstrumentationParams.mergeFilter(first.excludes, other.excludes, false);
        String[] callerIncludes = InstrumentationParams.mergeFilter(first.callerIncludes, other.callerIncludes, true);
        String[] callerExcludes = InstrumentationParams.mergeFilter(first.callerExcludes, other.callerExcludes, false);
        boolean dynamicCollected = first.dynamicCollect | other.dynamicCollect;
        return new InstrumentationParams(dynamicCollected, first.instrumentNative, first.instrumentFields, detectInternal, first.instrumentAbstract, includes, excludes, callerIncludes, callerExcludes, first.mode);
    }

    public static InstrumentationParams mergeDetectInternalOnly(InstrumentationParams first, InstrumentationParams other) {
        boolean detectInternal = first.detectInternal || other.detectInternal;
        return new InstrumentationParams(first.dynamicCollect, first.instrumentNative, first.instrumentFields, detectInternal, first.instrumentAbstract, first.includes, first.excludes, first.callerIncludes, first.callerExcludes, first.mode);
    }

    public static String[] mergeFilter(String[] filter1, String[] filter2, boolean union) {
        TreeSet<String> res = new TreeSet<String>();
        if (union) {
            res.addAll(Arrays.asList(filter1));
            res.addAll(Arrays.asList(filter2));
            return res.toArray(new String[res.size()]);
        }
        for (String e1 : filter1) {
            for (String e2 : filter2) {
                if (!e1.equals(e2)) continue;
                res.add(e2);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public String[] getCallerIncludes() {
        return this.callerIncludes;
    }

    public String[] getCallerExcludes() {
        return this.callerExcludes;
    }

    public static InstrumentationParams setMode(InstrumentationParams params, InstrumentationOptions.InstrumentationMode mode) {
        return new InstrumentationParams(params.dynamicCollect, params.instrumentNative, params.instrumentFields, params.detectInternal, params.instrumentAbstract, params.includes, params.excludes, params.callerIncludes, params.callerExcludes, mode, params.savesBegin, params.savesEnd);
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
        this.alls = Utils.concatFilters(this.includes, excludes);
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
        this.alls = Utils.concatFilters(includes, this.excludes);
    }

    public InstrumentationParams setInstrumentSynthetic(boolean synth) {
        this.instrumentSynthetic = synth;
        return this;
    }

    public InstrumentationParams setInstrumentAnonymous(boolean anonym) {
        this.instrumentAnonymous = anonym;
        return this;
    }

    public InstrumentationParams setInnerInvocations(boolean inner) {
        this.innerInvocations = inner;
        return this;
    }

    void writeObject(DataOutput out) throws IOException {
        DataAbstract.writeStrings(out, this.excludes);
        DataAbstract.writeStrings(out, this.includes);
        DataAbstract.writeStrings(out, this.callerExcludes);
        DataAbstract.writeStrings(out, this.callerIncludes);
        DataAbstract.writeStrings(out, this.savesBegin);
        DataAbstract.writeStrings(out, this.savesEnd);
        out.writeBoolean(this.classesReload);
        out.writeBoolean(this.detectInternal);
        out.writeBoolean(this.dynamicCollect);
        out.writeBoolean(this.instrumentFields);
        out.writeBoolean(this.instrumentNative);
        out.writeBoolean(this.innerInvocations);
        out.write(this.instrumentAbstract.ordinal());
        out.write(this.mode.ordinal());
    }

    InstrumentationParams(DataInput in) throws IOException {
        this.excludes = DataAbstract.readStrings(in);
        this.includes = DataAbstract.readStrings(in);
        this.callerExcludes = DataAbstract.readStrings(in);
        this.callerIncludes = DataAbstract.readStrings(in);
        this.savesBegin = DataAbstract.readStrings(in);
        this.savesEnd = DataAbstract.readStrings(in);
        this.classesReload = in.readBoolean();
        this.detectInternal = in.readBoolean();
        this.dynamicCollect = in.readBoolean();
        this.instrumentFields = in.readBoolean();
        this.instrumentNative = in.readBoolean();
        this.innerInvocations = in.readBoolean();
        this.instrumentAbstract = InstrumentationOptions.ABSTRACTMODE.values()[in.readByte()];
        this.mode = InstrumentationOptions.InstrumentationMode.values()[in.readByte()];
    }
}

