/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.data.ScaleOptions;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.BasicBlock;
import com.sun.tdk.jcov.instrument.DataAbstract;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBranch;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataMethodEntryOnly;
import com.sun.tdk.jcov.instrument.DataMethodInvoked;
import com.sun.tdk.jcov.instrument.DataMethodWithBlocks;
import com.sun.tdk.jcov.instrument.DataPackage;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.instrument.MergeException;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import com.sun.tdk.jcov.instrument.reader.RootReader;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.JCovXMLFileSaver;
import com.sun.tdk.jcov.tools.JcovVersion;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRoot
extends DataAbstract {
    private int count;
    private String args;
    private String storageFileName;
    private boolean attached = false;
    private final Map<String, DataPackage> packages;
    protected ScaleOptions scaleOpts = new ScaleOptions();
    protected InstrumentationParams params;
    private static Map<Integer, DataRoot> instances = new HashMap<Integer, DataRoot>();
    private static volatile int instanceCount = 0;
    private List<Integer> secondaryIDs = new LinkedList<Integer>();
    protected MemberFilter acceptor;
    protected ReaderFactory rf;
    private TreeMap<String, String> props;
    private static final Logger logger = Logger.getLogger(DataRoot.class.getName());
    private static transient Locale LOCALE_ROOT = new Locale("__", "", "");
    private static final transient String ROOT_PACKAGE = "";

    public static DataRoot getInstance(int i) {
        return instances.get(i);
    }

    public DataRoot(InstrumentationParams params) {
        this(ROOT_PACKAGE, true, params);
    }

    public DataRoot(String args, InstrumentationParams params) {
        this(args, true, params);
    }

    public DataRoot(String args, boolean attached) {
        super(instanceCount++);
        instances.put(this.rootId, this);
        this.args = args;
        this.packages = new HashMap<String, DataPackage>();
        this.attached = attached;
        this.props = new TreeMap();
    }

    public DataRoot(String args, boolean attached, InstrumentationParams params) {
        this(args, attached);
        this.params = params;
    }

    public void destroy() {
        if (this.rootId == -1) {
            return;
        }
        instances.remove(this.rootId);
        for (int i : this.secondaryIDs) {
            instances.remove(i);
        }
        this.rootId = -1;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public int getCount() {
        if (!this.attached) {
            return this.count;
        }
        return Collect.slotCount();
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setScaleOpts(ScaleOptions scaleOpts) {
        this.scaleOpts = scaleOpts;
    }

    public ScaleOptions getScaleOpts() {
        return this.scaleOpts;
    }

    public void setStorageFileName(String fileName) {
        this.storageFileName = fileName;
    }

    public String getStorageFileName() {
        return this.storageFileName;
    }

    public void setParams(InstrumentationParams params) {
        this.params = params;
    }

    public InstrumentationParams getParams() {
        return this.params;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAcceptor(MemberFilter acceptor) {
        this.acceptor = acceptor;
    }

    public MemberFilter getAcceptor() {
        return this.acceptor;
    }

    public void setReaderFactory(ReaderFactory rf) {
        this.rf = rf;
    }

    public ReaderFactory getReaderFactory() {
        return this.rf;
    }

    public List<DataPackage> getPackages() {
        ArrayList<DataPackage> packs = new ArrayList<DataPackage>(this.packages.size());
        packs.addAll(this.packages.values());
        return packs;
    }

    public DataPackage findPackage(String name) {
        DataPackage pack = this.packages.get(name);
        if (pack == null) {
            pack = new DataPackage(this.rootId, name);
            this.packages.put(pack.getName(), pack);
        }
        return pack;
    }

    public DataClass findClass(String classname) {
        String packname;
        int i = classname.lastIndexOf(47);
        if (i > 0) {
            packname = classname.substring(0, i);
            classname = classname.substring(i);
        } else {
            packname = ROOT_PACKAGE;
        }
        DataPackage pack = this.packages.get(packname);
        if (pack == null) {
            return null;
        }
        return pack.findClass(classname);
    }

    public DataPackage findPackageForClass(String classname) {
        int i = classname.lastIndexOf(47);
        classname = i > 0 ? classname.substring(0, i) : ROOT_PACKAGE;
        return this.packages.get(classname);
    }

    public void addClass(DataClass clazz) {
        if (this.acceptor != null && !this.acceptor.accept(clazz)) {
            return;
        }
        int slash = clazz.getFullname().lastIndexOf(47);
        String pname = slash < 0 ? ROOT_PACKAGE : clazz.getFullname().substring(0, slash);
        this.findPackage(pname).addClass(clazz);
    }

    public void addPackage(DataPackage pack) {
        this.packages.put(pack.getName(), pack);
    }

    public List<DataClass> getClasses() {
        LinkedList<DataClass> classes = new LinkedList<DataClass>();
        for (DataPackage dp : this.packages.values()) {
            classes.addAll(dp.getClasses());
        }
        return classes;
    }

    @Override
    public String kind() {
        return "coverage";
    }

    @Override
    public void xmlGen(XmlContext ctx) {
        ctx.println("<?xml version='1.0' encoding='UTF-8'?>");
        ctx.println();
        super.xmlGen(ctx);
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        ctx.println();
        ctx.println("        xmlns='http://java.sun.com/jcov/namespace'");
        ctx.println("        xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
        ctx.print("        xsi:schemaLocation='http://java.sun.com/jcov/namespace coverage.xsd'");
    }

    @Override
    void xmlBody(XmlContext ctx) {
        this.xmlHead(ctx);
        ArrayList<DataPackage> packList = new ArrayList<DataPackage>(this.packages.values());
        Collections.sort(packList);
        for (DataPackage pack : packList) {
            pack.xmlGen(ctx);
        }
    }

    private void xmlHead(XmlContext ctx) {
        if (this.attached) {
            this.updateHead();
        }
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        GregorianCalendar calendar = new GregorianCalendar(gmt);
        Date now = new Date();
        calendar.setTime(now);
        ctx.println();
        ctx.indentPrintln("<head>");
        ctx.incIndent();
        this.props.put("coverage.created.date", String.format(LOCALE_ROOT, "%tF", calendar));
        this.props.put("coverage.created.time", String.format(LOCALE_ROOT, "%tT", calendar));
        this.props.put("coverage.generator.name", "jcov");
        this.props.put("coverage.generator.version", "2.0");
        this.props.put("coverage.generator.fullversion", JcovVersion.getJcovVersion());
        this.props.put("coverage.spec.version", "1.3");
        ctx.indentPrintln("<property name='coverage.generator.args' val='" + this.args + "'/>");
        ctx.indentPrintln("<property name='coverage.generator.mode' val='" + (Object)((Object)this.params.getMode()) + "'/>");
        ctx.indentPrintln("<property name='coverage.generator.internal' val='" + (this.params.isDetectInternal() ? "detect" : "include") + "'/>");
        ctx.indentPrintln("<property name='coverage.generator.include' val='" + InstrumentationOptions.concatRegexps(this.params.getIncludes()) + "'/>");
        ctx.indentPrintln("<property name='coverage.generator.exclude' val='" + InstrumentationOptions.concatRegexps(this.params.getExcludes()) + "'/>");
        ctx.indentPrintln("<property name='coverage.generator.caller_include' val='" + InstrumentationOptions.concatRegexps(this.params.getCallerIncludes()) + "'/>");
        ctx.indentPrintln("<property name='coverage.generator.caller_exclude' val='" + InstrumentationOptions.concatRegexps(this.params.getCallerExcludes()) + "'/>");
        for (String key : this.props.keySet()) {
            String value = this.props.get(key);
            ctx.indentPrintln("<property name='" + key + "' " + "val" + "='" + value + "'/>");
        }
        ctx.indentPrintln("<property name='dynamic.collected' val='" + this.params.isDynamicCollect() + "'/>");
        ctx.indentPrintln("<property name='id.count' val='" + this.count + "'/>");
        if (this.scaleOpts.getScaleSize() > 1) {
            ctx.indentPrintln("<property name='scale.size' val='" + this.scaleOpts.getScaleSize() + "'/>");
            ctx.indentPrintln("<property name='scales.compressed' val='" + this.scaleOpts.scalesCompressed() + "'/>");
        }
        ctx.decIndent();
        ctx.indentPrintln("</head>");
    }

    public void readHeader() throws FileFormatException {
        RootReader r = (RootReader)this.rf.getReaderFor(this);
        r.readHeader(this);
    }

    public CompatibilityCheckResult checkCompatibility(DataRoot other, int severity, boolean boe) {
        if (!this.checkHeaderCompatibility(other)) {
            logger.log(Level.SEVERE, "Attempt to merge data of different data types: \nexpected {0}; found {1}  (in XML header, property name \"coverage.generator.mode\")", new Object[]{this.params.getMode().name(), this.params.getMode().name()});
            return new CompatibilityCheckResult(1, 0);
        }
        int errors = 0;
        int warnings = 0;
        String ver = other.props.get("java.runtime.version");
        if (ver != null && !ver.equals(this.props.get("java.runtime.version"))) {
            logger.log(Level.WARNING, "Java version differs in file {0}: {1}", new Object[]{other.storageFileName, ver});
            ++warnings;
        }
        for (DataPackage pOther : other.packages.values()) {
            if (!this.packages.containsKey(pOther.getName())) continue;
            DataPackage p = this.packages.get(pOther.getName());
            for (DataClass cl : pOther.getClasses()) {
                DataClass c = p.findClass(cl.getName());
                if (c == null) continue;
                try {
                    errors += c.checkCompatibility(cl, other.getStorageFileName(), severity, boe);
                }
                catch (MergeException e) {
                    logger.log(Level.SEVERE, "Error while merging class " + cl.getFullname(), e);
                    ++errors;
                    if (!boe) continue;
                    return new CompatibilityCheckResult(errors, warnings);
                }
            }
        }
        return new CompatibilityCheckResult(errors, warnings);
    }

    public void createScales() {
        for (DataPackage p : this.getPackages()) {
            for (DataClass c : p.getClasses()) {
                for (DataMethod m : c.getMethods()) {
                    for (DataBlock b : m) {
                        b.expandScales(1, false);
                    }
                }
                for (DataField f : c.getFields()) {
                    for (DataBlock b : f) {
                        b.expandScales(1, false);
                    }
                }
            }
        }
        this.scaleOpts.setScaleSize(1);
    }

    public void addScales() {
        int newScaleSize = this.scaleOpts.getScaleSize() + 1;
        for (DataPackage p : this.getPackages()) {
            for (DataClass c : p.getClasses()) {
                for (DataMethod m : c.getMethods()) {
                    for (DataBlock b : m) {
                        b.expandScales(newScaleSize, false, b.collectCount() - b.count);
                    }
                }
                for (DataField f : c.getFields()) {
                    for (DataBlock b : f) {
                        b.expandScales(newScaleSize, false, b.collectCount() - b.count);
                    }
                }
            }
        }
        this.scaleOpts.setScaleSize(newScaleSize);
    }

    public void cleanScales() {
        for (DataPackage p : this.getPackages()) {
            for (DataClass c : p.getClasses()) {
                for (DataMethod m : c.getMethods()) {
                    for (DataBlock b : m) {
                        b.cleanScale();
                    }
                }
                for (DataField f : c.getFields()) {
                    for (DataBlock b : f) {
                        b.cleanScale();
                    }
                }
            }
        }
        this.scaleOpts.setScaleSize(0);
    }

    public void mergeSorted(DataRoot other, boolean fullmerge) {
        this.mergeHeader(other, fullmerge);
        block0: for (DataPackage otherPackage : other.packages.values()) {
            if (!this.packages.containsKey(otherPackage.getName())) {
                if (!fullmerge) continue;
                for (DataClass classOther : otherPackage.getClasses()) {
                    if (!this.scaleOpts.needReadScales()) continue;
                    classOther.expandScales(this.scaleOpts.getScaleSize(), true);
                    this.addClass(classOther);
                }
                continue;
            }
            ListIterator<DataClass> thisClasses = this.packages.get(otherPackage.getName()).getClasses().listIterator();
            ListIterator<DataClass> otherClasses = otherPackage.getClasses().listIterator();
            DataClass thisClass = null;
            DataClass otherClass = null;
            if (!thisClasses.hasNext()) {
                while (otherClasses.hasNext()) {
                    otherClass = otherClasses.next();
                    if (!fullmerge) continue;
                    if (this.scaleOpts.needReadScales()) {
                        otherClass.expandScales(this.scaleOpts.getScaleSize(), true);
                    }
                    thisClasses.add(otherClass);
                    thisClasses.next();
                }
                continue;
            }
            while (otherClasses.hasNext()) {
                otherClass = otherClasses.next();
                thisClass = thisClasses.next();
                int comp = thisClass.compareTo(otherClass);
                while (thisClasses.hasNext() && comp < 0) {
                    thisClass = thisClasses.next();
                    comp = thisClass.compareTo(otherClass);
                }
                if (comp == 0) {
                    thisClass.mergeSorted(otherClass);
                    continue;
                }
                if (comp > 0) {
                    if (!fullmerge) continue;
                    if (this.scaleOpts.needReadScales()) {
                        otherClass.expandScales(this.scaleOpts.getScaleSize(), true);
                    }
                    thisClasses.previous();
                    thisClasses.add(otherClass);
                    continue;
                }
                if (!fullmerge) continue block0;
                if (this.scaleOpts.needReadScales()) {
                    otherClass.expandScales(this.scaleOpts.getScaleSize(), true);
                }
                thisClasses.add(otherClass);
                thisClasses.next();
                while (otherClasses.hasNext()) {
                    otherClass = otherClasses.next();
                    if (this.scaleOpts.needReadScales()) {
                        otherClass.expandScales(this.scaleOpts.getScaleSize(), true);
                    }
                    thisClasses.add(otherClass);
                    thisClasses.next();
                }
                continue block0;
            }
        }
    }

    public void merge(DataRoot other, boolean fullmerge) {
        this.mergeHeader(other, fullmerge);
        for (DataPackage pOther : other.packages.values()) {
            if (!this.packages.containsKey(pOther.getName())) {
                if (!fullmerge) continue;
                for (DataClass cl : pOther.getClasses()) {
                    if (this.scaleOpts.needReadScales()) {
                        cl.expandScales(this.scaleOpts.getScaleSize(), true, 0);
                    }
                    this.addClass(cl);
                }
                continue;
            }
            DataPackage p = this.packages.get(pOther.getName());
            for (DataClass cl : pOther.getClasses()) {
                DataClass c = p.findClass(cl.getName());
                if (c == null) {
                    if (!fullmerge) continue;
                    if (this.scaleOpts.needReadScales()) {
                        cl.expandScales(this.scaleOpts.getScaleSize(), true, 0);
                    }
                    p.addClass(cl);
                    continue;
                }
                c.merge(cl);
            }
        }
        if (this.scaleOpts.needReadScales()) {
            for (DataPackage p : this.packages.values()) {
                for (DataClass cl : p.getClasses()) {
                    cl.expandScales(this.scaleOpts.getScaleSize(), false, 0);
                }
            }
        }
        instances.remove(other.rootId);
        instances.put(other.rootId, this);
        this.secondaryIDs.add(other.rootId);
        other.rootId = -1;
    }

    public void truncateToMethods() {
        if (this.params.getMode() != InstrumentationOptions.InstrumentationMode.METHOD) {
            for (DataPackage pack : this.packages.values()) {
                for (DataClass clazz : pack.getClasses()) {
                    ListIterator<DataMethod> it = clazz.getMethods().listIterator();
                    while (it.hasNext()) {
                        DataMethod meth = it.next();
                        if (meth instanceof DataMethodEntryOnly) continue;
                        it.set(new DataMethodEntryOnly(meth));
                    }
                }
            }
            this.params = InstrumentationParams.setMode(this.params, InstrumentationOptions.InstrumentationMode.METHOD);
        }
    }

    public void mergeOnSignatures(DataRoot other, boolean addmissing) {
        this.mergeHeader(other, addmissing);
        for (DataPackage otherPackage : other.packages.values()) {
            DataPackage thisPackage = this.packages.get(otherPackage.getName());
            if (thisPackage == null) {
                if (!addmissing) continue;
                for (DataClass otherClass : otherPackage.getClasses()) {
                    if (this.scaleOpts.needReadScales()) {
                        otherClass.expandScales(this.scaleOpts.getScaleSize(), true, 0);
                    }
                    this.addClass(otherClass);
                }
                continue;
            }
            block2: for (DataClass otherClass : otherPackage.getClasses()) {
                for (DataClass thisClass : thisPackage.getClasses()) {
                    if (!otherClass.getName().equals(thisClass.getName())) continue;
                    thisClass.mergeOnSignatures(otherClass);
                    continue block2;
                }
                if (!addmissing) continue;
                if (this.scaleOpts.needReadScales()) {
                    otherClass.expandScales(this.scaleOpts.getScaleSize(), true, 0);
                }
                this.addClass(otherClass);
            }
        }
        if (this.scaleOpts.needReadScales()) {
            for (DataPackage p : this.packages.values()) {
                for (DataClass cl : p.getClasses()) {
                    cl.expandScales(this.scaleOpts.getScaleSize(), false, 0);
                }
            }
        }
        instances.remove(other.rootId);
        instances.put(other.rootId, this);
        this.secondaryIDs.add(other.rootId);
    }

    private boolean checkHeaderCompatibility(DataRoot other) {
        return this.params.getMode().equals((Object)other.params.getMode());
    }

    private void mergeHeader(DataRoot other, boolean fullmerge) {
        this.args = this.mergeArgs(this.args, other.args);
        this.count = this.count > other.count ? this.count : other.count;
        this.params = fullmerge ? InstrumentationParams.mergeParams(this.params, other.params) : InstrumentationParams.mergeDetectInternalOnly(this.params, other.params);
        if (this.scaleOpts.needReadScales()) {
            this.scaleOpts.setScaleSize(this.scaleOpts.getScaleSize() + other.scaleOpts.getScaleSize());
        }
    }

    private String mergeArgs(String args1, String args2) {
        String[][] arrays;
        TreeSet<String> resSet = new TreeSet<String>();
        LinkedList<String> excludes = new LinkedList<String>();
        excludes.add(InstrumentationOptions.DSC_INCLUDE.name);
        excludes.addAll(Arrays.asList(InstrumentationOptions.DSC_INCLUDE.aliases));
        excludes.add(InstrumentationOptions.DSC_EXCLUDE.name);
        excludes.addAll(Arrays.asList(InstrumentationOptions.DSC_EXCLUDE.aliases));
        excludes.add(InstrumentationOptions.DSC_CALLER_INCLUDE.name);
        excludes.addAll(Arrays.asList(InstrumentationOptions.DSC_CALLER_INCLUDE.aliases));
        excludes.add(InstrumentationOptions.DSC_CALLER_EXCLUDE.name);
        excludes.addAll(Arrays.asList(InstrumentationOptions.DSC_CALLER_EXCLUDE.aliases));
        for (String s : excludes) {
            s = s + "=";
        }
        String[][] arr$ = arrays = new String[][]{args1.split(","), args2.split(",")};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] arr;
            for (String s : arr = arr$[i$]) {
                boolean toExclude = false;
                for (String ex : excludes) {
                    if (!s.startsWith(ex)) continue;
                    toExclude = true;
                    break;
                }
                if (toExclude) continue;
                resSet.add(s);
            }
            arr = args2.split(",");
        }
        String res = ROOT_PACKAGE;
        for (String s : resSet) {
            res = res + s + ",";
        }
        return res;
    }

    public void makeAttached() {
        Collect.setSlot(this.count);
        for (DataPackage p : this.packages.values()) {
            for (DataClass clazz : p.getClasses()) {
                for (DataMethod m : clazz.getMethods()) {
                    for (DataBlock b : m) {
                        b.attached = true;
                        b.setCount(Collect.countFor(b.slot) + b.count);
                    }
                }
                for (DataField fld : clazz.getFields()) {
                    for (DataBlock b : fld) {
                        b.attached = true;
                        b.setCount(Collect.countFor(b.slot) + b.count);
                    }
                }
            }
        }
        this.attached = true;
    }

    public void attach() {
        Collect.setSlot(this.count);
        for (DataPackage p : this.packages.values()) {
            for (DataClass clazz : p.getClasses()) {
                for (DataMethod m : clazz.getMethods()) {
                    for (DataBlock b : m) {
                        b.attach();
                    }
                }
                for (DataField fld : clazz.getFields()) {
                    for (DataBlock b : fld) {
                        b.attach();
                    }
                }
            }
        }
        this.attached = true;
    }

    public void detach() {
        this.updateHead();
        for (DataPackage p : this.packages.values()) {
            for (DataClass clazz : p.getClasses()) {
                for (DataMethod m : clazz.getMethods()) {
                    for (DataBlock b : m) {
                        b.detach();
                    }
                }
                for (DataField fld : clazz.getFields()) {
                    for (DataBlock b : fld) {
                        b.detach();
                    }
                }
            }
        }
        this.attached = false;
    }

    public void update() {
        this.updateHead();
        for (DataPackage p : this.packages.values()) {
            for (DataClass clazz : p.getClasses()) {
                for (DataMethod m : clazz.getMethods()) {
                    for (DataBlock b : m) {
                        b.update();
                    }
                }
                for (DataField fld : clazz.getFields()) {
                    for (DataBlock b : fld) {
                        b.update();
                    }
                }
            }
        }
    }

    private void updateHead() {
        this.count = Collect.slotCount();
    }

    public void applyFilter(MemberFilter filter) {
        if (filter == null) {
            return;
        }
        for (String pack : this.packages.keySet()) {
            DataPackage p = this.packages.get(pack);
            p.applyFilter(filter);
        }
        LinkedList<String> toRemove = new LinkedList<String>();
        for (String pName : this.packages.keySet()) {
            if (!this.packages.get(pName).getClasses().isEmpty()) continue;
            toRemove.add(pName);
        }
        for (String pack : toRemove) {
            this.packages.remove(pack);
        }
    }

    public void illuminateDuplicatesInScales(ArrayList pairs) {
        this.scaleOpts.setScaleSize(this.scaleOpts.getScaleSize() - pairs.size());
        int newSize = this.scaleOpts.getScaleSize();
        for (DataPackage p : this.packages.values()) {
            for (DataClass clazz : p.getClasses()) {
                for (DataMethod m : clazz.getMethods()) {
                    for (DataBlock b : m) {
                        b.illuminateDuplicatesInScales(newSize, pairs);
                    }
                }
                for (DataField fld : clazz.getFields()) {
                    for (DataBlock b : fld) {
                        b.illuminateDuplicatesInScales(newSize, pairs);
                    }
                }
            }
        }
    }

    public boolean isDifferentiateElements() {
        return false;
    }

    public static DataRoot read(String filename) throws FileFormatException {
        return Reader.readXML(filename);
    }

    public static DataRoot read(String filename, boolean readScales) throws FileFormatException {
        return Reader.readXML(filename, readScales, null);
    }

    public static DataRoot read(String filename, boolean read_scales, MemberFilter filter) throws FileFormatException {
        return Reader.readXML(filename, read_scales, filter);
    }

    public void write(String filename, InstrumentationOptions.MERGE mergeMode) throws Exception {
        JCovXMLFileSaver saver = new JCovXMLFileSaver(this, filename, null, mergeMode, false);
        saver.saveResults();
    }

    public void sort() {
        for (DataPackage p : this.packages.values()) {
            p.sort();
        }
    }

    public void setXMLHeadProperties(TreeMap<String, String> props) {
        this.props = props;
    }

    public Map<String, String> getXMLHeadProperties() {
        return this.props;
    }

    public void writeObject(DataOutput out) throws IOException {
        this.params.writeObject(out);
        this.scaleOpts.writeObject(out);
        DataRoot.writeString(out, this.args);
        out.writeShort(this.packages.size());
        for (DataPackage dataPackage : this.packages.values()) {
            dataPackage.writeObject(out);
        }
        out.write(this.props.size());
        for (Map.Entry entry : this.props.entrySet()) {
            out.writeUTF((String)entry.getKey());
            out.writeUTF((String)entry.getValue());
        }
    }

    public DataRoot(DataInput in) throws IOException {
        super(instanceCount++);
        try {
            this.params = new InstrumentationParams(in);
            this.scaleOpts = new ScaleOptions(in);
            this.args = DataRoot.readString(in);
            int packs = in.readShort();
            this.packages = new HashMap<String, DataPackage>(packs);
            for (int i = 0; i < packs; ++i) {
                DataPackage p = new DataPackage(this.rootId, in);
                this.packages.put(p.getName(), p);
            }
            int propsCount = in.readByte();
            this.props = new TreeMap();
            for (int i = 0; i < propsCount; ++i) {
                this.props.put(in.readUTF(), in.readUTF());
            }
            instances.put(this.rootId, this);
        }
        catch (IOException e) {
            --instanceCount;
            throw e;
        }
    }

    private static DataRoot mapXML(InputStream is, long[] counts) throws Exception {
        DataRoot root = Reader.readXML(is);
        root = DataRoot.applyCounts(root, counts, true);
        return root;
    }

    public static DataRoot setCounts(DataRoot root, long[] counts) throws Exception {
        return DataRoot.applyCounts(root, counts, false);
    }

    public static DataRoot mergeCounts(DataRoot root, long[] counts) throws Exception {
        return DataRoot.applyCounts(root, counts, true);
    }

    private static DataRoot applyCounts(DataRoot root, long[] counts, boolean merge) throws Exception {
        for (DataPackage pack : root.getPackages()) {
            for (DataClass clazz : pack.getClasses()) {
                for (DataField fld : clazz.getFields()) {
                    long count = merge ? fld.getCount() : 0L;
                    fld.setCount(count + counts[fld.getId()]);
                }
                for (DataMethod meth : clazz.getMethods()) {
                    if (meth instanceof DataMethodInvoked) {
                        DataMethodInvoked mi = (DataMethodInvoked)meth;
                        long count = merge ? mi.getCount() : 0L;
                        mi.setCount(count + counts[mi.getId()]);
                        continue;
                    }
                    if (meth instanceof DataMethodEntryOnly) {
                        DataMethodEntryOnly me = (DataMethodEntryOnly)meth;
                        long count = merge ? me.getCount() : 0L;
                        me.setCount(count + counts[me.getId()]);
                        continue;
                    }
                    DataMethodWithBlocks mb = (DataMethodWithBlocks)meth;
                    for (BasicBlock bb : mb.getBasicBlocks()) {
                        for (DataBlock db : bb.blockMap.keySet()) {
                            long count = merge ? db.getCount() : 0L;
                            db.setCount(count + counts[db.getId()]);
                        }
                        if (!(bb.exit instanceof DataBranch)) continue;
                        DataBranch ba = (DataBranch)bb.exit;
                        for (DataBlockTarget tg : ba.branchTargets) {
                            long count = merge ? tg.getCount() : 0L;
                            tg.setCount(count + counts[tg.getId()]);
                        }
                    }
                }
            }
        }
        return root;
    }

    public static class CompatibilityCheckResult {
        public int errors;
        public int warnings;

        public CompatibilityCheckResult(int errors, int warnings) {
            this.errors = errors;
            this.warnings = warnings;
        }
    }
}

