/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.BasicBlock;
import com.sun.tdk.jcov.instrument.CharacterRangeTableAttribute;
import com.sun.tdk.jcov.instrument.Constants;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockCatch;
import com.sun.tdk.jcov.instrument.DataBlockFallThrough;
import com.sun.tdk.jcov.instrument.DataBlockMethEnter;
import com.sun.tdk.jcov.instrument.DataBlockTargetCase;
import com.sun.tdk.jcov.instrument.DataBlockTargetCond;
import com.sun.tdk.jcov.instrument.DataBlockTargetDefault;
import com.sun.tdk.jcov.instrument.DataBlockTargetGoto;
import com.sun.tdk.jcov.instrument.DataBranchCond;
import com.sun.tdk.jcov.instrument.DataBranchGoto;
import com.sun.tdk.jcov.instrument.DataBranchSwitch;
import com.sun.tdk.jcov.instrument.DataExit;
import com.sun.tdk.jcov.instrument.DataExitSimple;
import com.sun.tdk.jcov.instrument.DataMethodWithBlocks;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.instrument.Instrumenter;
import com.sun.tdk.jcov.instrument.OffsetRecordingMethodAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

class BranchCodeMethodAdapter
extends OffsetRecordingMethodAdapter {
    private final MethodVisitor nextVisitor;
    private final List<DataExit> exits;
    private final List<DataBlock> src;
    private final Map<AbstractInsnNode, BasicBlock> insnToBB;
    private final InstrumentationParams params;

    public BranchCodeMethodAdapter(MethodVisitor mv, DataMethodWithBlocks method, InstrumentationParams params) {
        super(new MethodNode(method.getAccess(), method.getName(), method.getVmSignature(), method.getSignature(), method.getExceptions()), method);
        this.nextVisitor = mv;
        this.insnToBB = new IdentityHashMap<AbstractInsnNode, BasicBlock>();
        this.exits = new ArrayList<DataExit>();
        this.src = new ArrayList<DataBlock>();
        this.params = params;
    }

    private BasicBlock getBB(AbstractInsnNode insn, int startBCI) {
        BasicBlock bb = this.insnToBB.get(insn);
        if (bb == null) {
            bb = new BasicBlock(this.method.rootId, startBCI);
            this.insnToBB.put(insn, bb);
        } else if (startBCI >= 0) {
            bb.setStartBCI(startBCI);
        }
        return bb;
    }

    private BasicBlock getBB(AbstractInsnNode insn) {
        return this.getBB(insn, -1);
    }

    private AbstractInsnNode peek(ListIterator iit) {
        if (iit.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iit.next();
            iit.previous();
            return insn;
        }
        return null;
    }

    private BasicBlock[] completeComputationOfCodeLabelNodes() {
        MethodNode methodNode = (MethodNode)this.mv;
        InsnList instructions = methodNode.instructions;
        int[] allToReal = new int[instructions.size()];
        int allIdx = 0;
        int insnIdx = 0;
        ListIterator iit = instructions.iterator();
        AbstractInsnNode insnFirst = this.peek(iit);
        BasicBlock bbFirst = this.getBB(insnFirst, 0);
        DataBlockMethEnter blockFirst = new DataBlockMethEnter(bbFirst.rootId());
        bbFirst.add(blockFirst);
        while (iit.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iit.next();
            allToReal[allIdx++] = insnIdx;
            int bci = this.bcis[insnIdx];
            int opcode = insn.getOpcode();
            if (opcode < 0) {
                if (insn.getType() != 15) continue;
                LineNumberNode lineNode = (LineNumberNode)insn;
                this.method().addLineEntry(bci, lineNode.line);
                continue;
            }
            ++insnIdx;
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    LabelNode nlab;
                    JumpInsnNode jumpInsn = (JumpInsnNode)insn;
                    LabelNode insnTrue = jumpInsn.label;
                    int bciFalse = this.bcis[insnIdx];
                    DataBranchCond branch = new DataBranchCond(this.method.rootId, bci, bciFalse - 1);
                    DataBlockTargetCond blockTrue = new DataBlockTargetCond(branch.rootId(), true);
                    DataBlockTargetCond blockFalse = new DataBlockTargetCond(branch.rootId(), false);
                    branch.addTarget(blockTrue);
                    branch.addTarget(blockFalse);
                    AbstractInsnNode insnFalse = this.peek(iit);
                    assert (insnFalse != null);
                    BasicBlock bbTrue = this.getBB(insnTrue);
                    BasicBlock bbFalse = this.getBB(insnFalse, bciFalse);
                    this.exits.add(branch);
                    jumpInsn.label = nlab = new LabelNode();
                    bbTrue.add(blockTrue, nlab);
                    bbFalse.add(blockFalse);
                    break;
                }
                case 170: {
                    BasicBlock bbCase;
                    LabelNode labCase;
                    LabelNode nlab;
                    TableSwitchInsnNode switchInsn = (TableSwitchInsnNode)insn;
                    LabelNode insnDflt = switchInsn.dflt;
                    BasicBlock bbDefault = this.getBB(insnDflt);
                    DataBlockTargetDefault blockDefault = new DataBlockTargetDefault(bbDefault.rootId());
                    switchInsn.dflt = nlab = new LabelNode();
                    bbDefault.add(blockDefault, nlab);
                    int bciEnd = this.bcis[insnIdx] - 1;
                    DataBranchSwitch branch = new DataBranchSwitch(this.method.rootId, bci, bciEnd, blockDefault);
                    branch.addTarget(blockDefault);
                    this.exits.add(branch);
                    ListIterator<LabelNode> lit = switchInsn.labels.listIterator();
                    int key = switchInsn.min;
                    while (lit.hasNext()) {
                        labCase = (LabelNode)lit.next();
                        bbCase = this.getBB(labCase);
                        DataBlockTargetCase blockCase = new DataBlockTargetCase(bbCase.rootId(), key++);
                        branch.addTarget(blockCase);
                        nlab = new LabelNode();
                        lit.set(nlab);
                        bbCase.add(blockCase, nlab);
                    }
                    break;
                }
                case 171: {
                    BasicBlock bbCase;
                    LabelNode labCase;
                    LabelNode nlab;
                    LookupSwitchInsnNode switchInsn = (LookupSwitchInsnNode)insn;
                    LabelNode insnDflt = switchInsn.dflt;
                    BasicBlock bbDefault = this.getBB(insnDflt);
                    DataBlockTargetDefault blockDefault = new DataBlockTargetDefault(bbDefault.rootId());
                    switchInsn.dflt = nlab = new LabelNode();
                    bbDefault.add(blockDefault, nlab);
                    int bciEnd = this.bcis[insnIdx] - 1;
                    DataBranchSwitch branch = new DataBranchSwitch(this.method.rootId, bci, bciEnd, blockDefault);
                    branch.addTarget(blockDefault);
                    this.exits.add(branch);
                    ListIterator kit = switchInsn.keys.listIterator();
                    ListIterator<LabelNode> lit = switchInsn.labels.listIterator();
                    while (lit.hasNext()) {
                        labCase = (LabelNode)lit.next();
                        bbCase = this.getBB(labCase);
                        Integer key = (Integer)kit.next();
                        DataBlockTargetCase blockCase = new DataBlockTargetCase(branch.rootId(), key);
                        branch.addTarget(blockCase);
                        nlab = new LabelNode();
                        lit.set(nlab);
                        bbCase.add(blockCase, nlab);
                    }
                    break;
                }
                case 167: {
                    LabelNode nlab;
                    JumpInsnNode jumpInsn = (JumpInsnNode)insn;
                    int bciEnd = this.bcis[insnIdx] - 1;
                    DataBranchGoto branch = new DataBranchGoto(this.method.rootId, bci, bciEnd);
                    this.exits.add(branch);
                    LabelNode insnTarget = jumpInsn.label;
                    BasicBlock bbTarget = this.getBB(insnTarget);
                    DataBlockTargetGoto blockTarget = new DataBlockTargetGoto(bbTarget.rootId());
                    branch.addTarget(blockTarget);
                    jumpInsn.label = nlab = new LabelNode();
                    bbTarget.add(blockTarget, nlab);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    int bciNext = this.bcis[insnIdx];
                    DataExitSimple exit = new DataExitSimple(this.method.rootId, bci, bciNext - 1, insn.getOpcode());
                    this.exits.add(exit);
                    AbstractInsnNode insnNext = this.peek(iit);
                    if (insnNext == null) break;
                    this.getBB(insnNext, bciNext);
                    break;
                }
            }
        }
        LabelNode previousHandler = null;
        for (TryCatchBlockNode tcbn : methodNode.tryCatchBlocks) {
            LabelNode nlab;
            LabelNode insnHandler = tcbn.handler;
            if (insnHandler == previousHandler) continue;
            previousHandler = insnHandler;
            BasicBlock bbCatch = this.getBB(insnHandler);
            DataBlockCatch blockCatch = new DataBlockCatch(bbCatch.rootId());
            tcbn.handler = nlab = new LabelNode();
            bbCatch.add(blockCatch, nlab);
        }
        if (this.method().getCharacterRangeTable() != null) {
            boolean newBlock = true;
            int skip = 0;
            iit = instructions.iterator();
            block11: while (iit.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)iit.next();
                int index = instructions.indexOf(insn);
                int bci = this.bcis[allToReal[index]];
                if (bci == skip) continue;
                if (this.insnToBB.get(insn) != null) {
                    skip = this.bcis[allToReal[instructions.indexOf(insn)]];
                }
                if (insn.getOpcode() < 0) continue;
                for (CharacterRangeTableAttribute.CRTEntry entry : this.method().getCharacterRangeTable().getEntries()) {
                    if (entry.startBCI() == bci) {
                        if ((entry.flags & 1) == 0) continue;
                        newBlock = false;
                        if (this.insnToBB.get(insn) != null) continue;
                        this.getBB(insn);
                        continue block11;
                    }
                    if (entry.endBCI() != index || (entry.flags & 0x10) == 0) continue;
                    newBlock = true;
                }
            }
        }
        Object[] basicBlocks = new BasicBlock[this.insnToBB.size()];
        int i = 0;
        for (Map.Entry<AbstractInsnNode, BasicBlock> entry : this.insnToBB.entrySet()) {
            BasicBlock bb = entry.getValue();
            if (bb.startBCI() < 0) {
                AbstractInsnNode insn = entry.getKey();
                int index = instructions.indexOf(insn);
                int bci = this.bcis[allToReal[index]];
                bb.setStartBCI(bci);
            }
            basicBlocks[i++] = bb;
        }
        Arrays.sort(basicBlocks);
        return basicBlocks;
    }

    private void computeEndBCIsAndFoldInExits(BasicBlock[] basicBlocks) {
        int ei = 0;
        BasicBlock prev = basicBlocks[0];
        for (int bi = 1; bi <= basicBlocks.length; ++bi) {
            int exitStart;
            int start;
            BasicBlock curr = null;
            if (bi == basicBlocks.length) {
                start = this.method().getBytecodeLength();
            } else {
                curr = basicBlocks[bi];
                start = curr.startBCI();
            }
            int prevStart = prev.startBCI();
            int prevEnd = start - 1;
            prev.setEndBCI(prevEnd);
            DataExit exit = null;
            if (ei < this.exits.size()) {
                exit = this.exits.get(ei);
                exitStart = exit.startBCI();
            } else {
                exitStart = -1;
            }
            if (exitStart >= prevStart && exitStart <= prevEnd) {
                prev.setExit(exit);
                ++ei;
            } else if (curr != null) {
                DataBlockFallThrough fall = new DataBlockFallThrough(curr.rootId());
                curr.add(fall);
            }
            prev = curr;
        }
        assert (ei == this.exits.size());
    }

    private void insertInstrumentation() {
        MethodNode methodNode = (MethodNode)this.mv;
        InsnList instructions = methodNode.instructions;
        for (Map.Entry<AbstractInsnNode, BasicBlock> entry : this.insnToBB.entrySet()) {
            DataBlock fallenInto;
            AbstractInsnNode insn = entry.getKey();
            BasicBlock bb = entry.getValue();
            Set<Map.Entry<DataBlock, LabelNode>> pairs = bb.blockLabelSet();
            int remaining = pairs.size();
            LabelNode realStuff = null;
            if (remaining > 1) {
                realStuff = new LabelNode();
            }
            if ((fallenInto = bb.fallenInto()) != null) {
                assert (bb.getLabel(fallenInto) == null);
                instructions.insertBefore(insn, Instrumenter.instrumentation(fallenInto, this.params.isDetectInternal()));
                if (--remaining > 0) {
                    instructions.insertBefore(insn, new JumpInsnNode(167, realStuff));
                }
            }
            for (Map.Entry<DataBlock, LabelNode> pair : pairs) {
                DataBlock block = pair.getKey();
                if (block.isFallenInto()) continue;
                LabelNode lnode = pair.getValue();
                assert (lnode != null);
                instructions.insertBefore(insn, lnode);
                instructions.insertBefore(insn, Instrumenter.instrumentation(block, this.params.isDetectInternal()));
                if (--remaining <= 0) continue;
                instructions.insertBefore(insn, new JumpInsnNode(167, realStuff));
            }
            if (realStuff != null) {
                instructions.insertBefore(insn, realStuff);
            }
            assert (remaining == 0);
        }
    }

    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        if (attr instanceof CharacterRangeTableAttribute) {
            this.method().setCharacterRangeTable((CharacterRangeTableAttribute)attr);
        }
    }

    public void visitEnd() {
        super.visitEnd();
        BasicBlock[] basicBlocks = this.completeComputationOfCodeLabelNodes();
        this.computeEndBCIsAndFoldInExits(basicBlocks);
        this.insertInstrumentation();
        this.method().setBasicBlocks(basicBlocks);
        MethodNode methodNode = (MethodNode)this.mv;
        methodNode.accept(this.nextVisitor);
    }

    private void debugDump() {
        MethodNode methodNode = (MethodNode)this.mv;
        InsnList instructions = methodNode.instructions;
        ListIterator iit = instructions.iterator();
        System.out.println(methodNode.name + "  ----");
        while (iit.hasNext()) {
            AbstractInsnNode instr = (AbstractInsnNode)iit.next();
            int opcode = instr.getOpcode();
            if (opcode >= 0) {
                System.out.print("        ");
                System.out.print(Constants.opcNames[opcode]);
                System.out.print("  ");
            }
            switch (instr.getType()) {
                case 15: {
                    System.out.print(((LineNumberNode)instr).line);
                    System.out.print("#");
                    break;
                }
                case 8: {
                    System.out.print(this.labelString((LabelNode)instr));
                    System.out.print(":");
                    break;
                }
                case 14: {
                    System.out.print("frame-");
                    break;
                }
                case 7: {
                    System.out.print(this.labelString(((JumpInsnNode)instr).label));
                    break;
                }
                case 171: {
                    AbstractInsnNode node = (LookupSwitchInsnNode)instr;
                    System.out.println();
                    System.out.print("            default: ");
                    System.out.print(this.labelString(node.dflt));
                    int len = node.labels.size();
                    for (int i = 0; i < len; ++i) {
                        LabelNode lnode = (LabelNode)node.labels.get(i);
                        Integer key = (Integer)node.keys.get(i);
                        System.out.println();
                        System.out.print("            ");
                        System.out.print(key);
                        System.out.print(": ");
                        System.out.print(this.labelString(lnode));
                    }
                    break;
                }
                case 11: {
                    AbstractInsnNode node = (TableSwitchInsnNode)instr;
                    System.out.println();
                    System.out.print("            default: ");
                    System.out.print(this.labelString(((TableSwitchInsnNode)node).dflt));
                    int len = ((TableSwitchInsnNode)node).labels.size();
                    int key = ((TableSwitchInsnNode)node).min;
                    for (int i = 0; i < len; ++i) {
                        LabelNode lnode = (LabelNode)((TableSwitchInsnNode)node).labels.get(i);
                        System.out.println();
                        System.out.print("            ");
                        System.out.print(key++);
                        System.out.print(": ");
                        System.out.print(this.labelString(lnode));
                    }
                    break;
                }
            }
            if (this.insnToBB.get(instr) != null) {
                System.out.println("  block [" + this.insnToBB.get(instr).startBCI() + ", " + this.insnToBB.get(instr).endBCI() + "]");
                continue;
            }
            System.out.println();
        }
    }

    private String labelString(LabelNode lnode) {
        Label lab = lnode.getLabel();
        return lab.toString();
    }
}

