/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.api;

import com.sun.tdk.jcov.api.Attribute;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDescr {
    public final String name;
    public final List<Attribute> attributes;

    public AbstractDescr(String name) {
        this.name = name;
        this.attributes = new ArrayList<Attribute>();
    }

    public void addAttribute(String name, String value) {
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(Attribute attr) {
        if (attr != null && !this.attributes.contains(attr)) {
            this.attributes.add(attr);
        }
    }

    public void removeAttribute(Attribute attr) {
        if (attr != null) {
            this.attributes.remove(attr);
        }
    }

    public String getAttribute(String attrName) {
        List<String> list = this.getAllAttributes(attrName);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<String> getAllAttributes(String attrName) {
        ArrayList<String> list = new ArrayList<String>();
        for (Attribute attr : this.attributes) {
            if (!attr.name.equals(attrName)) continue;
            list.add(attr.value);
        }
        return list;
    }
}

