/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.api;

import com.sun.tdk.jcov.api.APIReader;
import com.sun.tdk.jcov.api.ClassDescr;
import com.sun.tdk.jcov.api.FileFormatException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class API {
    private final HashMap<String, ClassDescr> classes = new HashMap();

    private API() {
        this(new ArrayList<ClassDescr>());
    }

    public API(List<ClassDescr> classList) {
        if (classList != null) {
            for (ClassDescr cls : classList) {
                this.addClass(cls);
            }
        }
    }

    public static API parseSigFile(String sigFileName, APIReader reader) throws IOException, FileFormatException {
        return API.parseSigFile(new File(sigFileName), reader);
    }

    public static API parseSigFile(File sigFile, APIReader reader) throws IOException, FileFormatException {
        API api = new API();
        for (ClassDescr cls : reader.read(sigFile)) {
            api.addClass(cls);
        }
        return api;
    }

    public ClassDescr getClass(String name) {
        return this.classes.get(name);
    }

    public void addClass(ClassDescr cls) {
        if (cls != null) {
            this.classes.put(cls.name, cls);
        }
    }

    public SortedSet<String> getAllClassNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.classes.keySet());
        return treeSet;
    }
}

