/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.Instr;
import com.sun.tdk.jcov.insert.AbstractUniversalInstrumenter;
import com.sun.tdk.jcov.instrument.ClassMorph;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.RuntimeUtils;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProductInstr
extends JCovCMDTool {
    static final Logger logger;
    private File instrProductDir;
    private File instrOutputDir;
    private String template = "template.xml";
    private String tempPath;
    private File rtLibFile;
    private String[] rtClassDirTargets;
    public static final OptionDescr DSC_INSTRUMENT;
    public static final OptionDescr DSC_INSTRUMENT_TO;
    public static final OptionDescr DSC_RT_TO;

    public void instrumentProduct() throws IOException {
        logger.log(Level.INFO, " - Instrumenting product");
        logger.log(Level.CONFIG, "Product location: ''{0}'', target location: ''{1}''", new Object[]{this.instrProductDir.getPath(), this.instrOutputDir.getPath()});
        this.tempPath = this.instrProductDir.getPath() + RuntimeUtils.genSuffix();
        this.createTempDir();
        AbstractUniversalInstrumenter instrumenter = this.setupInstrumenter();
        this.instrOutputDir.mkdir();
        instrumenter.instrument(this.instrProductDir, this.instrOutputDir, this.rtLibFile.getAbsolutePath(), this.rtClassDirTargets == null ? null : new ArrayList<String>(Arrays.asList(this.rtClassDirTargets)), true);
        instrumenter.finishWork();
        this.removeTempDir();
    }

    private AbstractUniversalInstrumenter setupInstrumenter() {
        InstrumentationParams params = new InstrumentationParams(false, false, true, null, null, InstrumentationOptions.InstrumentationMode.BRANCH).setInstrumentAnonymous(true).setInstrumentSynthetic(false);
        final ClassMorph morph = new ClassMorph(params, null);
        return new AbstractUniversalInstrumenter(true){

            protected byte[] instrument(byte[] classData, int classLength) throws IOException {
                return morph.morph(this.classBuf, null, ProductInstr.this.tempPath);
            }

            public void finishWork() {
                morph.saveData(ProductInstr.this.template, null, InstrumentationOptions.MERGE.OVERWRITE);
            }
        };
    }

    private void createTempDir() {
        new File(this.tempPath).mkdir();
        logger.log(Level.INFO, "Temp directory for storing instrumented classes created: ''{0}''. Automatic removal is not implemented yet so please remove it manually after all is done.", this.tempPath);
    }

    private void removeTempDir() {
        File tempFile = new File(this.tempPath);
        if (tempFile.isDirectory()) {
            Utils.deleteDirectory(tempFile);
        } else {
            tempFile.delete();
        }
        logger.log(Level.INFO, "Temp directory for storing instrumented classes deleted: ''{0}''.", this.tempPath);
    }

    protected int run() throws Exception {
        this.instrumentProduct();
        return 0;
    }

    protected EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_INSTRUMENT, DSC_INSTRUMENT_TO, Instr.DSC_INCLUDE_RT, DSC_RT_TO}, (JCovTool)this);
    }

    protected int handleEnv(EnvHandler envHandler) throws JCovTool.EnvHandlingException {
        this.instrProductDir = Utils.checkFileCanBeNull(envHandler.getValue(DSC_INSTRUMENT), "product directory", Utils.CheckOptions.FILE_ISDIR, Utils.CheckOptions.FILE_CANREAD);
        this.instrOutputDir = Utils.checkFileCanBeNull(envHandler.getValue(DSC_INSTRUMENT_TO), "directory for instrumented product", Utils.CheckOptions.FILE_NOTEXISTS, Utils.CheckOptions.FILE_CANWRITE);
        if (this.instrProductDir != null && this.instrOutputDir == null) {
            throw new JCovTool.EnvHandlingException("Output directory for instrumented files should be specified in '-instrOutput'");
        }
        this.rtLibFile = Utils.checkFileCanBeNull(envHandler.getValue(Instr.DSC_INCLUDE_RT), "JCov RT Saver path", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_CANREAD);
        if (this.rtLibFile == null) {
            throw new JCovTool.EnvHandlingException("Please specify saver location with '-rt' option");
        }
        this.rtClassDirTargets = envHandler.getValues(DSC_RT_TO);
        return 0;
    }

    protected String getDescr() {
        return "";
    }

    protected String usageString() {
        return "";
    }

    protected String exampleString() {
        return "";
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(ProductInstr.class.getName());
        DSC_INSTRUMENT = new OptionDescr("product", "", 1, "");
        DSC_INSTRUMENT_TO = new OptionDescr("productOutput", "", 1, "");
        DSC_RT_TO = new OptionDescr("rtTo", "", 2, "");
    }
}

