/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.Instr;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JREInstr
extends JCovCMDTool {
    private Instr instr;
    private File toInstrument;
    private File[] addJars;
    private File[] addTests;
    private File implant;
    private File javac;
    private String[] callerInclude;
    private String[] callerExclude;
    private static final Logger logger;
    private String host = null;
    private Integer port = null;
    public static final OptionDescr DSC_JAVAC_HACK;
    public static final OptionDescr DCS_ADD_JAR;
    public static final OptionDescr DCS_ADD_TESTS;
    static final OptionDescr DSC_HOST;
    static final OptionDescr DSC_PORT;

    protected int run() throws Exception {
        int i;
        String[] toInstr = new String[]{this.toInstrument.getAbsolutePath()};
        Utils.addToClasspath(toInstr);
        this.instr.startWorking();
        StaticJREInstrClassLoader cl = new StaticJREInstrClassLoader(new URL[]{this.toInstrument.toURI().toURL()});
        this.instr.setClassLoader(cl);
        this.instr.instrumentFile(this.toInstrument.getAbsolutePath(), null, this.implant.getAbsolutePath());
        ArrayList<String> srcs = null;
        if (this.addJars != null) {
            srcs = new ArrayList<String>();
            for (i = 0; i < this.addJars.length; ++i) {
                srcs.add(this.addJars[i].getAbsolutePath());
            }
        }
        if (this.addTests != null) {
            if (srcs == null) {
                srcs = new ArrayList();
            }
            for (i = 0; i < this.addTests.length; ++i) {
                srcs.add(this.addTests[i].getAbsolutePath());
            }
        }
        if (srcs != null) {
            Utils.addToClasspath(srcs.toArray(new String[0]));
            this.instr.instrumentFiles(srcs.toArray(new String[0]), null, null);
        }
        this.instr.finishWork();
        return 0;
    }

    protected EnvHandler defineHandler() {
        Instr.DSC_INCLUDE_RT.usage = "To run instrumented JRE you should implant JCov runtime library both into rt.jar and into 'lib/endorsed' directory.\nWhen instrumenting whole JRE dir with jreinstr tool - these 2 actions will be done automatically.";
        return new EnvHandler(new OptionDescr[]{Instr.DSC_INCLUDE_RT, Instr.DSC_VERBOSE, InstrumentationOptions.DSC_TYPE, InstrumentationOptions.DSC_INCLUDE, InstrumentationOptions.DSC_INCLUDE_LIST, InstrumentationOptions.DSC_EXCLUDE, InstrumentationOptions.DSC_EXCLUDE_LIST, InstrumentationOptions.DSC_CALLER_INCLUDE, InstrumentationOptions.DSC_CALLER_EXCLUDE, InstrumentationOptions.DSC_TEMPLATE, InstrumentationOptions.DSC_ABSTRACT, InstrumentationOptions.DSC_NATIVE, InstrumentationOptions.DSC_FIELD, InstrumentationOptions.DSC_SYNTHETIC, InstrumentationOptions.DSC_ANONYM, InstrumentationOptions.DSC_INNERINVOCATION, Instr.DSC_SUBSEQUENT, DSC_JAVAC_HACK, DCS_ADD_JAR, DCS_ADD_TESTS, DSC_HOST, DSC_PORT}, (JCovTool)this);
    }

    protected int handleEnv(EnvHandler envHandler) throws JCovTool.EnvHandlingException {
        File f;
        block59: {
            int i;
            this.instr = new Instr();
            String[] tail = envHandler.getTail();
            if (tail == null || tail.length == 0) {
                throw new JCovTool.EnvHandlingException("JRE dir is not specified");
            }
            if (tail.length > 1) {
                logger.log(Level.WARNING, "Only first argument ({0}) will be used", tail[0]);
            }
            if (!envHandler.isSet(Instr.DSC_INCLUDE_RT)) {
                throw new JCovTool.EnvHandlingException("Runtime should be always implanted when instrumenting rt.jar (e.g. '-rt jcov_j2se_rt.jar')");
            }
            this.implant = new File(envHandler.getValue(Instr.DSC_INCLUDE_RT));
            Utils.checkFile(this.implant, "JCovRT library jarfile", Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_CANREAD);
            if (envHandler.isSet(DCS_ADD_JAR)) {
                String[] jars = envHandler.getValues(DCS_ADD_JAR);
                this.addJars = new File[jars.length];
                for (i = 0; i < this.addJars.length; ++i) {
                    this.addJars[i] = new File(jars[i]);
                    if (!this.addJars[i].exists()) {
                        throw new JCovTool.EnvHandlingException("Additional jar " + jars[i] + " doesn't exist");
                    }
                    if (this.addJars[i].canRead()) continue;
                    throw new JCovTool.EnvHandlingException("Can't read additional jar " + jars[i]);
                }
            }
            if (envHandler.isSet(DCS_ADD_TESTS)) {
                String[] files = envHandler.getValues(DCS_ADD_TESTS);
                this.addTests = new File[files.length];
                for (i = 0; i < this.addTests.length; ++i) {
                    this.addTests[i] = new File(files[i]);
                    if (!this.addTests[i].exists()) {
                        throw new JCovTool.EnvHandlingException("Test file " + files[i] + " doesn't exist");
                    }
                    if (this.addTests[i].canRead()) continue;
                    throw new JCovTool.EnvHandlingException("Can't read test file " + files[i]);
                }
            }
            f = new File(tail[0]);
            Utils.checkFile(f, "JRE directory", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_ISDIR, Utils.CheckOptions.FILE_CANREAD);
            if (envHandler.isSet(DSC_HOST)) {
                this.host = envHandler.getValue(DSC_HOST);
            }
            if (envHandler.isSet(DSC_PORT)) {
                try {
                    this.port = Integer.valueOf(envHandler.getValue(DSC_PORT));
                }
                catch (NumberFormatException nfe) {
                    throw new JCovTool.EnvHandlingException("Specify correct port number");
                }
            }
            if (envHandler.isSet(DSC_JAVAC_HACK)) {
                OutputStreamWriter out;
                File newFile;
                String javacPath = envHandler.getValue(DSC_JAVAC_HACK);
                this.javac = new File(javacPath);
                File newJavac = null;
                boolean isWin = false;
                if (javacPath.endsWith(".exe") && System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                    newJavac = new File(this.javac.getParent() + File.separator + "javac_real.exe");
                    isWin = true;
                } else {
                    newJavac = new File(this.javac.getParent() + File.separator + "javac_real");
                }
                if (newJavac.exists()) {
                    if (this.javac.exists()) {
                        logger.log(Level.INFO, "javac seems to be already hacked: {0} exists", newJavac.getPath());
                    } else {
                        try {
                            if (!isWin) {
                                newFile = new File(javacPath);
                                out = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), Charset.forName("UTF-8"));
                                out.write(newJavac.getAbsolutePath() + " -J-Xms30m \"$@\"");
                                out.flush();
                                out.close();
                                try {
                                    newFile.setExecutable(true);
                                }
                                catch (Exception e) {
                                    logger.log(Level.WARNING, "Can't make new hacked javac file executable: {0}", e.getMessage());
                                }
                                break block59;
                            }
                            newFile = new File(javacPath.replaceAll(".exe", ".bat"));
                            out = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), Charset.forName("UTF-8"));
                            out.write(newJavac.getAbsolutePath() + " -J-Xms30m %*");
                            out.flush();
                            out.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(JREInstr.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                } else {
                    if (!this.javac.exists()) {
                        throw new JCovTool.EnvHandlingException("Specified javac doesn't exist (" + javacPath + ")");
                    }
                    if (!this.javac.isFile()) {
                        throw new JCovTool.EnvHandlingException("Specified javac is not a file (" + javacPath + ")");
                    }
                    if (!this.javac.canWrite()) {
                        throw new JCovTool.EnvHandlingException("Can't modify specified javac (" + javacPath + ")");
                    }
                    if (!this.javac.renameTo(newJavac)) {
                        throw new JCovTool.EnvHandlingException("Can't move specified javac to new location (" + javacPath + " to " + newJavac.getPath() + ")");
                    }
                    try {
                        if (!isWin) {
                            newFile = new File(javacPath);
                            out = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), Charset.forName("UTF-8"));
                            out.write(newJavac.getAbsolutePath() + " $@ -J-Xms30m");
                            out.flush();
                            out.close();
                            try {
                                newFile.setExecutable(true);
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "Can't make new hacked javac file executable: {0}", e.getMessage());
                            }
                        } else {
                            newFile = new File(javacPath.replaceAll(".exe", ".bat"));
                            out = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), Charset.forName("UTF-8"));
                            out.write(newJavac.getAbsolutePath() + " -J-Xms30m %*");
                            out.flush();
                            out.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JREInstr.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        if (!f.isDirectory()) {
            throw new JCovTool.EnvHandlingException("Specified JRE is not a directory: " + f.getPath());
        }
        File lib = new File(f, "lib");
        if (!lib.exists()) {
            throw new JCovTool.EnvHandlingException("lib directory was not found in JRE directory");
        }
        this.toInstrument = new File(lib, "rt.jar");
        if (!this.toInstrument.exists()) {
            throw new JCovTool.EnvHandlingException("rt.jar directory was not found in lib directory");
        }
        if (!(this.toInstrument.isFile() && this.toInstrument.canRead() && this.toInstrument.canWrite())) {
            throw new JCovTool.EnvHandlingException("Can't read/write rt.jar (or not a file)");
        }
        File bak = new File(lib, "rt.jar.bak");
        if (!bak.exists()) {
            try {
                Utils.copyFile(this.toInstrument, bak);
            }
            catch (FileNotFoundException ex) {
                throw new JCovTool.EnvHandlingException("Error while backuping rt.jar: file not found", ex);
            }
            catch (IOException ex) {
                throw new JCovTool.EnvHandlingException("Error while backuping rt.jar", ex);
            }
        } else if (!envHandler.isSet(Instr.DSC_SUBSEQUENT)) {
            throw new JCovTool.EnvHandlingException("Backup rt.jar.bak file exisit. It can mean that JRE is already instrumented - nothing to do. Restore initial rt.jar or delete bak file.");
        }
        File endorsed = new File(lib, "endorsed");
        if (!endorsed.exists()) {
            endorsed.mkdir();
        } else if (!endorsed.isDirectory()) {
            throw new JCovTool.EnvHandlingException("JRE/lib/endorsed is not a directory");
        }
        File implantcopy = new File(endorsed, this.implant.getName());
        try {
            Utils.copyFile(this.implant, implantcopy);
            if (this.host != null || this.port != null) {
                Properties prop = new Properties();
                try {
                    if (this.host != null) {
                        prop.setProperty("host", this.host);
                    }
                    if (this.port != null) {
                        prop.setProperty("port", Integer.toString(this.port));
                    }
                    prop.store(new FileOutputStream(endorsed.getAbsolutePath() + File.separator + "jcov_network_default.properties"), null);
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Cannot create property file to save host and port: {0}", ex);
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new JCovTool.EnvHandlingException("Error while copying implant file to endorsed dir: file not found", ex);
        }
        catch (IOException ex) {
            throw new JCovTool.EnvHandlingException("Error while copying implant file to endorsed dir", ex);
        }
        String[] excludes = InstrumentationOptions.handleExclude(envHandler);
        String[] includes = InstrumentationOptions.handleInclude(envHandler);
        Utils.Pattern[] pats = Utils.concatFilters(includes, excludes);
        this.callerInclude = envHandler.getValues(InstrumentationOptions.DSC_CALLER_INCLUDE);
        this.callerExclude = envHandler.getValues(InstrumentationOptions.DSC_CALLER_EXCLUDE);
        if (!Utils.accept(pats, null, "/java/lang/Shutdown", null)) {
            logger.log(Level.WARNING, "java.lang.Shutdown automatically included to instrumentation (it can't be excluded in jreinstr)");
            if (includes.length > 0) {
                includes = Utils.copyOf(includes, includes.length + 1);
                includes[includes.length - 1] = "/java/lang/Shutdown";
            } else {
                includes = new String[]{"/java/lang/Shutdown", "/*"};
            }
        }
        int ret = this.instr.handleEnv(envHandler);
        this.instr.setSave_end(new String[]{"java/lang/Shutdown.runHooks"});
        this.instr.setInclude(includes);
        this.instr.setExclude(excludes);
        this.instr.setCallerInclude(this.callerInclude);
        this.instr.setCallerExclude(this.callerExclude);
        return ret;
    }

    protected String getDescr() {
        return "instrumenter designed for instumenting rt.jar";
    }

    protected String usageString() {
        return "java -jar jcov.jar jreinstr -implantrt <runtime_to_implant> <jre_dir>";
    }

    protected String exampleString() {
        return "To instrument JRE: \"java -jar jcov.jar jreinstr -implantrt jcov_j2se_rt.jar JDK1.7.0/jre\"";
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(Instr.class.getName());
        DSC_JAVAC_HACK = new OptionDescr("javac", "hack javac", 1, "Hack javac to increase minimum VM memory used on initialization. Should be used on Solaris platform or should be done manually. ");
        DCS_ADD_JAR = new OptionDescr("addjar", new String[]{"add"}, "instrument additional jars", 2, "Instrument additional jars within JRE or JDK. Only jar files are allowed.");
        DCS_ADD_TESTS = new OptionDescr("addtests", new String[]{"tests"}, "instrument tests", 2, "Instrument tests files (classes and jars).");
        DSC_HOST = new OptionDescr("host", new String[]{"host"}, "sets default host", 1, "set the default host for sending jcov data. needed only in network mode");
        DSC_PORT = new OptionDescr("port", new String[]{"port"}, "sets default port", 1, "set the default port for sending jcov data. needed only in network mode");
    }

    public class StaticJREInstrClassLoader
    extends URLClassLoader {
        StaticJREInstrClassLoader(URL[] urls) {
            super(urls);
        }

        public InputStream getResourceAsStream(String s) {
            InputStream in = null;
            try {
                in = this.findResource(s).openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (in != null) {
                return in;
            }
            return super.getResourceAsStream(s);
        }
    }
}

