/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.insert.AbstractUniversalInstrumenter;
import com.sun.tdk.jcov.instrument.ClassMorph;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.LoggingFormatter;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instr
extends JCovCMDTool {
    private String[] include = new String[]{".*"};
    private String[] exclude = new String[]{""};
    private String[] callerInclude;
    private String[] callerExclude;
    private String[] save_beg = null;
    private String[] save_end = null;
    private boolean genabstract = false;
    private boolean gennative = false;
    private boolean genfield = false;
    private boolean gensynthetic = true;
    private boolean genanonymous = true;
    private boolean innerinvocations = true;
    private String[] srcs;
    private File outDir;
    private String include_rt;
    private String template;
    private String flushPath;
    private boolean subsequentInstr = false;
    private boolean recurse;
    private InstrumentationOptions.InstrumentationMode mode = InstrumentationOptions.InstrumentationMode.BRANCH;
    private AbstractUniversalInstrumenter instrumenter;
    private ClassMorph morph;
    private ClassLoader cl = null;
    private static final Logger logger;
    static final OptionDescr DSC_OUTPUT;
    static final OptionDescr DSC_VERBOSE;
    static final OptionDescr DSC_INCLUDE_RT;
    static final OptionDescr DSC_SUBSEQUENT;
    static final OptionDescr DSC_RECURSE;

    public void instrumentAll(File[] files, File outDir, String includeRTJar) throws IOException {
        this.instrumentFiles(files, outDir, includeRTJar);
        this.instrumenter.finishWork();
    }

    public void instrumentAll(File[] files, File outDir) throws IOException {
        this.instrumentAll(files, outDir, null);
    }

    public void instrumentFile(File file, File outDir, String includeRTJar) throws IOException {
        this.setDefaultInstrumenter();
        this.instrumenter.instrument(file, outDir, includeRTJar, this.recurse);
    }

    public void instrumentFile(String file, File outDir, String includeRTJar) throws IOException {
        this.instrumentFile(new File(file), outDir, includeRTJar);
    }

    public void instrumentFiles(File[] files, File outDir, String implantRT) throws IOException {
        this.setDefaultInstrumenter();
        for (File file : files) {
            this.instrumenter.instrument(file, outDir, implantRT, this.recurse);
        }
    }

    public void instrumentFiles(String[] files, File outDir, String implantRT) throws IOException {
        this.setDefaultInstrumenter();
        for (String file : files) {
            this.instrumenter.instrument(new File(file), outDir, implantRT, this.recurse);
        }
    }

    public void startWorking() {
        this.setDefaultInstrumenter();
    }

    private void setDefaultInstrumenter() {
        if (this.morph == null) {
            InstrumentationParams params = new InstrumentationParams(this.gennative, this.genfield, this.genabstract, this.include, this.exclude, this.callerInclude, this.callerExclude, this.mode, this.save_beg, this.save_end).setInstrumentSynthetic(this.gensynthetic).setInstrumentAnonymous(this.genanonymous).setInnerInvocations(this.innerinvocations);
            this.morph = this.subsequentInstr ? new ClassMorph(params, this.template) : new ClassMorph(params, null);
        }
        if (this.instrumenter == null) {
            this.instrumenter = new AbstractUniversalInstrumenter(true){

                protected byte[] instrument(byte[] classData, int classLen) throws IOException {
                    return Instr.this.morph.morph(classData, Instr.this.cl, Instr.this.flushPath);
                }

                public void finishWork() {
                    if (Instr.this.subsequentInstr) {
                        Instr.this.morph.saveData(InstrumentationOptions.MERGE.MERGE);
                    } else {
                        Instr.this.morph.saveData(Instr.this.template, null, InstrumentationOptions.MERGE.OVERWRITE);
                    }
                }
            };
        }
    }

    public void setInstrumenter(AbstractUniversalInstrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void finishWork() {
        if (this.instrumenter != null) {
            this.instrumenter.finishWork();
        }
    }

    public void finishWork(String outTemplate) {
        if (this.instrumenter != null) {
            if (this.subsequentInstr) {
                this.morph.saveData(outTemplate, InstrumentationOptions.MERGE.MERGE);
            } else {
                this.morph.saveData(outTemplate, null, InstrumentationOptions.MERGE.OVERWRITE);
            }
        }
    }

    public static void main(String[] args) {
        Instr tool = new Instr();
        try {
            int res = tool.run(args);
            System.exit(res);
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    protected String usageString() {
        return "java com.sun.tdk.jcov.Instr [-option value] target";
    }

    protected String exampleString() {
        return "java -cp jcov.jar com.sun.tdk.jcov.Instr -include java.lang.* -type block -output classes_instrumented classes";
    }

    protected String getDescr() {
        return "instruments classfiles and creates template.xml";
    }

    public void setVerbose(boolean b) {
        if (b) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.WARNING);
        }
    }

    public void resetDefaults() {
        try {
            this.handleEnv_(this.defineHandler());
        }
        catch (JCovTool.EnvHandlingException envHandlingException) {
            // empty catch block
        }
    }

    public boolean isGenAbstract() {
        return this.genabstract;
    }

    public void setGenAbstract(boolean abstact) {
        this.genabstract = abstact;
    }

    public String[] getExclude() {
        return this.exclude;
    }

    public void setExclude(String[] exclude) {
        this.exclude = exclude;
    }

    public boolean isGenField() {
        return this.genfield;
    }

    public void setGenField(boolean field) {
        this.genfield = field;
    }

    public boolean isGenNative() {
        return this.gennative;
    }

    public void setGenNative(boolean gennative) {
        this.gennative = gennative;
    }

    public String[] getInclude() {
        return this.include;
    }

    public void setInclude(String[] include) {
        this.include = include;
    }

    public void setCallerInclude(String[] callerInclude) {
        this.callerInclude = callerInclude;
    }

    public void setCallerExclude(String[] callerExclude) {
        this.callerExclude = callerExclude;
    }

    public void setFilter(String[] include, String[] exclude) {
        this.include = include;
        this.exclude = exclude;
    }

    public String[] getSave_beg() {
        return this.save_beg;
    }

    public void setSave_beg(String[] save_beg) {
        this.save_beg = save_beg;
    }

    public String[] getSave_end() {
        return this.save_end;
    }

    public void setSave_end(String[] save_end) {
        this.save_end = save_end;
    }

    public void setMode(InstrumentationOptions.InstrumentationMode mode) {
        this.mode = mode;
    }

    public InstrumentationOptions.InstrumentationMode getMode() {
        return this.mode;
    }

    public void config(boolean genabstract, boolean genfield, boolean gennative, String[] saveBegin, String[] saveEnd) {
        this.setGenNative(gennative);
        this.setGenAbstract(genabstract);
        this.setGenField(genfield);
        this.setSave_beg(this.save_beg);
        this.setSave_end(this.save_end);
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean isSubsequentInstr() {
        return this.subsequentInstr;
    }

    public void setSubsequentInstr(boolean subsequentInstr) {
        this.subsequentInstr = subsequentInstr;
    }

    public void setFlushPath(String flushPath) {
        this.flushPath = flushPath;
    }

    public String getFlushPath() {
        return this.flushPath;
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    protected int run() throws Exception {
        Utils.addToClasspath(this.srcs);
        try {
            this.instrumentFiles(this.srcs, this.outDir, this.include_rt);
            this.finishWork(this.template);
        }
        catch (IOException ex) {
            LoggingFormatter.printStackTrace = true;
            throw new Exception("Critical exception: ", ex);
        }
        return 0;
    }

    protected EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_OUTPUT, DSC_VERBOSE, InstrumentationOptions.DSC_TYPE, InstrumentationOptions.DSC_INCLUDE, InstrumentationOptions.DSC_INCLUDE_LIST, InstrumentationOptions.DSC_EXCLUDE, InstrumentationOptions.DSC_CALLER_INCLUDE, InstrumentationOptions.DSC_CALLER_EXCLUDE, InstrumentationOptions.DSC_EXCLUDE_LIST, InstrumentationOptions.DSC_SAVE_BEGIN, InstrumentationOptions.DSC_SAVE_AT_END, InstrumentationOptions.DSC_TEMPLATE, DSC_SUBSEQUENT, InstrumentationOptions.DSC_ABSTRACT, InstrumentationOptions.DSC_NATIVE, InstrumentationOptions.DSC_FIELD, InstrumentationOptions.DSC_SYNTHETIC, InstrumentationOptions.DSC_ANONYM, InstrumentationOptions.DSC_INNERINVOCATION, ClassMorph.DSC_FLUSH_CLASSES, DSC_INCLUDE_RT, DSC_RECURSE}, (JCovTool)this);
    }

    private int handleEnv_(EnvHandler opts) throws JCovTool.EnvHandlingException {
        if (opts.isSet(DSC_VERBOSE)) {
            this.setVerbose(true);
        }
        this.outDir = null;
        if (opts.isSet(DSC_OUTPUT)) {
            this.outDir = new File(opts.getValue(DSC_OUTPUT));
            Utils.checkFile(this.outDir, "output directory", Utils.CheckOptions.FILE_NOTISFILE);
            if (!this.outDir.exists()) {
                this.outDir.mkdirs();
                logger.log(Level.INFO, "The directory {0} was created.", this.outDir.getAbsolutePath());
            }
        }
        this.save_beg = opts.getValues(InstrumentationOptions.DSC_SAVE_BEGIN);
        this.save_end = opts.getValues(InstrumentationOptions.DSC_SAVE_AT_END);
        String abstractValue = opts.getValue(InstrumentationOptions.DSC_ABSTRACT);
        if (abstractValue.equals("off")) {
            this.genabstract = false;
        } else if (abstractValue.equals("on")) {
            this.genabstract = true;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_ABSTRACT.name + "' parameter value error: expected 'on' or 'off'; found: '" + abstractValue + "'");
        }
        String nativeValue = opts.getValue(InstrumentationOptions.DSC_NATIVE);
        if (nativeValue.equals("on")) {
            this.gennative = true;
        } else if (nativeValue.equals("off")) {
            this.gennative = false;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_NATIVE.name + "' parameter value error: expected 'on' or 'off'; found: '" + nativeValue + "'");
        }
        String fieldValue = opts.getValue(InstrumentationOptions.DSC_FIELD);
        if (fieldValue.equals("on")) {
            this.genfield = true;
        } else if (fieldValue.equals("off")) {
            this.genfield = false;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_FIELD.name + "' parameter value error: expected 'on' or 'off'; found: '" + fieldValue + "'");
        }
        String anonym = opts.getValue(InstrumentationOptions.DSC_ANONYM);
        this.genanonymous = anonym.equals("on");
        String synthetic = opts.getValue(InstrumentationOptions.DSC_SYNTHETIC);
        this.gensynthetic = synthetic.equals("on");
        String innerInvocation = opts.getValue(InstrumentationOptions.DSC_INNERINVOCATION);
        this.innerinvocations = !"off".equals(innerInvocation);
        this.callerInclude = opts.getValues(InstrumentationOptions.DSC_CALLER_INCLUDE);
        this.callerExclude = opts.getValues(InstrumentationOptions.DSC_CALLER_EXCLUDE);
        this.recurse = opts.isSet(DSC_RECURSE);
        this.mode = InstrumentationOptions.InstrumentationMode.fromString(opts.getValue(InstrumentationOptions.DSC_TYPE));
        this.template = opts.getValue(InstrumentationOptions.DSC_TEMPLATE);
        Utils.checkFileNotNull(this.template, "template filename", Utils.CheckOptions.FILE_NOTISDIR, Utils.CheckOptions.FILE_PARENTEXISTS);
        this.subsequentInstr = opts.isSet(DSC_SUBSEQUENT);
        this.include = InstrumentationOptions.handleInclude(opts);
        this.exclude = InstrumentationOptions.handleExclude(opts);
        this.flushPath = opts.getValue(ClassMorph.DSC_FLUSH_CLASSES);
        if ("none".equals(this.flushPath)) {
            this.flushPath = null;
        }
        this.include_rt = opts.getValue(DSC_INCLUDE_RT);
        Utils.checkFileCanBeNull(this.include_rt, "JCovRT library jarfile", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_CANREAD);
        return 0;
    }

    protected int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        this.srcs = opts.getTail();
        if (this.srcs == null || this.srcs.length == 0) {
            throw new JCovTool.EnvHandlingException("No sources specified");
        }
        return this.handleEnv_(opts);
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(Instr.class.getName());
        DSC_OUTPUT = new OptionDescr("instr.output", new String[]{"output", "o"}, "Output directory for instrumented classes", 1, "Specifies output directory, default directory is current. Instr command could process different dirs and different jars: \n all classes from input dirs and all jars will be placed in output directory.");
        DSC_VERBOSE = new OptionDescr("verbose", "Verbose mode", "Enable verbose mode.");
        DSC_INCLUDE_RT = new OptionDescr("implantrt", new String[]{"rt"}, "Runtime management", 1, "Allows to implant needed for runtime files into instrumented data: -includert jcov_rt.jar");
        DSC_SUBSEQUENT = new OptionDescr("subsequent", "", 0, "Template would be used to decide what should not be instrumented - all existing in template would be treated as already instrumented");
        DSC_RECURSE = new OptionDescr("recursive", "", 0, "Recurse through specified directories instrumenting everything inside. With -flush option it will be able to instrument duplicate classes. ");
    }
}

