/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrabberManager
extends JCovCMDTool {
    private LinkedList<ServerCommand> commands;
    private int waittime = 5;
    static final OptionDescr DSC_HOSTNAME = new OptionDescr("host", new String[]{"hostname"}, "Connection parameters", 1, "Specify servers host to connect.", "localhost");
    static final OptionDescr DSC_PORT = new OptionDescr("command_port", new String[]{"port"}, "", 1, "Specify servers command port.", Integer.toString(3336));
    static final OptionDescr DSC_FILE = new OptionDescr("grabber.props", "", 1, "Read server properties from a file. Host should be specified explicitly.");
    static final OptionDescr DSC_WAITTIME = new OptionDescr("waittime", new String[]{"time", "t"}, "", 1, "Max time in seconds to wait for Grabber startup. Note that Manager will do 4 attempts to connect the Grabber");
    static final ServerCommand COMM_KILL = new ServerCommand("kill", new String[]{"stop"}, "Manage running server", 0, "Stop running server saving data and waining for all connections close.", 1);
    static final ServerCommand COMM_KILL_FORCE = new ServerCommand("fkill", new String[]{"fstop"}, "", 0, "Stop running server not saving data and not waining for all connections close.", 2);
    static final ServerCommand COMM_SAVE = new ServerCommand("save", new String[]{"flush"}, "", 0, "Save data to file.", 3);
    static final ServerCommand COMM_STATUS = new ServerCommand("status", null, "", 0, "Print server status.", 4);
    static final ServerCommand COMM_WAIT = new ServerCommand("wait", null, "", 0, "Wait server for starting.", 5);
    static final Logger logger;
    private int port;
    private String host;

    protected int run() throws Exception {
        if (this.commands == null || this.commands.size() == 0) {
            throw new Exception("No commands specified");
        }
        try {
            for (ServerCommand command : this.commands) {
                String status;
                String[] split;
                String gotstatus;
                if (command == COMM_WAIT) {
                    gotstatus = this.sendWaitCommand();
                    if (gotstatus == null) {
                        throw new Exception("Server didn't respond");
                    }
                    split = gotstatus.split(";", -1);
                    if (split.length != 4) {
                        throw new Exception("Server sent malformed status: " + gotstatus);
                    }
                    status = "Server started on " + split[1] + ":" + split[2] + ". Command listener at port " + this.port + ". Used template " + split[3] + ".";
                    System.out.println(status);
                    continue;
                }
                if (command == COMM_STATUS) {
                    gotstatus = this.sendStatusCommand();
                    split = gotstatus.split(";", -1);
                    if (split.length != 8) {
                        throw new Exception("Got malformed status from the server: " + gotstatus);
                    }
                    status = "Server " + (Boolean.parseBoolean(split[0]) ? "is working. Got " + Integer.parseInt(split[1]) + " connections, " + Integer.parseInt(split[2]) + " are alive. " + (Boolean.parseBoolean(split[3]) ? "No unsaved data. " : "Data is not saved. ") : "is not working. ") + "Server was started with options '" + split[4] + "' \n" + "        working directory: " + split[5] + "\n" + "        current template used: " + split[6] + "\n" + "        output file to be created on exit: " + split[7] + "\n";
                    System.out.println("Status: " + status);
                    continue;
                }
                if (command == COMM_SAVE) {
                    this.sendSaveCommand();
                    System.out.println("Save: OK");
                    continue;
                }
                if (command == COMM_KILL_FORCE) {
                    this.sendForceKillCommand();
                    System.out.println("Forced kill: OK");
                    continue;
                }
                if (command != COMM_KILL) continue;
                this.sendKillCommand();
                System.out.println("Kill: OK");
            }
        }
        catch (UnknownHostException e) {
            throw new Exception("Can't resolve hostname '" + this.host + "'");
        }
        catch (IOException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Connection refused")) {
                throw new Exception("Server not responding on command port " + this.port);
            }
            throw e;
        }
        return 0;
    }

    protected EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_HOSTNAME, DSC_PORT, DSC_FILE, DSC_WAITTIME, COMM_KILL, COMM_KILL_FORCE, COMM_SAVE, COMM_STATUS, COMM_WAIT}, (JCovTool)this);
    }

    protected int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        String file = opts.getValue(DSC_FILE);
        Utils.checkFileCanBeNull(file, "properties filename", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_CANREAD);
        if (file != null) {
            try {
                this.initPortFromFile(file);
            }
            catch (IOException ex) {
                throw new JCovTool.EnvHandlingException("Error while reading properties file: ", ex);
            }
        } else {
            this.setPort(Utils.checkedToInt(opts.getValue(DSC_PORT), "port number", new Utils.CheckOptions[0]));
        }
        this.host = opts.getValue(DSC_HOSTNAME);
        Utils.checkHostCanBeNull(this.host, "grabber host");
        this.commands = new LinkedList();
        if (opts.isSet(COMM_WAIT)) {
            this.commands.add(COMM_WAIT);
        }
        if (opts.isSet(COMM_STATUS)) {
            this.commands.add(COMM_STATUS);
        }
        if (opts.isSet(COMM_SAVE)) {
            this.commands.add(COMM_SAVE);
        }
        if (opts.isSet(COMM_KILL_FORCE)) {
            this.commands.add(COMM_KILL_FORCE);
        }
        if (opts.isSet(COMM_KILL)) {
            this.commands.add(COMM_KILL);
        }
        if (this.commands.size() == 0) {
            throw new JCovTool.EnvHandlingException("Command was not specified");
        }
        if (opts.isSet(DSC_WAITTIME)) {
            this.waittime = Utils.checkedToInt(opts.getValue(DSC_WAITTIME), "time to wait value", new Utils.CheckOptions[0]);
        }
        return 0;
    }

    public static void main(String[] args) {
        GrabberManager tool = new GrabberManager();
        try {
            int res = tool.run(args);
            System.exit(res);
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    public GrabberManager() {
        this(3336, "localhost");
    }

    public GrabberManager(int port, String host) {
        this.port = port;
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendCode(int code) throws IOException {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
            OutputStream out = socket.getOutputStream();
            out.write(code);
            socket.getInputStream().read();
            socket.getInputStream().close();
            out.close();
            Object var5_4 = null;
            if (socket == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (socket == null) throw throwable;
            socket.close();
            throw throwable;
        }
        socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String recieveCode(int code) throws IOException {
        String data = null;
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
            OutputStream out = socket.getOutputStream();
            out.write(code);
            InputStream in = socket.getInputStream();
            BufferedReader inReader = new BufferedReader(new InputStreamReader(in, Charset.defaultCharset()));
            data = inReader.readLine();
            out.close();
            in.close();
            Object var8_7 = null;
            if (socket == null) return data;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (socket == null) throw throwable;
            socket.close();
            throw throwable;
        }
        socket.close();
        return data;
    }

    public void sendKillCommand() throws IOException {
        this.sendCode(COMM_KILL.getCommandCode());
    }

    public void sendForceKillCommand() throws IOException {
        this.sendCode(COMM_KILL_FORCE.getCommandCode());
    }

    public void sendSaveCommand() throws IOException {
        this.sendCode(COMM_SAVE.getCommandCode());
    }

    public String sendStatusCommand() throws IOException {
        return this.recieveCode(COMM_STATUS.getCommandCode());
    }

    public String sendWaitCommand() throws IOException {
        String ret = null;
        for (int i = 0; i < 4; ++i) {
            try {
                ret = this.recieveCode(COMM_WAIT.getCommandCode());
                String[] split = ret.split(";");
                if (!Boolean.parseBoolean(split[0])) continue;
                break;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(this.waittime * 1000);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    protected String getDescr() {
        return "control commands to the Grabber server";
    }

    protected String usageString() {
        return "java -jar jcov.jar GrabberManager [-option value]";
    }

    protected String exampleString() {
        return "java -jar jcov.jar GrabberManager -port 3336 -status";
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int initPortFromFile(String file) throws IOException {
        Properties ps = new Properties();
        FileInputStream in = null;
        in = new FileInputStream(file);
        ps.load(in);
        ((InputStream)in).close();
        String portStr = ps.getProperty("jcov.grabber.commandPort");
        if (portStr == null) {
            logger.log(Level.SEVERE, "Command Listeners port is not set in properties file '{0}'. Cannot work.", file);
            return 1;
        }
        this.port = 0;
        try {
            this.port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException ex) {
            logger.log(Level.SEVERE, "Malformed port number '{0}' in properties file '{1}'. Cannot work.", new Object[]{portStr, file});
            return 1;
        }
        if (this.port == 0) {
            String runLine = ps.getProperty("jcov.grabber.runLine");
            if (runLine != null) {
                logger.log(Level.SEVERE, "Command listener is not running on server (port = 0). Server was run with arguments '{0}'.", runLine);
            } else {
                logger.log(Level.SEVERE, "Command listener is not running on server (port = 0). Servers run line is unknown (not set in properties file).");
            }
            return 1;
        }
        this.checkVersion(ps.getProperty("jcov.grabber.version"));
        return 0;
    }

    private void checkVersion(String version) {
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(GrabberManager.class.getName());
    }

    static class ServerCommand
    extends OptionDescr {
        private int commandCode;

        ServerCommand(String name, String[] aliases, String titile, int values, String usage, int code) {
            super(name, aliases, titile, values, usage);
            this.commandCode = code;
        }

        public int getCommandCode() {
            return this.commandCode;
        }
    }
}

