/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.RepGen;
import com.sun.tdk.jcov.filter.ConveyerFilter;
import com.sun.tdk.jcov.filter.FilterSpi;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.io.ClassSignatureFilter;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.runtime.JCovXMLFileSaver;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.tools.SPIDescr;
import com.sun.tdk.jcov.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;

public class Filter
extends JCovCMDTool {
    private String inFile = null;
    private String outFile = null;
    private ClassSignatureFilter readFilter;
    private MemberFilter filter;
    private String[] filterSpi = null;
    private boolean synthetic = false;
    static final OptionDescr DSC_FILTER_PLUGIN = new OptionDescr("filter", "", 2, "Custom filtering plugin class");
    public static final OptionDescr DSC_SYNTHETIC = new OptionDescr("synthetic", "Additional filtering", "Remove coverage for synthetic methods");

    public void applyFilter(String inFile, String outFile) throws Exception {
        DataRoot root = Reader.readXML(inFile, true, (MemberFilter)this.readFilter);
        if (this.synthetic) {
            root.applyFilter(new RepGen.ANC_FILTER());
        }
        if (this.filter != null) {
            root.applyFilter(this.filter);
        }
        root.getParams().setIncludes(this.readFilter.getIncludes());
        root.getParams().setExcludes(this.readFilter.getExcludes());
        if (this.readFilter.getModifs() != null && this.readFilter.getModifs().length > 0) {
            root.getXMLHeadProperties().put("coverage.generator.modif", Arrays.toString(this.readFilter.getModifs()));
        } else {
            root.getXMLHeadProperties().remove("coverage.generator.modif");
        }
        if (this.filterSpi != null) {
            String get = root.getXMLHeadProperties().get("coverage.filter.plugin");
            root.getXMLHeadProperties().put("coverage.filter.plugin", Arrays.toString(this.filterSpi));
        } else {
            root.getXMLHeadProperties().remove("coverage.filter.plugin");
        }
        new JCovXMLFileSaver(root, InstrumentationOptions.MERGE.OVERWRITE).saveResults(outFile);
        root.destroy();
    }

    public static void main(String[] args) {
        Filter tool = new Filter();
        try {
            int res = tool.run(args);
            System.exit(res);
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    protected String usageString() {
        return "java " + Filter.class.getCanonicalName() + " [options] inFile outFile";
    }

    protected String exampleString() {
        return "java -cp jcov.jar:filter_classes " + Filter.class.getCanonicalName() + " -include java.lang.* " + "-filter java.xml lang.xml";
    }

    protected String getDescr() {
        return "filters out result data";
    }

    protected EnvHandler defineHandler() {
        EnvHandler eh = new EnvHandler(new OptionDescr[]{InstrumentationOptions.DSC_INCLUDE, InstrumentationOptions.DSC_INCLUDE_LIST, InstrumentationOptions.DSC_EXCLUDE, InstrumentationOptions.DSC_EXCLUDE_LIST, InstrumentationOptions.DSC_FM, InstrumentationOptions.DSC_FM_LIST, DSC_FILTER_PLUGIN, DSC_SYNTHETIC}, (JCovTool)this);
        eh.registerSPI(new SPIDescr("filter", FilterSpi.class));
        return eh;
    }

    protected int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        String[] files = opts.getTail();
        if (files == null || files.length == 0) {
            throw new JCovTool.EnvHandlingException("no input file specified");
        }
        if (files.length == 1) {
            throw new JCovTool.EnvHandlingException("no output file specified");
        }
        if (files.length == 2) {
            this.inFile = files[0];
            Utils.checkFileNotNull(this.inFile, "input JCov datafile", Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_CANREAD);
            this.outFile = files[1];
            Utils.checkFileNotNull(this.outFile, "output JCov datafile", Utils.CheckOptions.FILE_NOTEXISTS, Utils.CheckOptions.FILE_CANWRITE);
        } else if (files.length > 2) {
            throw new JCovTool.EnvHandlingException("too many files specified");
        }
        this.synthetic = opts.isSet(DSC_SYNTHETIC);
        String[] exclude = InstrumentationOptions.handleExclude(opts);
        String[] include = InstrumentationOptions.handleInclude(opts);
        String[] fm = InstrumentationOptions.handleFM(opts);
        this.readFilter = new ClassSignatureFilter(include, exclude, fm);
        ArrayList<FilterSpi> filters = opts.getSPIs(FilterSpi.class);
        if (filters == null || filters.isEmpty()) {
            this.filter = null;
        } else if (filters.size() == 1) {
            this.filter = filters.get(0).getFilter();
        } else {
            ConveyerFilter cf = new ConveyerFilter();
            for (FilterSpi spi : filters) {
                cf.add(spi.getFilter());
            }
            this.filter = cf;
        }
        return 0;
    }

    protected int run() throws Exception {
        try {
            this.applyFilter(this.inFile, this.outFile);
        }
        catch (Exception e) {
            if (this.filter != null) {
                if (e instanceof NullPointerException) {
                    e.printStackTrace();
                }
                throw new Exception("Cannot apply filter '" + this.filter + "' to " + this.inFile + " - exception occured: " + e.getMessage(), e);
            }
            throw new Exception("Mishap:", e);
        }
        return 0;
    }

    public ClassSignatureFilter getReadingFilter() {
        return this.readFilter;
    }

    public void setReadingFilter(ClassSignatureFilter acceptor) {
        this.readFilter = acceptor;
    }

    public MemberFilter getFilter() {
        return this.filter;
    }

    public void setFilter(MemberFilter filter) {
        this.filter = filter;
    }
}

