/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.StringArray;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPath {
    private String value = "";
    private static final String PATHSEP = File.pathSeparator;

    public SearchPath() {
    }

    public SearchPath(List<File> list) {
        this.append(list);
    }

    public SearchPath(File ... fileArray) {
        this.append(fileArray);
    }

    public SearchPath(SearchPath ... searchPathArray) {
        this.append(searchPathArray);
    }

    public SearchPath(String ... stringArray) {
        this.append(stringArray);
    }

    public SearchPath append(List<File> list) {
        for (File file : list) {
            if (!file.exists()) continue;
            if (this.value.length() > 0) {
                this.value = this.value + PATHSEP;
            }
            this.value = this.value + file.getPath();
        }
        return this;
    }

    public SearchPath append(File ... fileArray) {
        for (File file : fileArray) {
            if (!file.exists()) continue;
            if (this.value.length() > 0) {
                this.value = this.value + PATHSEP;
            }
            this.value = this.value + file.getPath();
        }
        return this;
    }

    public SearchPath append(SearchPath ... searchPathArray) {
        for (SearchPath searchPath : searchPathArray) {
            if (searchPath.value.length() <= 0) continue;
            if (this.value.length() > 0) {
                this.value = this.value + PATHSEP;
            }
            this.value = this.value + searchPath.value;
        }
        return this;
    }

    public SearchPath append(String ... stringArray) {
        for (String string : stringArray) {
            if (string.length() <= 0) continue;
            if (this.value.length() > 0) {
                this.value = this.value + PATHSEP;
            }
            this.value = this.value + string;
        }
        return this;
    }

    public List<File> split() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : StringArray.splitSeparator(PATHSEP, this.value)) {
            if (string.length() <= 0) continue;
            arrayList.add(new File(string));
        }
        return arrayList;
    }

    public boolean contains(SearchPath searchPath) {
        return this.value.equals(searchPath.value) || this.value.startsWith(searchPath.value + PATHSEP) || this.value.endsWith(PATHSEP + searchPath.value) || this.value.contains(PATHSEP + searchPath.value + PATHSEP);
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public String toString() {
        return this.value;
    }
}

