/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class Alarm {
    protected boolean fired;
    protected ScheduledFuture<?> future;
    protected int count;
    protected final long delay;
    protected final TimeUnit delayUnit;
    protected final PrintWriter msgOut;
    public static final Alarm NONE = new NoAlarm(0L, TimeUnit.MILLISECONDS, null);
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Alarm.class);

    public static Alarm schedulePeriodicInterrupt(long l, TimeUnit timeUnit, PrintWriter printWriter, Thread thread) {
        Interruptor interruptor = new Interruptor(l, timeUnit, printWriter, thread);
        interruptor.future = executor.scheduleWithFixedDelay(interruptor, TimeUnit.MILLISECONDS.convert(l, timeUnit), 100L, TimeUnit.MILLISECONDS);
        return interruptor;
    }

    public static Alarm scheduleInterrupt(long l, TimeUnit timeUnit, PrintWriter printWriter, Thread thread) {
        Interruptor interruptor = new Interruptor(l, timeUnit, printWriter, thread);
        interruptor.future = executor.schedule(interruptor, l, timeUnit);
        return interruptor;
    }

    public static Alarm schedule(long l, TimeUnit timeUnit, PrintWriter printWriter, Runnable runnable) {
        RunnableAlarm runnableAlarm = new RunnableAlarm(l, timeUnit, printWriter, runnable);
        runnableAlarm.future = executor.schedule(runnableAlarm, l, timeUnit);
        return runnableAlarm;
    }

    protected Alarm(long l, TimeUnit timeUnit, PrintWriter printWriter) {
        this.delay = l;
        this.delayUnit = timeUnit;
        this.msgOut = printWriter;
    }

    public void cancel() {
        this.future.cancel(true);
    }

    public boolean didFire() {
        return this.fired;
    }

    protected void run() {
        if (this.msgOut != null) {
            if (this.count == 0) {
                this.msgOut.println(i18n.getString("alarm.fired", TimeUnit.SECONDS.convert(this.delay, this.delayUnit)));
            } else if (this.count % 100 == 0) {
                this.msgOut.println(i18n.getString("alarm.refired", this.count));
            }
        }
        ++this.count;
        this.fired = true;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = this.defaultFactory.newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class NoAlarm
    extends Alarm {
        protected NoAlarm(long l, TimeUnit timeUnit, PrintWriter printWriter) {
            super(l, timeUnit, printWriter);
        }

        public void cancel() {
        }

        public boolean didFire() {
            return false;
        }
    }

    private static class RunnableAlarm
    extends Alarm
    implements Runnable {
        Runnable r;

        public RunnableAlarm(long l, TimeUnit timeUnit, PrintWriter printWriter, Runnable runnable) {
            super(l, timeUnit, printWriter);
            this.r = runnable;
        }

        public void run() {
            super.run();
            this.r.run();
        }
    }

    private static class Interruptor
    extends Alarm
    implements Runnable {
        Thread threadToInterrupt;

        public Interruptor(long l, TimeUnit timeUnit, PrintWriter printWriter, Thread thread) {
            super(l, timeUnit, printWriter);
            this.threadToInterrupt = thread;
        }

        public void run() {
            super.run();
            this.threadToInterrupt.interrupt();
        }
    }
}

