/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.CompileActionHelper;
import com.sun.javatest.regtest.agent.MainActionHelper;
import com.sun.javatest.regtest.agent.RegressionSecurityManager;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentServer
implements ActionHelper.OutputHandler {
    public static final boolean traceServer = ActionHelper.show("traceServer");
    public static final String ALLOW_SET_SECURITY_MANAGER = "-allowSetSecurityManager";
    public static final String HOST = "-host";
    public static final String PORT = "-port";
    public static final byte DO_COMPILE = 1;
    public static final byte DO_MAIN = 2;
    public static final byte OUTPUT = 3;
    public static final byte STATUS = 4;
    public static final byte KEEPALIVE = 5;
    public static final byte CLOSE = 6;
    private final KeepAlive keepAlive;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final PrintStream traceOut = System.err;
    private final Map<ActionHelper.OutputHandler.OutputKind, PrintWriter> writers = new EnumMap<ActionHelper.OutputHandler.OutputKind, PrintWriter>(ActionHelper.OutputHandler.OutputKind.class);

    public static void main(String ... stringArray) {
        if (traceServer) {
            System.err.println("AgentServer.main");
        }
        try {
            new AgentServer(stringArray).run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public AgentServer(String ... stringArray) throws IOException {
        Object object;
        if (traceServer) {
            this.traceOut.println("Agent.Server started");
        }
        boolean bl = false;
        InetAddress inetAddress = InetAddress.getByName("localhost");
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).equals(ALLOW_SET_SECURITY_MANAGER)) {
                bl = true;
                continue;
            }
            if (((String)object).equals(PORT) && i + 1 < stringArray.length) {
                n = Integer.valueOf(stringArray[++i]);
                continue;
            }
            if (((String)object).equals(HOST) && i + 1 < stringArray.length) {
                inetAddress = InetAddress.getByName(stringArray[++i]);
                continue;
            }
            throw new IllegalArgumentException((String)object);
        }
        if (n > 0) {
            Socket socket = new Socket(inetAddress, n);
            socket.setSoTimeout(120000);
            this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        } else {
            this.in = new DataInputStream(new BufferedInputStream(System.in));
            this.out = new DataOutputStream(new BufferedOutputStream(System.out));
        }
        this.keepAlive = new KeepAlive(this.out, traceServer);
        RegressionSecurityManager.install();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof RegressionSecurityManager) {
            object = (RegressionSecurityManager)securityManager;
            ((RegressionSecurityManager)object).setAllowPropertiesAccess(true);
            if (bl) {
                ((RegressionSecurityManager)object).setAllowSetSecurityManager(true);
            }
            ((RegressionSecurityManager)object).setAllowSetIO(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        try {
            int n;
            while ((n = this.in.read()) != -1) {
                switch (n) {
                    case 1: {
                        this.doCompile();
                        break;
                    }
                    case 2: {
                        this.doMain();
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        return;
                    }
                    default: {
                        throw new Error("Agent.Server: unexpected op: " + n);
                    }
                }
                this.out.flush();
            }
        }
        finally {
            this.keepAlive.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompile() throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server.doCompile");
        }
        String string = this.in.readUTF();
        Map<String, String> map = AgentServer.readProperties(this.in);
        List<String> list = AgentServer.readList(this.in);
        this.keepAlive.setEnabled(true);
        try {
            Status status = CompileActionHelper.runCompile(string, map, list, 0, this);
            this.writeStatus(status);
        }
        finally {
            this.keepAlive.setEnabled(false);
        }
        if (traceServer) {
            this.traceOut.println("Agent.Server.doCompile DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMain() throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server.doMain");
        }
        String string = this.in.readUTF();
        Map<String, String> map = AgentServer.readProperties(this.in);
        SearchPath searchPath = new SearchPath(this.in.readUTF());
        String string2 = this.in.readUTF();
        List<String> list = AgentServer.readList(this.in);
        if (traceServer) {
            this.traceOut.println("Agent.Server.doMain: " + string);
        }
        this.keepAlive.setEnabled(true);
        try {
            Status status = MainActionHelper.runClass(string, map, searchPath, string2, list.toArray(new String[list.size()]), 0, this);
            this.writeStatus(status);
        }
        finally {
            this.keepAlive.setEnabled(false);
        }
        if (traceServer) {
            this.traceOut.println("Agent.Server.doMain DONE");
        }
    }

    static List<String> readList(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(dataInputStream.readUTF());
        }
        return arrayList;
    }

    static Map<String, String> readProperties(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        HashMap<String, String> hashMap = new HashMap<String, String>(n, 1.0f);
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatus(Status status) throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server.writeStatus: " + status);
        }
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeByte(4);
            this.out.writeByte(status.getType());
            this.out.writeUTF(status.getReason());
        }
        this.writers.clear();
    }

    @Override
    public PrintWriter createOutput(final ActionHelper.OutputHandler.OutputKind outputKind) {
        PrintWriter printWriter = this.writers.get((Object)outputKind);
        if (printWriter == null) {
            printWriter = new PrintWriter(new Writer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(char[] cArray, int n, int n2) throws IOException {
                    if (traceServer) {
                        AgentServer.this.traceOut.println("Agent.Server.write[" + (Object)((Object)outputKind) + "] " + new String(cArray, n, n2));
                    }
                    while (n2 > 0) {
                        int n3 = n2 > 4096 ? 4096 : n2;
                        DataOutputStream dataOutputStream = AgentServer.this.out;
                        synchronized (dataOutputStream) {
                            AgentServer.this.out.writeByte(3);
                            AgentServer.this.out.writeUTF(outputKind.name);
                            AgentServer.this.out.writeUTF(new String(cArray, n, n3));
                        }
                        n += n3;
                        n2 -= n3;
                    }
                    if (traceServer) {
                        AgentServer.this.traceOut.println("Agent.Server.write[" + (Object)((Object)outputKind) + "]--done");
                    }
                }

                public void flush() throws IOException {
                    AgentServer.this.out.flush();
                }

                public void close() throws IOException {
                    AgentServer.this.out.flush();
                }
            });
            this.writers.put(outputKind, printWriter);
        }
        return printWriter;
    }

    @Override
    public void createOutput(ActionHelper.OutputHandler.OutputKind outputKind, String string) {
        PrintWriter printWriter = this.createOutput(outputKind);
        printWriter.write(string);
        printWriter.close();
    }

    public static class KeepAlive {
        public static final int WRITE_TIMEOUT = 60000;
        public static final int READ_TIMEOUT = 120000;
        final DataOutputStream out;
        final Runnable ping = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DataOutputStream dataOutputStream = KeepAlive.this.out;
                    synchronized (dataOutputStream) {
                        if (KeepAlive.this.trace) {
                            KeepAlive.this.traceOut.println("KeepAlive.ping");
                        }
                        KeepAlive.this.out.writeByte(5);
                        KeepAlive.this.out.flush();
                    }
                    KeepAlive.this.setEnabled(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Alarm alarm = Alarm.NONE;
        final PrintStream traceOut = System.err;
        final boolean trace;

        public KeepAlive(DataOutputStream dataOutputStream, boolean bl) {
            this.out = dataOutputStream;
            this.trace = bl;
        }

        public synchronized void setEnabled(boolean bl) {
            this.alarm.cancel();
            this.alarm = bl ? Alarm.schedule(60000L, TimeUnit.MILLISECONDS, null, this.ping) : Alarm.NONE;
        }

        public synchronized void finished() {
            this.setEnabled(false);
        }
    }
}

