/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.DefaultTimeoutHandler;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.TimeoutHandler;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutHandlerProvider {
    private static String className;
    private static ClassLoader loader;

    public static void setClassName(String string) {
        className = string;
    }

    public static void setClassPath(List<File> list) throws MalformedURLException {
        URL[] uRLArray = new URL[list.size()];
        int n = 0;
        for (File file : list) {
            uRLArray[n++] = file.toURI().toURL();
        }
        loader = new URLClassLoader(uRLArray);
    }

    private static Class<TimeoutHandler> loadClass() throws ClassNotFoundException {
        Class<?> clazz = loader == null ? Class.forName(className) : Class.forName(className, true, loader);
        return clazz.asSubclass(TimeoutHandler.class);
    }

    public static TimeoutHandler createHandler(RegressionScript regressionScript, TestResult.Section section) {
        PrintWriter printWriter = section.getMessageWriter();
        File file = regressionScript.absTestScratchDir();
        File file2 = regressionScript.getTestJDK().getAbsoluteFile();
        if (className != null) {
            try {
                Class<TimeoutHandler> clazz = TimeoutHandlerProvider.loadClass();
                Constructor<TimeoutHandler> constructor = clazz.getDeclaredConstructor(PrintWriter.class, File.class, File.class);
                return constructor.newInstance(printWriter, file, file2);
            }
            catch (Exception exception) {
                printWriter.println("Failed to instantiate timeout handler: " + className);
                exception.printStackTrace(printWriter);
                printWriter.println("Reverting to the default timeout handler.");
            }
        }
        return new DefaultTimeoutHandler(printWriter, file, file2);
    }
}

