/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.Agent;
import com.sun.javatest.regtest.AppletAction;
import com.sun.javatest.regtest.BuildAction;
import com.sun.javatest.regtest.CleanAction;
import com.sun.javatest.regtest.CompileAction;
import com.sun.javatest.regtest.DriverAction;
import com.sun.javatest.regtest.ExecMode;
import com.sun.javatest.regtest.IgnoreAction;
import com.sun.javatest.regtest.IgnoreKind;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.JUnitAction;
import com.sun.javatest.regtest.Locations;
import com.sun.javatest.regtest.Lock;
import com.sun.javatest.regtest.MainAction;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionEnvironment;
import com.sun.javatest.regtest.RegressionParameters;
import com.sun.javatest.regtest.RegressionTestSuite;
import com.sun.javatest.regtest.ScratchDirectory;
import com.sun.javatest.regtest.ShellAction;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.TestNGAction;
import com.sun.javatest.regtest.TestNGReporter;
import com.sun.javatest.regtest.TestRunException;
import com.sun.javatest.regtest.Version;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.RStatus;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionScript
extends Script {
    private static float cacheJavaTestTimeoutFactor = -1.0f;
    private SearchPath cacheCompileClassPath;
    private SearchPath cacheCompileSourcePath;
    private int nextSerial = 0;
    List<Agent> agents = new ArrayList<Agent>();
    static String version;
    static final String WRAPPEREXTN = ".jta";
    private static final String LINESEP;
    private static final String CANT_INSTANTIATE = "Unable to instantiate: ";
    private static final String NOT_EXT_ACTION = " does not extend Action";
    private static final String ILLEGAL_ACCESS_INIT = "Illegal access to init method: ";
    private static final String BAD_ACTION = "Bad action for script: ";
    private static final String ADD_BAD_SUBTYPE = "Class must be a subtype of ";
    private final Map<String, Class<?>> actionTable = new HashMap();
    private TestResult testResult;
    private RegressionEnvironment regEnv;
    private RegressionParameters params;
    private RegressionTestSuite testSuite;
    private boolean useBootClassPath;
    private ExecMode defaultExecMode;
    private boolean needJUnit;
    private boolean needTestNG;
    private ScratchDirectory scratchDirectory;
    Locations locations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public Status run(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        Status status;
        block67: {
            String string;
            if (!(testEnvironment instanceof RegressionEnvironment)) {
                throw new AssertionError();
            }
            long l = System.currentTimeMillis();
            this.regEnv = (RegressionEnvironment)testEnvironment;
            this.params = this.regEnv.params;
            this.testSuite = this.params.getTestSuite();
            String string2 = this.params.filterFaults.get(testDescription);
            if (string2 != null) {
                return Status.error(string2);
            }
            status = RStatus.passed("OK");
            String string3 = testDescription.getParameter("run");
            this.testResult = this.getTestResult();
            try {
                string = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = "127.0.0.1";
            }
            this.testResult.putProperty("hostname", string);
            String[] stringArray2 = new String[]{"user.name"};
            for (Object object2 : stringArray2) {
                this.testResult.putProperty((String)object2, System.getProperty((String)object2));
            }
            this.testResult.putProperty("jtregVersion", RegressionScript.getVersion());
            PrintWriter printWriter = this.testResult.getTestCommentWriter();
            try {
                this.locations = new Locations(this.regEnv, testDescription);
                this.defaultExecMode = this.testSuite.useOtherVM(testDescription) ? ExecMode.OTHERVM : this.params.getExecMode();
                this.useBootClassPath = this.testSuite.useBootClassPath(testDescription.getRootRelativePath());
                LinkedList<Action> linkedList = this.parseActions(string3, true);
                this.needJUnit = false;
                for (Object object2 : linkedList) {
                    if (!(object2 instanceof JUnitAction)) continue;
                    this.needJUnit = true;
                }
                if (this.needJUnit && !this.params.isJUnitAvailable()) {
                    throw new TestRunException("JUnit not available: see the FAQ or online help for details");
                }
                this.needTestNG = false;
                Object object = linkedList.iterator();
                while (object.hasNext()) {
                    Object object2;
                    object2 = (Action)object.next();
                    if (!(object2 instanceof TestNGAction)) continue;
                    this.needTestNG = true;
                }
                if (this.needTestNG && !this.params.isTestNGAvailable()) {
                    throw new TestRunException("TestNG not available: see the FAQ or online help for details");
                }
                this.scratchDirectory = ScratchDirectory.get(this.params, this.defaultExecMode, testDescription);
                this.scratchDirectory.init(printWriter);
                if (testDescription.getParameter("error") != null) {
                    status = RStatus.error(testDescription.getParameter("error"));
                } else {
                    if (this.getTestJDK().equals(this.getCompileJDK())) {
                        printWriter.println("JDK under test: " + this.getTestJDK().getFullVersion(this.getTestVMOptions()));
                    } else {
                        printWriter.println("compile JDK: " + this.getCompileJDK().getFullVersion(this.getTestToolVMOptions()));
                        printWriter.println("test JDK: " + this.getTestJDK().getFullVersion(this.getTestVMOptions()));
                    }
                    while (!linkedList.isEmpty() && (status = ((Action)(object = linkedList.remove())).run()).getType() == 0) {
                    }
                }
                Object var16_23 = null;
            }
            catch (Throwable throwable) {
                Object var16_29 = null;
                int n = (int)(System.currentTimeMillis() - l);
                int n2 = n % 1000;
                int n3 = n / 1000 % 60;
                int n4 = n / 60000 % 60;
                int n5 = n / 3600000;
                this.testResult.putProperty("elapsed", String.format("%d %d:%02d:%02d.%03d", n, n5, n4, n3, n2));
                if (this.params.isRetainEnabled()) {
                    String string4;
                    block73: {
                        string4 = null;
                        try {
                            if (this.scratchDirectory != null) {
                                this.scratchDirectory.retainFiles(status, printWriter);
                            } else {
                                string4 = "No scratch directory";
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            string4 = "Interrupted! " + interruptedException.getLocalizedMessage();
                        }
                        catch (ScratchDirectory.Fault fault) {
                            string4 = fault.getMessage();
                            if (fault.getCause() == null) break block73;
                            string4 = string4 + " (" + fault.getCause() + ")";
                        }
                    }
                    if (string4 != null) {
                        printWriter.println(string4);
                        printWriter.println("Test result (overridden): " + status);
                        status = RStatus.error("failed to clean up files after test");
                        this.closeAgents();
                    }
                }
                this.releaseAgents();
                throw throwable;
            }
            int n = (int)(System.currentTimeMillis() - l);
            int n6 = n % 1000;
            int n7 = n / 1000 % 60;
            int n8 = n / 60000 % 60;
            int n9 = n / 3600000;
            this.testResult.putProperty("elapsed", String.format("%d %d:%02d:%02d.%03d", n, n9, n8, n7, n6));
            if (this.params.isRetainEnabled()) {
                String string5;
                block66: {
                    string5 = null;
                    try {
                        if (this.scratchDirectory != null) {
                            this.scratchDirectory.retainFiles(status, printWriter);
                        } else {
                            string5 = "No scratch directory";
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        string5 = "Interrupted! " + interruptedException.getLocalizedMessage();
                    }
                    catch (ScratchDirectory.Fault fault) {
                        string5 = fault.getMessage();
                        if (fault.getCause() == null) break block66;
                        string5 = string5 + " (" + fault.getCause() + ")";
                    }
                }
                if (string5 != null) {
                    printWriter.println(string5);
                    printWriter.println("Test result (overridden): " + status);
                    status = RStatus.error("failed to clean up files after test");
                    this.closeAgents();
                }
            }
            this.releaseAgents();
            {
                break block67;
                catch (InterruptedException interruptedException) {
                    status = RStatus.error("Interrupted! " + interruptedException.getLocalizedMessage());
                    Object var16_24 = null;
                    int n10 = (int)(System.currentTimeMillis() - l);
                    int n11 = n10 % 1000;
                    int n12 = n10 / 1000 % 60;
                    int n13 = n10 / 60000 % 60;
                    int n14 = n10 / 3600000;
                    this.testResult.putProperty("elapsed", String.format("%d %d:%02d:%02d.%03d", n10, n14, n13, n12, n11));
                    if (this.params.isRetainEnabled()) {
                        String string6;
                        block68: {
                            string6 = null;
                            try {
                                if (this.scratchDirectory != null) {
                                    this.scratchDirectory.retainFiles(status, printWriter);
                                } else {
                                    string6 = "No scratch directory";
                                }
                            }
                            catch (InterruptedException interruptedException2) {
                                string6 = "Interrupted! " + interruptedException2.getLocalizedMessage();
                            }
                            catch (ScratchDirectory.Fault fault) {
                                string6 = fault.getMessage();
                                if (fault.getCause() == null) break block68;
                                string6 = string6 + " (" + fault.getCause() + ")";
                            }
                        }
                        if (string6 != null) {
                            printWriter.println(string6);
                            printWriter.println("Test result (overridden): " + status);
                            status = RStatus.error("failed to clean up files after test");
                            this.closeAgents();
                        }
                    }
                    this.releaseAgents();
                    break block67;
                }
                catch (ScratchDirectory.Fault fault) {
                    String string7 = fault.getLocalizedMessage();
                    if (fault.getCause() != null) {
                        string7 = string7 + " (" + fault.getCause() + ")";
                    }
                    status = RStatus.error(string7);
                    Object var16_25 = null;
                    int n15 = (int)(System.currentTimeMillis() - l);
                    int n16 = n15 % 1000;
                    int n17 = n15 / 1000 % 60;
                    int n18 = n15 / 60000 % 60;
                    int n19 = n15 / 3600000;
                    this.testResult.putProperty("elapsed", String.format("%d %d:%02d:%02d.%03d", n15, n19, n18, n17, n16));
                    if (this.params.isRetainEnabled()) {
                        String string8;
                        block69: {
                            string8 = null;
                            try {
                                if (this.scratchDirectory != null) {
                                    this.scratchDirectory.retainFiles(status, printWriter);
                                } else {
                                    string8 = "No scratch directory";
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                string8 = "Interrupted! " + interruptedException.getLocalizedMessage();
                            }
                            catch (ScratchDirectory.Fault fault2) {
                                string8 = fault2.getMessage();
                                if (fault2.getCause() == null) break block69;
                                string8 = string8 + " (" + fault2.getCause() + ")";
                            }
                        }
                        if (string8 != null) {
                            printWriter.println(string8);
                            printWriter.println("Test result (overridden): " + status);
                            status = RStatus.error("failed to clean up files after test");
                            this.closeAgents();
                        }
                    }
                    this.releaseAgents();
                    break block67;
                }
                catch (TestSuite.Fault fault) {
                    status = RStatus.error(fault.getMessage());
                    Object var16_26 = null;
                    int n20 = (int)(System.currentTimeMillis() - l);
                    int n21 = n20 % 1000;
                    int n22 = n20 / 1000 % 60;
                    int n23 = n20 / 60000 % 60;
                    int n24 = n20 / 3600000;
                    this.testResult.putProperty("elapsed", String.format("%d %d:%02d:%02d.%03d", n20, n24, n23, n22, n21));
                    if (this.params.isRetainEnabled()) {
                        String string9;
                        block70: {
                            string9 = null;
                            try {
                                if (this.scratchDirectory != null) {
                                    this.scratchDirectory.retainFiles(status, printWriter);
                                } else {
                                    string9 = "No scratch directory";
                                }
                            }
                            catch (InterruptedException interruptedException2) {
                                string9 = "Interrupted! " + interruptedException2.getLocalizedMessage();
                            }
                            catch (ScratchDirectory.Fault fault3) {
                                string9 = fault3.getMessage();
                                if (fault3.getCause() == null) break block70;
                                string9 = string9 + " (" + fault3.getCause() + ")";
                            }
                        }
                        if (string9 != null) {
                            printWriter.println(string9);
                            printWriter.println("Test result (overridden): " + status);
                            status = RStatus.error("failed to clean up files after test");
                            this.closeAgents();
                        }
                    }
                    this.releaseAgents();
                    break block67;
                }
                catch (ParseActionsException parseActionsException) {
                    status = RStatus.error(parseActionsException.getMessage());
                    Object var16_27 = null;
                    int n25 = (int)(System.currentTimeMillis() - l);
                    int n26 = n25 % 1000;
                    int n27 = n25 / 1000 % 60;
                    int n28 = n25 / 60000 % 60;
                    int n29 = n25 / 3600000;
                    this.testResult.putProperty("elapsed", String.format("%d %d:%02d:%02d.%03d", n25, n29, n28, n27, n26));
                    if (this.params.isRetainEnabled()) {
                        String string10;
                        block71: {
                            string10 = null;
                            try {
                                if (this.scratchDirectory != null) {
                                    this.scratchDirectory.retainFiles(status, printWriter);
                                } else {
                                    string10 = "No scratch directory";
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                string10 = "Interrupted! " + interruptedException.getLocalizedMessage();
                            }
                            catch (ScratchDirectory.Fault fault2) {
                                string10 = fault2.getMessage();
                                if (fault2.getCause() == null) break block71;
                                string10 = string10 + " (" + fault2.getCause() + ")";
                            }
                        }
                        if (string10 != null) {
                            printWriter.println(string10);
                            printWriter.println("Test result (overridden): " + status);
                            status = RStatus.error("failed to clean up files after test");
                            this.closeAgents();
                        }
                    }
                    this.releaseAgents();
                    break block67;
                }
                catch (TestRunException testRunException) {
                    status = RStatus.error(testRunException.getMessage());
                    Object var16_28 = null;
                    int n30 = (int)(System.currentTimeMillis() - l);
                    int n31 = n30 % 1000;
                    int n32 = n30 / 1000 % 60;
                    int n33 = n30 / 60000 % 60;
                    int n34 = n30 / 3600000;
                    this.testResult.putProperty("elapsed", String.format("%d %d:%02d:%02d.%03d", n30, n34, n33, n32, n31));
                    if (this.params.isRetainEnabled()) {
                        String string11;
                        block72: {
                            string11 = null;
                            try {
                                if (this.scratchDirectory != null) {
                                    this.scratchDirectory.retainFiles(status, printWriter);
                                } else {
                                    string11 = "No scratch directory";
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                string11 = "Interrupted! " + interruptedException.getLocalizedMessage();
                            }
                            catch (ScratchDirectory.Fault fault3) {
                                string11 = fault3.getMessage();
                                if (fault3.getCause() == null) break block72;
                                string11 = string11 + " (" + fault3.getCause() + ")";
                            }
                        }
                        if (string11 != null) {
                            printWriter.println(string11);
                            printWriter.println("Test result (overridden): " + status);
                            status = RStatus.error("failed to clean up files after test");
                            this.closeAgents();
                        }
                    }
                    this.releaseAgents();
                }
            }
        }
        return status;
    }

    public Set<File> getSourceFiles(RegressionParameters regressionParameters, TestDescription testDescription) {
        this.td = testDescription;
        try {
            Object object;
            if (this.locations == null) {
                object = (RegressionEnvironment)regressionParameters.getEnv();
                ((TestEnvironment)object).put("testClassDir", "/NO/CLASSES/");
                this.locations = new Locations((RegressionEnvironment)object, testDescription);
            }
            object = testDescription.getParameter("run");
            LinkedList<Action> linkedList = this.parseActions((String)object, false);
            TreeSet<File> treeSet = new TreeSet<File>();
            while (!linkedList.isEmpty()) {
                Action action = linkedList.remove();
                Set<File> set = action.getSourceFiles();
                if (set == null) continue;
                treeSet.addAll(set);
            }
            return treeSet;
        }
        catch (TestRunException testRunException) {
            return Collections.emptySet();
        }
        catch (ParseActionsException parseActionsException) {
            throw new Error(parseActionsException);
        }
    }

    LinkedList<Action> parseActions(String string, boolean bl) throws ParseActionsException, ParseException {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        String[] stringArray = StringUtils.splitTerminator(LINESEP, string);
        this.populateActionTable();
        for (String string2 : stringArray) {
            String[] stringArray2 = StringUtils.splitWS(string2);
            String[] stringArray3 = StringUtils.splitSeparator("/", stringArray2[1]);
            String string3 = stringArray3[0];
            String[][] stringArray4 = new String[stringArray3.length - 1][];
            for (int i = 1; i < stringArray3.length; ++i) {
                stringArray4[i - 1] = StringUtils.splitEqual(stringArray3[i]);
            }
            String[] stringArray5 = new String[stringArray2.length - 2];
            for (int i = 2; i < stringArray2.length; ++i) {
                stringArray5[i - 2] = stringArray2[i];
            }
            Class<?> clazz = null;
            try {
                clazz = this.actionTable.get(string3);
                if (clazz == null) {
                    if (!bl) continue;
                    throw new ParseActionsException(BAD_ACTION + string3);
                }
                Action action = (Action)clazz.newInstance();
                action.init(stringArray4, stringArray5, this.getReason(stringArray2), this);
                linkedList.add(action);
            }
            catch (InstantiationException instantiationException) {
                if (!bl) continue;
                throw new ParseActionsException(CANT_INSTANTIATE + clazz + NOT_EXT_ACTION);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!bl) continue;
                throw new ParseActionsException(ILLEGAL_ACCESS_INIT + clazz);
            }
        }
        return linkedList;
    }

    @Override
    protected int getTestTimeout() {
        return 0;
    }

    protected int getActionTimeout(int n) {
        if (n == 0) {
            n = 120;
        }
        return (int)((float)n * this.getTimeoutFactor());
    }

    protected float getTimeoutFactor() {
        if (cacheJavaTestTimeoutFactor == -1.0f) {
            float f = 1.0f;
            try {
                String string;
                String string2 = string = this.regEnv == null ? null : this.regEnv.lookup("javatestTimeoutFactor")[1];
                if (string != null) {
                    f = Float.parseFloat(string);
                }
            }
            catch (TestEnvironment.Fault fault) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cacheJavaTestTimeoutFactor = f;
        }
        return cacheJavaTestTimeoutFactor;
    }

    @Override
    protected void setAlarm(int n) {
        super.setAlarm(n);
    }

    private void populateActionTable() {
        this.addAction("applet", AppletAction.class);
        this.addAction("build", BuildAction.class);
        this.addAction("clean", CleanAction.class);
        this.addAction("compile", CompileAction.class);
        this.addAction("driver", DriverAction.class);
        this.addAction("ignore", IgnoreAction.class);
        this.addAction("junit", JUnitAction.class);
        this.addAction("main", MainAction.class);
        this.addAction("shell", ShellAction.class);
        this.addAction("testng", TestNGAction.class);
    }

    private void addAction(String string, Class<? extends Action> clazz) {
        this.actionTable.put(string, clazz);
    }

    private String getReason(String[] stringArray) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = stringArray[0];
        if (string2.equals("ASSUMED_ACTION")) {
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append(" ");
            }
            string = "Assumed action based on file name: run " + stringBuffer;
        } else if (string2.equals("USER_SPECIFIED")) {
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append(" ");
            }
            string = "User specified action: run " + stringBuffer;
        } else {
            string = "Unknown";
        }
        return string;
    }

    Map<String, String> getEnvVars() {
        return this.params.getEnvVars();
    }

    boolean isCheck() {
        return this.params.isCheck();
    }

    List<String> getTestVMOptions() {
        return this.params.getTestVMOptions();
    }

    List<String> getTestToolVMOptions() {
        return this.params.getTestToolVMOptions();
    }

    List<String> getTestVMJavaOptions() {
        return this.params.getTestVMJavaOptions();
    }

    List<String> getTestDebugOptions() {
        return this.params.getTestDebugOptions();
    }

    List<String> getTestCompilerOptions() {
        return this.params.getTestCompilerOptions();
    }

    List<String> getTestJavaOptions() {
        return this.params.getTestJavaOptions();
    }

    IgnoreKind getIgnoreKind() {
        return this.params.getIgnoreKind();
    }

    File getNativeDir() {
        return this.params.getNativeDir();
    }

    File absTestSrcDir() {
        return this.locations.absTestSrcDir();
    }

    File absTestClsDir() {
        return this.locations.absTestClsDir();
    }

    File absTestScratchDir() {
        return this.scratchDirectory.dir.getAbsoluteFile();
    }

    File absTestClsTopDir() {
        return this.locations.absBaseClsDir();
    }

    SearchPath getTestClassPath() throws TestClassException {
        return this.getTestClassPath(false);
    }

    SearchPath getTestClassPath(boolean bl) throws TestClassException {
        return this.getTestClassPaths(bl)[0];
    }

    SearchPath getTestBootClassPath(boolean bl) throws TestClassException {
        return this.getTestClassPaths(bl)[1];
    }

    private SearchPath[] getTestClassPaths(boolean bl) throws TestClassException {
        SearchPath searchPath = new SearchPath();
        SearchPath searchPath2 = new SearchPath();
        JDK jDK = this.getTestJDK();
        if (bl) {
            searchPath2.append(this.locations.absTestClsDir());
            searchPath2.append(this.locations.absClsLibList());
            searchPath2.append(this.locations.absSrcJarLibList());
            searchPath2.append(jDK.getJDKClassPath());
            searchPath2.append(this.getCPAPPEND());
        } else {
            searchPath.append(this.locations.absTestClsDir());
            searchPath.append(this.locations.absTestSrcDir());
            for (File file : this.locations.absClsLibList()) {
                (this.useBootClassPath(file) ? searchPath2 : searchPath).append(file);
            }
            searchPath.append(this.locations.absSrcJarLibList());
            searchPath.append(jDK.getJDKClassPath());
            searchPath.append(this.getCPAPPEND());
        }
        return new SearchPath[]{searchPath, searchPath2};
    }

    private SearchPath getCPAPPEND() {
        Map<String, String> map = this.getEnvVars();
        String string = map.get("CPAPPEND");
        if (string != null) {
            return new SearchPath(string.replace('/', File.separatorChar));
        }
        return new SearchPath();
    }

    private boolean useBootClassPath(File file) throws TestClassException {
        try {
            String string = this.locations.absBaseClsDir().toURI().relativize(file.toURI()).getPath();
            return this.testSuite.useBootClassPath(string);
        }
        catch (TestSuite.Fault fault) {
            throw new TestClassException(fault.toString());
        }
    }

    SearchPath getCompileClassPath() throws TestClassException {
        if (this.cacheCompileClassPath == null) {
            Map<String, String> map;
            String string;
            this.cacheCompileClassPath = new SearchPath();
            JDK jDK = this.getCompileJDK();
            this.cacheCompileClassPath.append(this.locations.absTestClsDir());
            this.cacheCompileClassPath.append(this.locations.absTestSrcDir());
            this.cacheCompileClassPath.append(this.locations.absClsLibList());
            this.cacheCompileClassPath.append(this.locations.absSrcJarLibList());
            this.cacheCompileClassPath.append(jDK.getJDKClassPath());
            if (this.needJUnit) {
                this.cacheCompileClassPath.append(this.params.getJUnitJar());
            }
            if (this.needTestNG) {
                this.cacheCompileClassPath.append(this.params.getTestNGJar());
            }
            if ((string = (map = this.getEnvVars()).get("CPAPPEND")) != null) {
                string = string.replace('/', File.separatorChar);
                this.cacheCompileClassPath.append(string);
            }
        }
        return this.cacheCompileClassPath;
    }

    SearchPath getCompileSourcePath() {
        if (this.cacheCompileSourcePath == null) {
            this.cacheCompileSourcePath = new SearchPath();
            this.cacheCompileSourcePath.append(this.locations.absTestSrcDir());
            this.cacheCompileSourcePath.append(this.locations.absSrcLibList());
        }
        return this.cacheCompileSourcePath;
    }

    boolean useBootClassPath() {
        return this.useBootClassPath;
    }

    ExecMode getExecMode() {
        return this.defaultExecMode;
    }

    SearchPath getJavaTestClassPath() {
        return this.params.getJavaTestClassPath();
    }

    boolean isJUnitRequired() {
        return this.needJUnit;
    }

    File getJUnitJar() {
        return this.params.getJUnitJar();
    }

    boolean isTestNGRequired() {
        return this.needTestNG;
    }

    File getTestNGJar() {
        return this.params.getTestNGJar();
    }

    File getAsmToolsJar() {
        return this.params.getAsmToolsJar();
    }

    TestNGReporter getTestNGReporter() {
        return TestNGReporter.instance(this.workDir);
    }

    Lock getLockIfRequired() throws TestRunException {
        try {
            if (!this.testSuite.needsExclusiveAccess(this.td)) {
                return null;
            }
        }
        catch (TestSuite.Fault fault) {
            throw new TestRunException("Can't determine if lock required", fault);
        }
        return Lock.get(this.params);
    }

    int getNextSerial() {
        return this.nextSerial++;
    }

    JDK getTestJDK() {
        return this.params.getTestJDK();
    }

    JDK_Version getTestJDKVersion() {
        return this.getTestJDK().getVersion(this.params);
    }

    String getJavaProg() {
        return this.params.getTestJDK().getJavaProg().getPath();
    }

    JDK getCompileJDK() {
        return this.params.getCompileJDK();
    }

    JDK_Version getCompileJDKVersion() {
        return this.getCompileJDK().getVersion(this.params);
    }

    String getJavacProg() {
        return this.params.getCompileJDK().getJavacProg().getPath();
    }

    Map<String, String> getTestProperties() throws TestClassException {
        Object object;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        switch (this.getExecMode()) {
            case AGENTVM: 
            case SAMEVM: {
                object = new SearchPath().append(this.locations.absTestClsDir()).append(this.locations.absTestSrcDir()).append(this.locations.absClsLibList());
                linkedHashMap.put("test.class.path.prefix", ((SearchPath)object).toString());
            }
        }
        linkedHashMap.put("test.src", this.locations.absTestSrcDir().getPath());
        linkedHashMap.put("test.src.path", this.toString(this.locations.absTestSrcPath()));
        linkedHashMap.put("test.classes", this.locations.absTestClsDir().getPath());
        linkedHashMap.put("test.class.path", this.toString(this.locations.absTestClsPath()));
        linkedHashMap.put("test.vm.opts", StringUtils.join(this.getTestVMOptions(), " "));
        linkedHashMap.put("test.tool.vm.opts", StringUtils.join(this.getTestToolVMOptions(), " "));
        linkedHashMap.put("test.compiler.opts", StringUtils.join(this.getTestCompilerOptions(), " "));
        linkedHashMap.put("test.java.opts", StringUtils.join(this.getTestJavaOptions(), " "));
        linkedHashMap.put("test.jdk", this.getTestJDK().getAbsolutePath());
        linkedHashMap.put("compile.jdk", this.getCompileJDK().getAbsolutePath());
        linkedHashMap.put("test.timeout.factor", String.valueOf(this.getTimeoutFactor()));
        object = this.getNativeDir();
        if (object != null) {
            linkedHashMap.put("test.nativepath", ((File)object).getAbsolutePath());
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private String toString(List<File> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(file.getPath());
        }
        return stringBuilder.toString();
    }

    Agent getAgent(JDK jDK, SearchPath searchPath, List<String> list) throws Agent.Fault {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-classpath");
        arrayList.add(searchPath.toString());
        arrayList.addAll(list);
        for (Agent object2 : this.agents) {
            if (!object2.matches(this.absTestScratchDir(), jDK, arrayList)) continue;
            return object2;
        }
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.getEnvVars());
        SearchPath searchPath2 = new SearchPath(this.getJavaTestClassPath()).append(jDK.getToolsJar());
        hashMap.put("CLASSPATH", searchPath2.toString());
        Agent.Pool pool = Agent.Pool.instance();
        Agent agent = pool.getAgent(this.absTestScratchDir(), jDK, arrayList, hashMap);
        this.agents.add(agent);
        return agent;
    }

    void closeAgent(Agent agent) {
        agent.close();
        this.agents.remove(agent);
    }

    void closeAgents() {
        for (Agent agent : this.agents) {
            agent.close();
        }
        this.agents.clear();
    }

    void releaseAgents() {
        Agent.Pool pool = Agent.Pool.instance();
        for (Agent agent : this.agents) {
            pool.save(agent);
        }
    }

    void saveScratchFile(File file, File file2) {
        this.scratchDirectory.retainFile(file, file2);
    }

    static String getVersion() {
        if (version == null) {
            StringBuilder stringBuilder = new StringBuilder();
            Version version = Version.getCurrent();
            stringBuilder.append(version.product == null ? "jtreg" : version.product);
            if (version.version != null) {
                stringBuilder.append(' ').append(version.version);
            }
            if (version.milestone != null) {
                stringBuilder.append(' ').append(version.milestone);
            }
            if (version.build != null) {
                stringBuilder.append(' ').append(version.build);
            }
            RegressionScript.version = stringBuilder.toString();
        }
        return version;
    }

    static {
        LINESEP = System.getProperty("line.separator");
    }

    public static class TestClassException
    extends TestRunException {
        private static final long serialVersionUID = -5087319602062056951L;

        public TestClassException(String string) {
            super("Test Class Exception: " + string);
        }
    }

    static class ParseActionsException
    extends Exception {
        static final long serialVersionUID = -3369214582449830917L;

        ParseActionsException(String string) {
            super(string);
        }
    }
}

