/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.Expr;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.OS;
import com.sun.javatest.regtest.RegressionParameters;
import com.sun.javatest.regtest.agent.JDK_Version;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionContext
implements Expr.Context {
    private static final String VM_PREFIX = "-XX:";
    private static final String ON_PREFIX = "-XX:+";
    private static final String OFF_PREFIX = "-XX:-";
    private static final String GC_PREFIX = "-XX:+Use";
    private static final String GC_SUFFIX = "GC";
    private static final String D64 = "D64";
    private static final String D32 = "D32";
    private static final String VM_SERVER = "server";
    private static final String VM_CLIENT = "client";
    private static final String VM_MINIMAL = "minimal";
    private static final String MODE_MIXED = "Xmixed";
    private static final String MODE_INT = "Xint";
    private static final String MODE_COMP = "Xcomp";
    private final RegressionParameters params;
    private final Map<String, String> values;
    private final Set<String> validPropNames;
    private Properties sysProps;

    RegressionContext() {
        this(null);
    }

    RegressionContext(RegressionParameters regressionParameters) {
        this.params = regressionParameters;
        this.validPropNames = null;
        this.values = new HashMap<String, String>();
        this.values.put("null", "null");
        JDK jDK = regressionParameters == null ? null : regressionParameters.getTestJDK();
        JDK_Version jDK_Version = jDK == null ? null : jDK.getVersion(regressionParameters);
        this.values.put("jdk.version", jDK_Version != null ? jDK_Version.name : "unknown");
        this.values.put("jdk.version.major", jDK_Version != null ? jDK_Version.major : "0");
        OS oS = OS.current();
        this.values.put("os.name", oS.name);
        this.values.put("os.arch", oS.arch);
        this.values.put("os.simpleArch", oS.simple_arch);
        this.values.put("os.version", oS.version);
        this.values.put("os.simpleVersion", oS.simple_version);
        this.values.put("os.family", oS.family);
        this.values.put("os.processors", String.valueOf(oS.processors));
        this.values.put("os.maxMemory", String.valueOf(oS.maxMemory));
        this.values.put("os.maxSwap", String.valueOf(oS.maxSwap));
        this.processVMOptions(regressionParameters == null ? Collections.emptyList() : regressionParameters.getTestVMJavaOptions());
    }

    RegressionContext(RegressionContext regressionContext, Set<String> set) {
        this.params = regressionContext.params;
        this.values = regressionContext.values;
        this.validPropNames = set;
    }

    @Override
    public boolean isValidName(String string) {
        if (this.validPropNames == null) {
            return true;
        }
        if (this.values.containsKey(string)) {
            return true;
        }
        if (string.startsWith("vm.opt.")) {
            return true;
        }
        return this.validPropNames.contains(string);
    }

    @Override
    public String get(String string) {
        String string2 = this.values.get(string);
        if (string2 == null) {
            string2 = string.startsWith("vm.opt.") ? "null" : this.getProperty(string, "null");
        }
        return string2;
    }

    private String getProperty(String string, String string2) {
        if (this.params == null) {
            throw new IllegalStateException();
        }
        if (this.sysProps == null) {
            this.sysProps = this.params.getTestJDK().getSystemProperties(this.params);
        }
        return this.sysProps.getProperty(string, string2);
    }

    public String toString() {
        return this.values.toString();
    }

    private void processVMOptions(List<String> list) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String object : list) {
            int entry;
            if (object.equals("-D64")) {
                string2 = D64;
                continue;
            }
            if (object.equals("-D32")) {
                string2 = D32;
                continue;
            }
            if (object.equals("-server")) {
                string3 = VM_SERVER;
                continue;
            }
            if (object.equals("-client")) {
                string3 = VM_CLIENT;
                continue;
            }
            if (object.equals("-minimal")) {
                string3 = VM_MINIMAL;
                continue;
            }
            if (object.equals("-Xmixed")) {
                string4 = MODE_MIXED;
                continue;
            }
            if (object.equals("-Xint")) {
                string4 = MODE_INT;
                continue;
            }
            if (object.equals("-Xcomp")) {
                string4 = MODE_COMP;
                continue;
            }
            if (object.startsWith(GC_PREFIX) && object.endsWith(GC_SUFFIX)) {
                string = object.substring(GC_PREFIX.length(), object.length() - GC_SUFFIX.length());
                hashMap.put(object.substring(ON_PREFIX.length()), true);
                continue;
            }
            if (object.startsWith(ON_PREFIX)) {
                hashMap.put(object.substring(ON_PREFIX.length()), true);
                continue;
            }
            if (object.startsWith(OFF_PREFIX)) {
                hashMap.put(object.substring(OFF_PREFIX.length()), false);
                continue;
            }
            if (!object.startsWith(VM_PREFIX) || (entry = object.indexOf(61)) <= 0) continue;
            String string5 = object.substring(VM_PREFIX.length(), entry);
            String string6 = object.substring(entry + 1);
            hashMap2.put(string5, string6);
        }
        String string7 = "null";
        this.values.put("vm.flavor", string3 != null ? string3 : string7);
        this.values.put("vm.bits", (String)(string2 != null ? string2 : string7));
        this.values.put("vm.gc", string != null ? string : string7);
        this.values.put("vm.compMode", (String)(string4 != null ? string4 : string7));
        for (Map.Entry entry : hashMap.entrySet()) {
            this.values.put("vm.opt." + (String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            this.values.put("vm.opt." + (String)entry.getKey(), String.valueOf(entry.getValue()));
        }
    }
}

