/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.RegressionParameters;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Lock {
    static Map<RegressionParameters, Lock> locks = new WeakHashMap<RegressionParameters, Lock>();

    static synchronized Lock get(RegressionParameters regressionParameters) {
        Lock lock = locks.get(regressionParameters);
        if (lock == null) {
            File file = regressionParameters.getExclusiveLock();
            lock = file == null ? new SimpleLock() : new MultiVMLock(file);
            locks.put(regressionParameters, lock);
        }
        return lock;
    }

    abstract void lock();

    abstract void unlock();

    void close() {
    }

    private static class MultiVMLock
    extends SimpleLock {
        private File file;
        private RandomAccessFile raf;
        private FileLock fileLock;

        MultiVMLock(File file) {
            try {
                this.file = file;
                while (!file.exists()) {
                    file.createNewFile();
                }
                this.raf = new RandomAccessFile(file, "rw");
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
        }

        void lock() {
            super.lock();
            boolean bl = false;
            try {
                try {
                    this.fileLock = this.raf.getChannel().lock();
                    bl = true;
                }
                catch (IOException iOException) {
                    throw new Error(iOException);
                }
                Object var4_2 = null;
                if (!bl) {
                    super.unlock();
                }
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (!bl) {
                    super.unlock();
                }
                throw throwable;
            }
        }

        void unlock() {
            try {
                try {
                    this.fileLock.release();
                }
                catch (IOException iOException) {
                    throw new Error(iOException);
                }
                Object var3_1 = null;
                super.unlock();
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                super.unlock();
                throw throwable;
            }
        }

        void close() {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
        }
    }

    private static class SimpleLock
    extends Lock {
        ReentrantLock lock = new ReentrantLock();

        private SimpleLock() {
        }

        void lock() {
            this.lock.lock();
        }

        void unlock() {
            this.lock.unlock();
        }
    }
}

