/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.ExecMode;
import com.sun.javatest.regtest.RegressionParameters;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.agent.GetSystemProperty;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDK {
    private static final Map<File, JDK> cache = new HashMap<File, JDK>();
    private final File jdk;
    private final File absJDK;
    private String version;
    private Map<Set<String>, String> fullVersions;
    private Map<Set<String>, Properties> sysPropsMap;
    private static final String LINESEP = System.getProperty("line.separator");

    public static JDK of(String string) {
        return JDK.of(new File(string));
    }

    public static synchronized JDK of(File file) {
        JDK jDK = cache.get(file);
        if (jDK == null) {
            jDK = new JDK(file);
            cache.put(file, jDK);
        }
        return jDK;
    }

    private JDK(File file) {
        this.jdk = file;
        this.absJDK = file.getAbsoluteFile();
    }

    public File getFile() {
        return this.jdk;
    }

    public File getAbsoluteFile() {
        return this.absJDK;
    }

    public File getCanonicalFile() {
        try {
            return this.jdk.getCanonicalFile();
        }
        catch (IOException iOException) {
            return this.absJDK;
        }
    }

    public File getJavaProg() {
        return new File(new File(this.absJDK, "bin"), "java");
    }

    public File getJavacProg() {
        return new File(new File(this.absJDK, "bin"), "javac");
    }

    public File getToolsJar() {
        return new File(new File(this.absJDK, "lib"), "tools.jar");
    }

    public boolean exists() {
        return this.jdk.exists();
    }

    public String getPath() {
        return this.jdk.getPath();
    }

    public String getAbsolutePath() {
        return this.absJDK.getPath();
    }

    public SearchPath getJavaClassPath() {
        File file = this.absJDK;
        File file2 = new File(file, "lib");
        return new SearchPath(new File(file, "classes"), new File(file2, "classes"), new File(file2, "classes.zip"));
    }

    public SearchPath getJDKClassPath() {
        return new SearchPath(this.getToolsJar());
    }

    JDK_Version getVersion(RegressionParameters regressionParameters) {
        return this.getVersion(regressionParameters.getExecMode(), regressionParameters.getJavaTestClassPath());
    }

    JDK_Version getVersion(ExecMode execMode, SearchPath searchPath) {
        return JDK_Version.forName(this.getVersionAsString(execMode, searchPath));
    }

    private synchronized String getVersionAsString(ExecMode execMode, SearchPath searchPath) {
        if (this.version == null) {
            this.version = "unknown";
            if (execMode == ExecMode.SAMEVM) {
                this.version = System.getProperty("java.specification.version");
            } else {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.environment().put("CLASSPATH", searchPath.toString());
                processBuilder.command(this.getJavaProg().getPath(), GetSystemProperty.class.getName(), "java.specification.version");
                processBuilder.redirectErrorStream(true);
                try {
                    String[] stringArray;
                    Process process = processBuilder.start();
                    String string = this.getOutput(process);
                    int n = process.waitFor();
                    if (n == 0 && (stringArray = StringUtils.splitEqual(string.trim())).length == 2 && stringArray[0].equals("java.specification.version")) {
                        this.version = stringArray[1];
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.version == null || this.version.length() == 0) {
                this.version = "1.1";
            }
        }
        return this.version;
    }

    public synchronized String getFullVersion(Collection<String> collection) {
        LinkedHashSet<String> linkedHashSet;
        String string;
        if (this.fullVersions == null) {
            this.fullVersions = new HashMap<Set<String>, String>();
        }
        if ((string = this.fullVersions.get(linkedHashSet = new LinkedHashSet<String>(collection))) == null) {
            string = this.jdk.getPath();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getJavaProg().getPath());
            arrayList.addAll(collection);
            arrayList.add("-version");
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.redirectErrorStream(true);
            try {
                Process process = processBuilder.start();
                String string2 = this.getOutput(process);
                int n = process.waitFor();
                if (n == 0) {
                    string = "(" + this.jdk + ")" + LINESEP + string2;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fullVersions.put(linkedHashSet, string);
        }
        return string;
    }

    public synchronized Properties getSystemProperties(RegressionParameters regressionParameters) {
        List<String> list;
        LinkedHashSet<String> linkedHashSet;
        Properties properties;
        if (this.sysPropsMap == null) {
            this.sysPropsMap = new HashMap<Set<String>, Properties>();
        }
        if ((properties = this.sysPropsMap.get(linkedHashSet = new LinkedHashSet<String>(list = regressionParameters.getTestVMJavaOptions()))) == null) {
            properties = new Properties();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getJavaProg().getPath());
            arrayList.addAll(list);
            arrayList.add(GetSystemProperty.class.getName());
            arrayList.add("-all");
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.environment().put("CLASSPATH", regressionParameters.getJavaTestClassPath().toString());
            processBuilder.redirectErrorStream(true);
            try {
                Process process = processBuilder.start();
                properties.load(process.getInputStream());
                int n = process.waitFor();
                if (n != 0) {
                    System.err.println("could not get system properties for " + this.getJavaProg() + " " + list);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sysPropsMap.put(linkedHashSet, properties);
        }
        return properties;
    }

    private String getOutput(Process process) {
        try {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
    }

    public String toString() {
        return this.getPath();
    }

    public int hashCode() {
        return this.absJDK.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JDK)) {
            return false;
        }
        JDK jDK = (JDK)object;
        return this.absJDK.equals(jDK.absJDK);
    }
}

