/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.Option;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCovManager {
    public static final String JCOV = "jcov";
    final List<? extends Option> options = Arrays.asList(new Option(Option.ArgType.STD, "jcov", "jcov/classes", new String[]{"jcov/classes"}){

        public void process(String string, String string2) {
            JCovManager.this.classes = new File(string2);
        }
    }, new Option(Option.ArgType.STD, "jcov", null, new String[]{"jcov/include"}){

        public void process(String string, String string2) {
            JCovManager.this.includeOpts.add(string2);
        }
    }, new Option(Option.ArgType.STD, "jcov", null, new String[]{"jcov/include_list"}){

        public void process(String string, String string2) throws BadArgs {
            try {
                JCovManager.this.includeOpts.addAll(JCovManager.this.splitLines(new File(string2)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new BadArgs(i18n, "jcov.file.not.found", string2);
            }
            catch (IOException iOException) {
                throw new BadArgs(i18n, "jcov.error.reading.file", string2, iOException);
            }
        }
    }, new Option(Option.ArgType.STD, "jcov", null, new String[]{"jcov/exclude"}){

        public void process(String string, String string2) {
            JCovManager.this.excludeOpts.add(string2);
        }
    }, new Option(Option.ArgType.STD, "jcov", "jcov/source", new String[]{"jcov/source", "jcov/sourcepath"}){

        public void process(String string, String string2) {
            JCovManager.this.source = new SearchPath(string2);
        }
    }, new Option(Option.ArgType.STD, "jcov", null, new String[]{"jcov/patch"}){

        public void process(String string, String string2) {
            JCovManager.this.patch = new File(string2);
        }
    }, new Option(Option.ArgType.NONE, "jcov", "jcov-verbose", new String[]{"jcov/verbose"}){

        public void process(String string, String string2) {
            JCovManager.this.verbose = "-verbose";
        }
    }, new Option(Option.ArgType.NONE, "jcov", "jcov-verbose", new String[]{"jcov/verbosemore"}){

        public void process(String string, String string2) {
            JCovManager.this.verbose = "-verbosemore";
        }
    }, new Option(Option.ArgType.NONE, "jcov", "jcov-print-env", new String[]{"jcov/print-env"}){

        public void process(String string, String string2) {
            JCovManager.this.printEnv = true;
        }
    });
    private static final JDK thisJDK = JDK.of(System.getProperty("java.home"));
    File jcov_jar;
    File jcov_network_saver_jar;
    private File classes;
    private File patch;
    private SearchPath source;
    private String verbose;
    private boolean printEnv;
    private List<String> includeOpts = new ArrayList<String>();
    private List<String> excludeOpts = new ArrayList<String>();
    JDK testJDK;
    File instrClasses;
    File template;
    File results;
    File report;
    File patchReport;
    int grabberPort;
    int grabberCommandPort;
    String version;
    private Thread grabber;
    static final boolean showJCov = Action.show("showJCov");
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public JCovManager(File file) {
        File file2;
        String string = System.getProperty("jcov.jar");
        File file3 = file2 = string != null ? new File(string) : new File(file, "jcov.jar");
        if (file2.exists()) {
            this.jcov_jar = file2;
        }
        File file4 = file2 = (string = System.getProperty("jcov_network_saver.jar")) != null ? new File(string) : new File(file, "jcov_network_saver.jar");
        if (file2.exists()) {
            this.jcov_network_saver_jar = file2;
        }
        if (System.getProperty("jcov.port") != null) {
            this.grabberPort = Integer.getInteger("jcov.port");
        }
        if (System.getProperty("jcov.command_port") != null) {
            this.grabberCommandPort = Integer.getInteger("jcov.command_port");
        }
    }

    String version() {
        if (this.version == null) {
            List<String> list = Arrays.asList("-version");
            Task task = new Task((List)list){

                void processLine(String string) {
                    if (JCovManager.this.version == null) {
                        JCovManager.this.version = string;
                    }
                }
            };
            task.run();
            if (this.version == null) {
                this.version = "JCov version unknown";
            }
        }
        return this.version;
    }

    boolean isJCovInstalled() {
        return this.jcov_jar != null && this.jcov_network_saver_jar != null;
    }

    boolean isEnabled() {
        return this.classes != null;
    }

    void setWorkDir(File file) {
        file = file.getAbsoluteFile();
        this.instrClasses = new File(file, "jcov/classes");
        this.template = new File(file, "jcov/template.xml");
        this.results = new File(file, "jcov/results.xml");
    }

    void setReportDir(File file) {
        this.report = new File(file, JCOV);
        this.patchReport = new File(file, "text/patch.txt");
    }

    void setTestJDK(JDK jDK) {
        this.testJDK = jDK;
    }

    void instrumentClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("instr");
        this.delete(this.instrClasses);
        this.instrClasses.mkdirs();
        arrayList.add("-output");
        arrayList.add(this.instrClasses.getPath());
        this.delete(this.template);
        arrayList.add("-template");
        arrayList.add(this.template.getPath());
        for (String object2 : this.includeOpts) {
            arrayList.add("-include");
            arrayList.add(object2);
        }
        Object object3 = this.excludeOpts.iterator();
        while (object3.hasNext()) {
            String string = object3.next();
            arrayList.add("-exclude");
            arrayList.add(string);
        }
        if (this.verbose != null) {
            arrayList.add("-verbose");
        }
        if (this.printEnv) {
            arrayList.add("-print-env");
        }
        if (this.containsClass(this.classes, "java/lang/Shutdown")) {
            arrayList.add("-include");
            arrayList.add("java/lang/Shutdown");
            arrayList.add("-saveatend");
            arrayList.add("java/lang/Shutdown.runHooks");
        }
        arrayList.add(this.classes.getPath());
        new Task(this.testJDK, arrayList).run();
        if (this.classes.isFile() && ((File)(object3 = new File(this.instrClasses, this.classes.getName()))).exists()) {
            File file = new File(this.instrClasses.getParent(), "classes.jar");
            file.delete();
            ((File)object3).renameTo(file);
            this.instrClasses.delete();
            this.instrClasses = file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsClass(File file, String string) {
        boolean bl;
        if (file.isDirectory()) {
            return new File(file, string.replace('/', File.separatorChar) + ".class").exists();
        }
        JarFile jarFile = new JarFile(file);
        try {
            bl = jarFile.getEntry(string + ".class") != null;
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startGrabber() {
        if (this.grabber != null) {
            throw new IllegalStateException();
        }
        this.results.delete();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("grabber");
        arrayList.add("-port");
        arrayList.add("0");
        arrayList.add("-command");
        arrayList.add("0");
        arrayList.add("-output");
        arrayList.add(this.results.getPath());
        arrayList.add("-template");
        arrayList.add(this.template.getPath());
        if (this.verbose != null) {
            arrayList.add(this.verbose);
        }
        if (this.printEnv) {
            arrayList.add("-print-env");
        }
        Task task = new Task(arrayList){
            Pattern skip;
            Pattern ports;
            {
                this.skip = Pattern.compile("[A-Z]+\\s*:.*");
                this.ports = Pattern.compile("Server started .*:([0-9]+)\\. .*? ([0-9]+)\\. .*");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void processLine(String string) {
                Matcher matcher;
                super.processLine(string);
                if (!this.skip.matcher(string).matches() && (matcher = this.ports.matcher(string)).matches()) {
                    JCovManager jCovManager = JCovManager.this;
                    synchronized (jCovManager) {
                        JCovManager.this.grabberPort = Integer.parseInt(matcher.group(1));
                        JCovManager.this.grabberCommandPort = Integer.parseInt(matcher.group(2));
                        JCovManager.this.notify();
                    }
                }
            }
        };
        this.grabber = new Thread(task);
        this.grabber.start();
        try {
            long l = System.currentTimeMillis();
            long l2 = l + 30000L;
            JCovManager jCovManager = this;
            synchronized (jCovManager) {
                while (l < l2 && this.grabberPort == 0) {
                    this.wait(l2 - l);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interrupted while waiting for jcov grabber to initialize");
        }
        if (showJCov) {
            System.err.println("jcov grabber port: " + this.grabberPort + ", command port: " + this.grabberCommandPort);
        }
        if (this.grabberPort == 0 || this.grabberCommandPort == 0) {
            System.err.println("Warning: jcov grabber not initialized correctly");
        }
    }

    void stopGrabber() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("grabberManager");
        if (this.printEnv) {
            arrayList.add("-print-env");
        }
        if (this.grabberCommandPort != 0) {
            arrayList.add("-command_port");
            arrayList.add(String.valueOf(this.grabberCommandPort));
        }
        arrayList.add("-stop");
        new Task(arrayList).run();
        try {
            this.grabber.join(30000L);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interrupted while waiting for jcov grabber to exit");
        }
    }

    void writeReport() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("repgen");
        arrayList.add("-source");
        arrayList.add(this.source.toString());
        arrayList.add("-output");
        arrayList.add(this.report.getPath());
        for (String string : this.includeOpts) {
            arrayList.add("-include");
            arrayList.add(string);
        }
        for (String string : this.excludeOpts) {
            arrayList.add("-exclude");
            arrayList.add(string);
        }
        if (this.printEnv) {
            arrayList.add("-print-env");
        }
        arrayList.add(this.results.getPath());
        new Task(arrayList).run();
        if (this.patch != null) {
            this.writePatchReport();
        }
    }

    void writePatchReport() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("diffcoverage");
        arrayList.add("-replaceDiff");
        arrayList.add("[^ ]+/classes/:");
        arrayList.add(this.results.getPath());
        arrayList.add(this.patch.getPath());
        this.patchReport.getParentFile().mkdirs();
        try {
            final PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.patchReport)));
            new Task(arrayList){
                String lastLine;

                public void run() {
                    super.run();
                    if (this.lastLine != null) {
                        super.processLine(this.lastLine);
                    }
                }

                void processLine(String string) {
                    printWriter.println(string);
                    this.lastLine = string;
                }
            }.run();
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Cannot open " + this.patchReport + ": " + iOException);
        }
    }

    boolean delete(File file) {
        boolean bl = true;
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    bl &= this.delete(file2);
                }
            }
            bl &= file.delete();
        }
        if (!bl) {
            System.err.println("Warning: failed to delete " + file);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> splitLines(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0 || string.startsWith("#")) continue;
                arrayList.add(string);
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            bufferedReader.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Task
    implements Runnable {
        JDK jdk;
        String name;
        List<String> opts;

        Task(List<String> list) {
            this(thisJDK, list);
        }

        Task(JDK jDK, List<String> list) {
            this.jdk = jDK;
            this.name = list.get(0);
            this.opts = list;
        }

        @Override
        public void run() {
            try {
                String string;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(this.jdk.getJavaProg().getPath());
                arrayList.add("-jar");
                arrayList.add(JCovManager.this.jcov_jar.getPath());
                arrayList.addAll(this.opts);
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                if (showJCov) {
                    System.err.println("EXEC: " + arrayList);
                }
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    this.processLine(string);
                }
                int n = process.waitFor();
                if (showJCov) {
                    System.err.println("EXEC: " + this.name + " finished, rc=" + n);
                }
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Error running jcov: " + interruptedException);
            }
            catch (IOException iOException) {
                System.err.println("Error running jcov: " + iOException);
            }
        }

        void processLine(String string) {
            System.out.println("[jcov:" + this.name + "] " + string);
        }
    }
}

