/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.Agent;
import com.sun.javatest.regtest.ExecMode;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.Locations;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.ProcessCommand;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.TestRunException;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.TimeoutHandlerProvider;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.CompileActionHelper;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.RStatus;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileAction
extends Action {
    public static final String NAME = "compile";
    private File destDir;
    private boolean reverseStatus = false;
    private String ref = null;
    private int timeout = -1;
    private boolean classpathp = false;
    private boolean sourcepathp = false;
    private boolean process = false;

    @Override
    public String getName() {
        return NAME;
    }

    public Status compile(File file, String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws TestRunException {
        this.destDir = file;
        this.init(stringArray, stringArray2, string, regressionScript);
        return this.run();
    }

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        Object object;
        String string2;
        super.init(stringArray, stringArray2, string, regressionScript);
        if (stringArray2.length == 0) {
            throw new ParseException("No classname provided for `compile'");
        }
        for (String[] stringArray3 : stringArray) {
            string2 = stringArray3[0];
            object = stringArray3[1];
            if (string2.equals("fail")) {
                this.reverseStatus = this.parseFail((String)object);
                continue;
            }
            if (string2.equals("timeout")) {
                this.timeout = this.parseTimeout((String)object);
                continue;
            }
            if (string2.equals("ref")) {
                this.ref = this.parseRef((String)object);
                continue;
            }
            if (string2.equals("process")) {
                this.process = true;
                continue;
            }
            throw new ParseException("Bad option for compile: " + string2);
        }
        if (this.timeout < 0) {
            this.timeout = regressionScript.getActionTimeout(0);
        }
        try {
            Locations locations = regressionScript.locations;
            if (this.destDir == null) {
                this.destDir = locations.absTestClsDir();
            }
            if (!regressionScript.isCheck()) {
                CompileAction.mkdirs(this.destDir);
            }
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                File file;
                string2 = stringArray2[i];
                if (string2.endsWith(".java")) {
                    n = 1;
                    object = new File(string2.replace('/', File.separatorChar));
                    if (!((File)object).isAbsolute()) {
                        file = locations.absTestSrcFile((File)object);
                        if (!file.exists()) {
                            throw new RegressionScript.TestClassException("Can't find source file: " + string2);
                        }
                        stringArray2[i] = file.getPath();
                    }
                } else if (string2.endsWith(".jasm") || string2.endsWith("jcod")) {
                    n2 = 1;
                    object = new File(string2.replace('/', File.separatorChar));
                    if (!((File)object).isAbsolute()) {
                        file = locations.absTestSrcFile((File)object);
                        if (!file.exists()) {
                            throw new RegressionScript.TestClassException("Can't find source file: " + string2);
                        }
                        stringArray2[i] = file.getPath();
                    }
                }
                if (string2.equals("-classpath") || string2.equals("-cp")) {
                    this.classpathp = true;
                    object = new SearchPath(stringArray2[i + 1]).append(regressionScript.getCompileClassPath());
                    stringArray2[i + 1] = ((SearchPath)object).toString();
                }
                if (string2.equals("-d")) {
                    throw new ParseException("Compile option not allowed: ");
                }
                if (!string2.equals("-sourcepath")) continue;
                this.sourcepathp = true;
                object = new SearchPath(stringArray2[i + 1]).append(regressionScript.getCompileSourcePath());
                stringArray2[i + 1] = ((SearchPath)object).toString();
            }
            if (n == 0 && !this.process && n2 == 0) {
                throw new ParseException("No classname ending with `.java' found");
            }
            if (n2 != 0) {
                if (this.sourcepathp || this.classpathp || this.process) {
                    throw new ParseException("Compile option not allowed: ");
                }
                if (this.reverseStatus || this.ref != null) {
                    throw new ParseException("Compile option not allowed: ");
                }
            }
        }
        catch (RegressionScript.TestClassException testClassException) {
            throw new ParseException(testClassException.getMessage());
        }
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (String string : this.args) {
            if (!string.endsWith(".java") && !string.endsWith(".jasm") && !string.endsWith(".jcod")) continue;
            linkedHashSet.add(new File(string));
        }
        return linkedHashSet;
    }

    @Override
    public Status run() throws TestRunException {
        Object object;
        this.startAction();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        boolean bl = false;
        for (String string : this.args) {
            if (string.endsWith(".java")) {
                if (!new File(string).exists()) {
                    throw new TestRunException("Can't find source file: " + string);
                }
                arrayList.add(string);
                bl = true;
                continue;
            }
            if (string.endsWith(".jasm")) {
                arrayList2.add(string);
                continue;
            }
            if (string.endsWith(".jcod")) {
                arrayList3.add(string);
                continue;
            }
            arrayList.add(string);
        }
        if (this.script.isCheck()) {
            object = RStatus.passed("Test description appears acceptable");
        } else {
            object = RStatus.passed("Not yet run");
            if (((Status)object).isPassed() && !arrayList2.isEmpty()) {
                object = this.jasm(arrayList2);
            }
            if (((Status)object).isPassed() && !arrayList3.isEmpty()) {
                object = this.jcod(arrayList3);
            }
            if (((Status)object).isPassed() && bl) {
                switch (this.script.getExecMode()) {
                    case AGENTVM: {
                        object = this.runAgentJVM(arrayList);
                        break;
                    }
                    case OTHERVM: {
                        object = this.runOtherJVM(arrayList);
                        break;
                    }
                    case SAMEVM: {
                        object = this.runSameJVM(arrayList);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        this.endAction((Status)object);
        return object;
    }

    private Status jasm(List<String> list) {
        return this.asmtools("jasm", list);
    }

    private Status jcod(List<String> list) {
        return this.asmtools("jcoder", list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status asmtools(String string, List<String> list) {
        if (list.isEmpty()) {
            return Status.passed(string + ": no files");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-d");
        arrayList.add(this.destDir.getPath());
        arrayList.addAll(list);
        try {
            Status status;
            String string2 = "org.openjdk.asmtools." + string + ".Main";
            this.recorder.asmtools(string2, arrayList);
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(PrintStream.class, String.class);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            try {
                Object obj = constructor.newInstance(printStream, string);
                Method method = clazz.getMethod(NAME, String[].class);
                Object object = method.invoke(obj, new Object[]{arrayList.toArray(new String[0])});
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    Status status2 = bl ? Status.passed(string + " OK") : Status.failed(string + " failed");
                    Object var15_22 = null;
                    PrintWriter printWriter = this.section.createOutput(string);
                    printWriter.write(byteArrayOutputStream.toString());
                    printWriter.close();
                    return status2;
                }
                status = Status.error("unexpected result from " + string + ": " + object.toString());
            }
            catch (Throwable throwable) {
                Object var15_24 = null;
                PrintWriter printWriter = this.section.createOutput(string);
                printWriter.write(byteArrayOutputStream.toString());
                printWriter.close();
                throw throwable;
            }
            Object var15_23 = null;
            PrintWriter printWriter = this.section.createOutput(string);
            printWriter.write(byteArrayOutputStream.toString());
            printWriter.close();
            return status;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Status.error("can't find " + string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Status.error("error invoking " + string + ": " + noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            return Status.error("error invoking " + string + ": " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            return Status.error("error invoking " + string + ": " + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            return Status.error("error invoking " + string + ": " + invocationTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Status.error("error invoking " + string + ": " + illegalArgumentException);
        }
        catch (SecurityException securityException) {
            return Status.error("error invoking " + string + ": " + securityException);
        }
    }

    private Status runOtherJVM(List<String> list) throws TestRunException {
        String string22;
        Object object2;
        Object object3;
        File file;
        if (list.size() < 10) {
            file = null;
        } else {
            this.script.absTestClsDir().mkdirs();
            object3 = new File(this.script.getTestResult().getWorkRelativePath()).getName().replace(".jtr", ".compile.");
            file = new File(this.script.absTestClsDir(), (String)object3 + this.script.getNextSerial() + ".jta");
            try {
                object2 = new BufferedWriter(new FileWriter(file));
                for (String string22 : list) {
                    ((Writer)object2).write(string22);
                    ((BufferedWriter)object2).newLine();
                }
                ((BufferedWriter)object2).close();
            }
            catch (IOException iOException) {
                return RStatus.error("Can't write `compile' argument file");
            }
            catch (SecurityException securityException) {
                return RStatus.error("Unable to create `compile' argument file");
            }
        }
        object3 = this.script.getTestProperties();
        object2 = new LinkedHashMap<String, String>();
        object2.putAll(this.script.getEnvVars());
        SearchPath searchPath = new SearchPath(this.script.getJavaTestClassPath(), this.script.getCompileClassPath());
        string22 = this.script.getJavacProg();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.script.getTestVMOptions());
        if (this.script.getCompileJDK().equals(this.script.getTestJDK())) {
            arrayList.addAll(this.script.getTestDebugOptions());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(this.script.getTestCompilerOptions());
        if (this.destDir != null) {
            arrayList2.add("-d");
            arrayList2.add(this.destDir.toString());
        }
        if (!this.classpathp) {
            arrayList2.add("-classpath");
            arrayList2.add(searchPath.toString());
        }
        if (!this.sourcepathp) {
            arrayList2.add("-sourcepath");
            arrayList2.add(this.script.getCompileSourcePath().toString());
        }
        if (file != null) {
            arrayList2.add("@" + file);
        } else {
            arrayList2.addAll(list);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add(string22);
        for (String object4 : arrayList) {
            arrayList3.add("-J" + object4);
        }
        for (Map.Entry entry : object3.entrySet()) {
            arrayList3.add("-J-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        arrayList3.addAll(arrayList2);
        if (showMode) {
            this.showMode(NAME, ExecMode.OTHERVM, this.section);
        }
        if (showCmd) {
            this.showCmd(NAME, arrayList3, this.section);
        }
        this.recorder.javac((Map<String, String>)object2, string22, arrayList, (Map<String, String>)object3, arrayList2);
        ActionHelper.PrintStringWriter printStringWriter = new ActionHelper.PrintStringWriter();
        ActionHelper.PrintStringWriter printStringWriter2 = new ActionHelper.PrintStringWriter();
        ProcessCommand processCommand = new ProcessCommand(){

            protected Status getStatus(int n, Status status) {
                JDK_Version jDK_Version = CompileAction.this.script.getCompileJDKVersion();
                return CompileActionHelper.getStatusForJavacExitCode(jDK_Version, n);
            }
        };
        TimeoutHandler timeoutHandler = TimeoutHandlerProvider.createHandler(this.script, this.section);
        processCommand.setExecDir(this.script.absTestScratchDir()).setCommand(arrayList3).setEnvironment((Map<String, String>)object2).setStreams(printStringWriter, printStringWriter2).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
        Status status = RStatus.normalize(processCommand.exec());
        PrintWriter printWriter = this.section.createOutput("System.out");
        printWriter.write(printStringWriter.getOutput());
        printWriter.close();
        PrintWriter printWriter2 = this.section.createOutput("System.err");
        printWriter2.write(printStringWriter2.getOutput());
        printWriter2.close();
        status = this.checkReverse(status, this.reverseStatus);
        if (this.ref != null && status.isPassed()) {
            String string = printStringWriter.getOutput() + printStringWriter2.getOutput();
            status = this.checkGoldenFile(string, status);
        }
        return status;
    }

    private Status runSameJVM(List<String> list) throws TestRunException {
        Map<String, String> map = this.script.getTestProperties();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.script.getTestCompilerOptions());
        if (this.destDir != null) {
            arrayList.add("-d");
            arrayList.add(this.destDir.toString());
        }
        if (!this.classpathp) {
            arrayList.add("-classpath");
            arrayList.add(this.script.getCompileClassPath().toString());
        }
        if (!this.sourcepathp) {
            arrayList.add("-sourcepath");
            arrayList.add(this.script.getCompileSourcePath().toString());
        }
        arrayList.addAll(list);
        if (showMode) {
            this.showMode(NAME, ExecMode.SAMEVM, this.section);
        }
        if (showCmd) {
            this.showCmd(NAME, arrayList, this.section);
        }
        String string = this.script.getJavacProg();
        List<String> list2 = this.script.getTestVMJavaOptions();
        this.recorder.javac(this.script.getEnvVars(), string, list2, map, arrayList);
        Status status = CompileActionHelper.runCompile(this.script.getTestResult().getTestName(), map, arrayList, this.timeout, CompileAction.getOutputHandler(this.section));
        status = this.checkReverse(status, this.reverseStatus);
        if (this.ref != null && status.isPassed()) {
            String string2 = this.getOutput(ActionHelper.OutputHandler.OutputKind.DIRECT);
            String string3 = this.getOutput(ActionHelper.OutputHandler.OutputKind.DIRECT_LOG);
            String string4 = this.getOutput(ActionHelper.OutputHandler.OutputKind.STDOUT);
            String string5 = this.getOutput(ActionHelper.OutputHandler.OutputKind.STDERR);
            String string6 = string2 + string3 + string4 + string5;
            status = this.checkGoldenFile(string6, status);
        }
        return status;
    }

    private Status runAgentJVM(List<String> list) throws TestRunException {
        Agent agent;
        Object object;
        Object object2;
        Object object3;
        Map<String, String> map = this.script.getTestProperties();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.script.getTestCompilerOptions());
        if (this.destDir != null) {
            arrayList.add("-d");
            arrayList.add(this.destDir.toString());
        }
        if (!this.classpathp) {
            arrayList.add("-classpath");
            arrayList.add(this.script.getCompileClassPath().toString());
        }
        if (!this.sourcepathp) {
            arrayList.add("-sourcepath");
            arrayList.add(this.script.getCompileSourcePath().toString());
        }
        arrayList.addAll(list);
        if (showMode) {
            this.showMode(NAME, ExecMode.AGENTVM, this.section);
        }
        if (showCmd) {
            this.showCmd(NAME, arrayList, this.section);
        }
        String string = this.script.getJavacProg();
        List<String> list2 = this.script.getTestVMJavaOptions();
        this.recorder.javac(this.script.getEnvVars(), string, list2, map, arrayList);
        try {
            object3 = this.script.getCompileJDK();
            object2 = new SearchPath(this.script.getJavaTestClassPath(), ((JDK)object3).getJDKClassPath());
            object = ((JDK)object3).equals(this.script.getTestJDK()) ? CompileAction.join(this.script.getTestVMOptions(), this.script.getTestDebugOptions()) : this.script.getTestVMOptions();
            agent = this.script.getAgent((JDK)object3, (SearchPath)object2, (List<String>)object);
        }
        catch (Agent.Fault fault) {
            return RStatus.error("Cannot get VM for test: " + fault.getCause());
        }
        object3 = TimeoutHandlerProvider.createHandler(this.script, this.section);
        try {
            object2 = agent.doCompileAction(this.script.getTestResult().getTestName(), map, arrayList, this.timeout, (TimeoutHandler)object3, this.section);
        }
        catch (Agent.Fault fault) {
            object2 = fault.getCause() instanceof IOException ? RStatus.error(String.format("Agent communication error: %s; check console log for any additional details", fault.getCause())) : RStatus.error(String.format("Agent error: %s; check console log for any additional details", fault.getCause()));
        }
        if (((Status)object2).isError()) {
            this.script.closeAgent(agent);
        }
        object2 = this.checkReverse((Status)object2, this.reverseStatus);
        if (this.ref != null && ((Status)object2).isPassed()) {
            object = this.getOutput(ActionHelper.OutputHandler.OutputKind.DIRECT);
            String string2 = this.getOutput(ActionHelper.OutputHandler.OutputKind.DIRECT_LOG);
            String string3 = this.getOutput(ActionHelper.OutputHandler.OutputKind.STDOUT);
            String string4 = this.getOutput(ActionHelper.OutputHandler.OutputKind.STDERR);
            String string5 = (String)object + string2 + string3 + string4;
            object2 = this.checkGoldenFile(string5, (Status)object2);
        }
        return object2;
    }

    private String getOutput(ActionHelper.OutputHandler.OutputKind outputKind) {
        String string = this.section.getOutput(outputKind.name);
        return string == null ? "" : string;
    }

    private String parseRef(String string) throws ParseException {
        if (string == null || string.equals("")) {
            throw new ParseException("No reference file name");
        }
        File file = new File(this.script.absTestSrcDir(), string);
        if (!file.exists()) {
            throw new ParseException("Can't find reference file: " + file);
        }
        return string;
    }

    private Status checkReverse(Status status, boolean bl) {
        if (!status.isError()) {
            String string;
            boolean bl2 = status.isPassed();
            int n = status.getType();
            if (bl2 && bl) {
                string = "Compilation passed unexpectedly";
                n = 1;
            } else if (bl2 && !bl) {
                string = "Compilation successful";
            } else if (!bl2 && bl) {
                string = "Compilation failed as expected";
                n = 0;
            } else {
                string = "Compilation failed";
            }
            if (n == 1 && status.getReason() != null && !status.getReason().equals("Execution successful")) {
                string = string + ": " + status.getReason();
            }
            status = RStatus.createStatus(n, string);
        }
        return status;
    }

    private Status checkGoldenFile(String string, Status status) throws TestRunException {
        File file = new File(this.script.absTestSrcDir(), this.ref);
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader(file));
            int n = this.compareGoldenFile(bufferedReader, bufferedReader2);
            if (n != 0) {
                return RStatus.failed("Output does not match reference file: " + this.ref + ", line " + n);
            }
            return status;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TestRunException("Can't find reference file: " + file);
        }
    }

    private int compareGoldenFile(BufferedReader bufferedReader, BufferedReader bufferedReader2) throws TestRunException {
        try {
            String string;
            String string2;
            int n = 0;
            do {
                string2 = bufferedReader.readLine();
                string = bufferedReader2.readLine();
                ++n;
                if (string2 != null || string != null) continue;
                return 0;
            } while (string2 != null && string != null && string2.equals(string));
            return n;
        }
        catch (IOException iOException) {
            File file = new File(this.script.absTestSrcDir(), this.ref);
            throw new TestRunException("Problem reading reference file: " + file);
        }
    }
}

