/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.Locations;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.TestRunException;
import com.sun.javatest.regtest.agent.RStatus;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanAction
extends Action {
    public static final String NAME = "clean";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        super.init(stringArray, stringArray2, string, regressionScript);
        if (stringArray.length != 0) {
            throw new ParseException("Unexpected option(s) for `clean'");
        }
        if (stringArray2.length == 0) {
            throw new ParseException("No classname(s) provided for `clean'");
        }
        for (String string2 : stringArray2) {
            if (string2.indexOf(File.separatorChar) == -1 && string2.indexOf(47) == -1) continue;
            throw new ParseException("Bad classname provided for `clean': " + string2);
        }
    }

    @Override
    public Status run() throws TestRunException {
        Status status = RStatus.passed("Clean successful");
        this.startAction();
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            for (int i = 0; i < this.args.length; ++i) {
                Object object;
                if (this.args[i].equals("*")) {
                    this.args[i] = ".*";
                }
                if (this.args[i].endsWith(".*")) {
                    object = this.args[i].substring(0, this.args[i].length() - 2);
                    object = ((String)object).replace('.', File.separatorChar);
                    File file = this.script.absTestClsDir();
                    if (!((String)object).equals("")) {
                        file = new File(file, (String)object);
                    }
                    this.recorder.exec("for f in " + file + "/*; do\n" + "  if [ -f $f ]; then rm $f ; fi\n" + "done");
                    try {
                        File[] fileArray;
                        if (!file.isDirectory() || (fileArray = file.listFiles()) == null) continue;
                        for (File file2 : fileArray) {
                            if (file2.delete() || file2.isDirectory()) continue;
                            throw new TestRunException("`clean' unable to delete file: " + file2);
                        }
                        continue;
                    }
                    catch (SecurityException securityException) {
                        throw new TestRunException("Problem deleting directory contents: " + file);
                    }
                }
                object = new File(this.script.absTestClsDir(), this.args[i].replace('.', File.separatorChar) + ".class");
                this.recorder.exec("rm -f " + object);
                if (!((File)object).exists() || ((File)object).delete()) continue;
                return RStatus.error("`clean' unable to delete file: " + object);
            }
        }
        this.endAction(status);
        return status;
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (String string : this.args) {
            try {
                for (Locations.ClassLocn classLocn : this.script.locations.locateClasses(string)) {
                    if (!classLocn.absSrcFile.exists()) continue;
                    linkedHashSet.add(classLocn.absSrcFile);
                }
            }
            catch (TestRunException testRunException) {
                // empty catch block
            }
        }
        return linkedHashSet;
    }
}

