/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.finder.CommentStream;
import com.sun.javatest.finder.HTMLCommentStream;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.finder.ShScriptCommentStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CheckFiles {
    private int count;
    private int lineLength = 80;
    private static final int HTML = 0;
    private static final int JAVA = 1;
    private static final int SH = 2;
    private static final int OTHER = 3;
    private static final Set<String> excludes = new HashSet<String>();

    public static void main(String[] stringArray) {
        new CheckFiles().run(stringArray);
    }

    public void run(String[] stringArray) {
        Object object;
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            if (!((String)object).equals("-l") || n + 1 >= stringArray.length) {
                if (!((String)object).startsWith("-")) break;
                System.err.println("bad arg: " + (String)object);
                return;
            }
            this.lineLength = Integer.parseInt(stringArray[++n]);
        }
        this.count = 0;
        for (n = 0; n < stringArray.length; ++n) {
            object = new File(stringArray[n]);
            this.scan((File)object);
        }
        System.err.println(this.count + " suspect comments found");
    }

    public void scan(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            this.scan(fileArray[i]);
        }
    }

    public void scan(File file) {
        if (file.isDirectory()) {
            if (!excludes.contains(file.getName())) {
                this.scan(file.listFiles());
            }
        } else {
            switch (CheckFiles.getExtension(file)) {
                case 1: {
                    this.check(file, new JavaCommentStream());
                    break;
                }
                case 0: {
                    this.check(file, new HTMLCommentStream());
                    break;
                }
                case 2: {
                    this.check(file, new ShScriptCommentStream());
                }
            }
        }
    }

    private void check(File file, CommentStream commentStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            commentStream.init(bufferedReader);
            while ((string = commentStream.readComment()) != null) {
                this.check(file, string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("error for " + file + ": " + iOException);
        }
    }

    private void check(File file, String string) {
        string = string.replace('\r', ' ');
        if ((string = string.replace('\n', ' ')).indexOf("@test") != -1) {
            return;
        }
        if (string.matches(".*@(run|main|compile|summary|bug).*")) {
            System.out.println(file + ": " + string.substring(0, Math.min(this.lineLength, string.length())));
            ++this.count;
        }
    }

    static int getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return 3;
        }
        String string2 = string.toLowerCase().substring(n + 1);
        if (string2.equals("java")) {
            return 1;
        }
        if (string2.equals("html")) {
            return 0;
        }
        if (string2.equals("sh")) {
            return 2;
        }
        return 3;
    }

    static {
        excludes.add("SCCS");
        excludes.add("Codemgr_wsdata");
        excludes.add(".hg");
        excludes.add(".svn");
        excludes.add("RCS");
    }
}

