/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.ProcessUtils;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.AgentServer;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.RStatus;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent {
    static final boolean showAgent = Action.show("showAgent");
    static final boolean traceAgent = Action.show("traceAgent");
    final JDK jdk;
    final List<String> vmOpts;
    final File scratchDir;
    final Process process;
    final DataInputStream in;
    final DataOutputStream out;
    final AgentServer.KeepAlive keepAlive;
    final int id;
    static int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Agent(File file, JDK jDK, List<String> list, Map<String, String> map, File file2) throws Fault {
        try {
            this.id = count++;
            this.jdk = jDK;
            this.scratchDir = file;
            this.vmOpts = list;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(jDK.getJavaProg().getPath());
            arrayList.addAll(list);
            if (file2 != null) {
                arrayList.add("-Djava.security.policy=" + file2.toURI());
            }
            arrayList.add(AgentServer.class.getName());
            if (file2 != null) {
                arrayList.add("-allowSetSecurityManager");
            }
            ServerSocket serverSocket = new ServerSocket(0, 1);
            arrayList.add("-port");
            arrayList.add(String.valueOf(serverSocket.getLocalPort()));
            if (showAgent || traceAgent) {
                System.err.println("Agent[" + this.id + "]: Started " + arrayList);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.directory(file);
            Map<String, String> map2 = processBuilder.environment();
            map2.clear();
            map2.putAll(map);
            this.process = processBuilder.start();
            this.copyStream("stdout", this.process.getInputStream(), System.out);
            this.copyStream("stderr", this.process.getErrorStream(), System.err);
            try {
                serverSocket.setSoTimeout(60000);
                Socket socket = serverSocket.accept();
                socket.setSoTimeout(120000);
                this.in = new DataInputStream(socket.getInputStream());
                this.out = new DataOutputStream(socket.getOutputStream());
            }
            finally {
                serverSocket.close();
            }
            this.keepAlive = new AgentServer.KeepAlive(this.out, traceAgent);
            this.keepAlive.setEnabled(true);
        }
        catch (IOException iOException) {
            throw new Fault(iOException);
        }
    }

    void copyStream(final String string, final InputStream inputStream, final PrintStream printStream) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    try {
                        String string2;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            printStream.println("Agent[" + Agent.this.id + "]." + string + ": " + string2);
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public boolean matches(File file, JDK jDK, List<String> list) {
        return file.getName().equals(this.scratchDir.getName()) && this.jdk.equals(jDK) && this.vmOpts.equals(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status doCompileAction(String string, Map<String, String> map, List<String> list, int n, final TimeoutHandler timeoutHandler, TestResult.Section section) throws Fault {
        final PrintWriter printWriter = section.getMessageWriter();
        Alarm alarm = Alarm.NONE;
        if (n > 0) {
            if (timeoutHandler == null) {
                throw new NullPointerException("TimeoutHandler is required");
            }
            alarm = Alarm.schedule(n, TimeUnit.SECONDS, printWriter, new Runnable(){

                public void run() {
                    timeoutHandler.handleTimeout(Agent.this.process);
                    try {
                        Agent.this.out.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(printWriter);
                    }
                    try {
                        Agent.this.in.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(printWriter);
                    }
                }
            });
        }
        this.keepAlive.setEnabled(false);
        try {
            if (traceAgent) {
                System.err.println("Agent.doCompileAction " + string + " " + list);
            }
            Object object = this.out;
            synchronized (object) {
                this.out.writeByte(1);
                this.out.writeUTF(string);
                this.writeProperties(map);
                this.writeList(list);
                this.out.flush();
            }
            if (traceAgent) {
                System.err.println("Agent.doCompileAction: request sent");
            }
            object = this.readResults(section);
            return object;
        }
        catch (IOException iOException) {
            if (traceAgent) {
                System.err.println("Agent.doCompileAction: error " + iOException);
            }
            if (alarm.didFire()) {
                throw new Fault(new Exception("Agent timed out after a timeout of " + n + " seconds"));
            }
            throw new Fault(iOException);
        }
        finally {
            alarm.cancel();
            this.keepAlive.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status doMainAction(String string, Map<String, String> map, SearchPath searchPath, String string2, List<String> list, int n, final TimeoutHandler timeoutHandler, TestResult.Section section) throws Fault {
        final PrintWriter printWriter = section.getMessageWriter();
        Alarm alarm = Alarm.NONE;
        if (n > 0) {
            if (timeoutHandler == null) {
                throw new NullPointerException("TimeoutHandler is required");
            }
            alarm = Alarm.schedule(n, TimeUnit.SECONDS, printWriter, new Runnable(){

                public void run() {
                    timeoutHandler.handleTimeout(Agent.this.process);
                    try {
                        Agent.this.out.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printWriter);
                    }
                    try {
                        Agent.this.in.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(printWriter);
                    }
                }
            });
        }
        this.keepAlive.setEnabled(false);
        try {
            if (traceAgent) {
                System.err.println("Agent.doMainAction " + string + " " + searchPath + " " + string2 + " " + list);
            }
            Object object = this.out;
            synchronized (object) {
                this.out.writeByte(2);
                this.out.writeUTF(string);
                this.writeProperties(map);
                this.out.writeUTF(searchPath.toString());
                this.out.writeUTF(string2);
                this.writeList(list);
                this.out.flush();
            }
            if (traceAgent) {
                System.err.println("Agent.doMainAction: request sent");
            }
            object = this.readResults(section);
            return object;
        }
        catch (IOException iOException) {
            if (traceAgent) {
                System.err.println("Agent.doMainAction: error " + iOException);
            }
            if (alarm.didFire()) {
                throw new Fault(new Exception("Agent timed out with a timeout of " + n + " seconds"));
            }
            throw new Fault(iOException);
        }
        finally {
            alarm.cancel();
            this.keepAlive.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (showAgent || traceAgent) {
            System.err.println("Agent[" + this.id + "]: Closing...");
        }
        this.keepAlive.finished();
        try {
            this.out.write(6);
            this.out.close();
        }
        catch (IOException iOException) {
            if (traceAgent) {
                System.err.println("Agent[" + this.id + "]: Killing process (" + iOException + ")");
            }
            ProcessUtils.destroyForcibly(this.process);
        }
        PrintWriter printWriter = new PrintWriter(System.err, true);
        Alarm alarm = Alarm.schedulePeriodicInterrupt(60L, TimeUnit.SECONDS, printWriter, Thread.currentThread());
        try {
            int n = this.process.waitFor();
            if (n != 0 || traceAgent) {
                System.err.println("Agent[" + this.id + "]: Exited, process exit code: " + n);
            }
        }
        catch (InterruptedException interruptedException) {
            if (traceAgent) {
                System.err.println("Agent[" + this.id + "]: Interrupted while closing");
            }
            System.err.println("Agent[" + this.id + "]: Killing process");
            ProcessUtils.destroyForcibly(this.process);
        }
        finally {
            alarm.cancel();
            Thread.interrupted();
        }
        if (showAgent || traceAgent) {
            System.err.println("Agent[" + this.id + "]: Closed");
        }
    }

    void writeList(List<String> list) throws IOException {
        this.out.writeShort(list.size());
        for (String string : list) {
            this.out.writeUTF(string);
        }
    }

    void writeOptionalString(String string) throws IOException {
        if (string == null) {
            this.out.writeByte(0);
        } else {
            this.out.writeByte(1);
            this.out.writeUTF(string);
        }
    }

    static String readOptionalString(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        return by == 0 ? null : dataInputStream.readUTF();
    }

    void writeProperties(Map<String, String> map) throws IOException {
        this.out.writeShort(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.out.writeUTF(entry.getKey());
            this.out.writeUTF(entry.getValue());
        }
    }

    Status readResults(TestResult.Section section) throws IOException {
        byte by;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block5: while ((by = this.in.readByte()) != -1) {
            switch (by) {
                case 3: {
                    Object object;
                    String string = this.in.readUTF();
                    String string2 = this.in.readUTF();
                    if (traceAgent) {
                        System.err.println("Agent.readResults: OUTPUT '" + string + "' '" + string2 + "\"");
                    }
                    if ((object = (PrintWriter)hashMap.get(string)) == null) {
                        object = string.equals(ActionHelper.OutputHandler.OutputKind.LOG.name) ? section.getMessageWriter() : section.createOutput(string);
                        hashMap.put(string, object);
                    }
                    ((PrintWriter)object).write(string2);
                    continue block5;
                }
                case 4: {
                    byte by2 = this.in.readByte();
                    String string2 = this.in.readUTF();
                    if (traceAgent) {
                        System.err.println("Agent.readResults: STATUS '" + by2 + "' '" + string2 + "\"");
                    }
                    for (PrintWriter printWriter : hashMap.values()) {
                        if (printWriter == section.getMessageWriter()) continue;
                        printWriter.close();
                    }
                    Object object = RStatus.createStatus(by2, string2);
                    return object;
                }
                case 5: {
                    continue block5;
                }
            }
            throw new IOException("Agent: unexpected op: " + by);
        }
        throw new EOFException("unexpected EOF");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pool {
        private static Pool instance;
        private final Map<String, Queue<Agent>> map = new HashMap<String, Queue<Agent>>();
        private File policyFile;

        static synchronized Pool instance() {
            if (instance == null) {
                instance = new Pool();
            }
            return instance;
        }

        private Pool() {
        }

        void setSecurityPolicy(File file) {
            this.policyFile = file;
        }

        synchronized Agent getAgent(File file, JDK jDK, List<String> list, Map<String, String> map) throws Fault {
            Agent agent;
            Queue<Agent> queue = this.map.get(Pool.getKey(file, jDK, list));
            Agent agent2 = agent = queue == null ? null : queue.poll();
            if (agent == null) {
                agent = new Agent(file, jDK, list, map, this.policyFile);
            }
            return agent;
        }

        synchronized void save(Agent agent) {
            String string = Pool.getKey(agent.scratchDir, agent.jdk, agent.vmOpts);
            Queue<Agent> queue = this.map.get(string);
            if (queue == null) {
                queue = new LinkedList<Agent>();
                this.map.put(string, queue);
            }
            queue.add(agent);
        }

        synchronized void flush() {
            for (Queue<Agent> queue : this.map.values()) {
                for (Agent agent : queue) {
                    agent.close();
                }
            }
            this.map.clear();
        }

        synchronized void close(File file) {
            Iterator<Queue<Agent>> iterator = this.map.values().iterator();
            while (iterator.hasNext()) {
                Queue<Agent> queue = iterator.next();
                Iterator iterator2 = queue.iterator();
                while (iterator2.hasNext()) {
                    Agent agent = (Agent)iterator2.next();
                    if (!agent.scratchDir.equals(file)) continue;
                    iterator2.remove();
                }
                if (!queue.isEmpty()) continue;
                iterator.remove();
            }
        }

        private static String getKey(File file, JDK jDK, List<String> list) {
            return file.getAbsolutePath() + " " + jDK.getAbsoluteFile() + " " + StringUtils.join(list, " ");
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(Throwable throwable) {
            super(throwable);
        }
    }
}

