/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class VerboseCommand
extends Command {
    private static final String DEFAULT = "default";
    private static final String MAX = "max";
    private static final String QUIET = "quiet";
    private static final String DATE = "date";
    private static final String NO_PREFIX = "no-";
    private static Map allOptions;
    private HashMap optionValues = new HashMap();
    private static final String CMD = "verbose";
    private static I18NResourceBundle i18n;

    public static void addOption(String name, HelpTree.Node node) {
        VerboseCommand.ensureAllOptionsInitialized();
        allOptions.put(name, node);
    }

    private static void ensureAllOptionsInitialized() {
        if (allOptions == null) {
            allOptions = new TreeMap();
            allOptions.put(MAX, new HelpTree.Node(i18n, "verb.max"));
            allOptions.put(QUIET, new HelpTree.Node(i18n, "verb.quiet"));
        }
    }

    VerboseCommand(String cmd) throws Command.Fault {
        super(cmd);
        int chop = cmd.indexOf(CMD);
        if (chop == -1) {
            throw new IllegalArgumentException();
        }
        String workstr = cmd.substring(chop + CMD.length());
        if (workstr.length() == 0) {
            this.optionValues.put(DEFAULT, Boolean.TRUE);
        } else if (workstr.charAt(0) == ':') {
            workstr = workstr.substring(1);
            this.processOptions(workstr);
        } else {
            throw new Command.Fault(i18n, "verb.badOpts");
        }
    }

    private void processOptions(String ops) throws Command.Fault {
        VerboseCommand.ensureAllOptionsInitialized();
        String[] items = StringArray.splitList(ops, ",");
        if (items == null) {
            throw new Command.Fault(i18n, "verb.noOpts");
        }
        for (int i = 0; i < items.length; ++i) {
            boolean on;
            String item = items[i];
            if (item.startsWith(NO_PREFIX)) {
                on = false;
                item = item.substring(NO_PREFIX.length());
            } else {
                on = true;
            }
            if (!allOptions.containsKey(item.toLowerCase())) {
                throw (Command)this.new Command.Fault(i18n, "verb.badOpt", item);
            }
            this.optionValues.put(item, new Boolean(on));
        }
    }

    public void run(CommandContext ctx) throws Command.Fault {
        for (Map.Entry e : this.optionValues.entrySet()) {
            String name = (String)e.getKey();
            boolean value = (Boolean)e.getValue();
            if (name.equalsIgnoreCase(MAX)) {
                ctx.setVerboseMax(value);
                continue;
            }
            if (name.equalsIgnoreCase(QUIET)) {
                ctx.setVerboseQuiet(value);
                continue;
            }
            if (name.equalsIgnoreCase(DATE)) {
                ctx.setVerboseTimestampEnabled(value);
                continue;
            }
            ctx.setVerboseOptionValue(name, value);
        }
    }

    static HelpTree.Node getHelp() {
        VerboseCommand.ensureAllOptionsInitialized();
        HelpTree.Node[] nodes = new HelpTree.Node[allOptions.size()];
        int i = 0;
        Iterator iter = allOptions.values().iterator();
        while (iter.hasNext()) {
            nodes[i++] = (HelpTree.Node)iter.next();
        }
        return new HelpTree.Node(i18n, "verb", nodes);
    }

    static String getName() {
        return CMD;
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(VerboseCommand.class);
    }
}

