/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.SortedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Preferences {
    private static Preferences theOne;
    private File prefsFile;
    private Properties props;
    private Hashtable observers = new Hashtable();
    private boolean isUpToDate;
    private long fileModifiedTime;
    private static I18NResourceBundle i18n;

    public static Preferences access() {
        if (theOne == null) {
            theOne = new Preferences(Preferences.getDefaultPrefsFile());
        }
        return theOne;
    }

    static File getPrefsDir() {
        File userDir = new File(System.getProperty("user.home"));
        String prefDir = System.getProperty("javatest.preferences.dir", ".javatest");
        return new File(userDir, prefDir);
    }

    private static File getDefaultPrefsFile() {
        String s = System.getProperty("javatest.preferences.file");
        if (s == null) {
            File jtDir = Preferences.getPrefsDir();
            return new File(jtDir, "preferences");
        }
        if (!s.equals("NONE")) {
            return new File(s);
        }
        return null;
    }

    private Preferences(File file) {
        this.prefsFile = file;
        this.isUpToDate = true;
        SortedProperties p = new SortedProperties();
        try {
            if (this.prefsFile != null) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.prefsFile));
                p.load(in);
                ((InputStream)in).close();
                this.fileModifiedTime = this.prefsFile.lastModified();
            }
        }
        catch (FileNotFoundException ignore) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.props = p;
    }

    public synchronized void save() {
        if (!(this.prefsFile == null || this.isUpToDate && this.fileModifiedTime == this.prefsFile.lastModified())) {
            try {
                File parentDir = new File(this.prefsFile.getParent());
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.prefsFile));
                this.props.store(out, "JT Harness Preferences");
                ((OutputStream)out).close();
                this.isUpToDate = true;
                this.fileModifiedTime = this.prefsFile.lastModified();
            }
            catch (IOException e) {
                System.err.println(i18n.getString("prefs.cannotSave", e));
            }
        }
    }

    public String getPreference(String name) {
        return this.getPreference(name, null);
    }

    public String getPreference(String name, String defaultValue) {
        String v = (String)this.props.get(name);
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    public void setPreference(String name, String newValue) {
        this.isUpToDate = false;
        this.props.put(name, newValue);
        Enumeration e = this.observers.keys();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            Observer[] obs = (Observer[])this.observers.get(prefix);
            for (int i = 0; i < obs.length; ++i) {
                obs[i].updated(name, newValue);
            }
        }
    }

    public void addObserver(String prefix, Observer o) {
        Object[] obs = (Observer[])this.observers.get(prefix);
        obs = obs == null ? new Observer[]{o} : (Observer[])DynamicArray.append(obs, o);
        this.observers.put(prefix, obs);
    }

    public void addObserver(String[] prefixes, Observer o) {
        for (int i = 0; i < prefixes.length; ++i) {
            this.addObserver(prefixes[i], o);
        }
    }

    public void removeObserver(String prefix, Observer o) {
        Object[] obs = (Observer[])this.observers.get(prefix);
        if (obs != null) {
            obs = (Observer[])DynamicArray.remove(obs, o);
            this.observers.put(prefix, obs);
        }
    }

    public void removeObserver(String[] prefixes, Observer o) {
        for (int i = 0; i < prefixes.length; ++i) {
            this.removeObserver(prefixes[i], o);
        }
    }

    Properties getProperties() {
        return this.props;
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(Preferences.class);
    }

    public static interface Observer {
        public void updated(String var1, String var2);
    }
}

