/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.services.Message;
import com.sun.javatest.services.ProcessParams;
import com.sun.javatest.services.ServiceExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExecutor
implements ServiceExecutor {
    private Process proc;

    protected List<String> getCommand(Message start) {
        ProcessParams params = (ProcessParams)start.getContent();
        return params.getCommand();
    }

    protected Map<String, String> getEnv(Message start) {
        ProcessParams params = (ProcessParams)start.getContent();
        return params.getEnvironment();
    }

    protected File getWorkDir(Message start) {
        ProcessParams params = (ProcessParams)start.getContent();
        return params.getWorkDirectory();
    }

    protected void checkMessage(Message msg, Message.MessageType desired) throws BadMessageException {
        if (msg.getType() != desired) {
            throw new BadMessageException();
        }
        if (desired == Message.MessageType.START && !(msg.getContent() instanceof ProcessParams)) {
            throw new BadMessageException();
        }
    }

    @Override
    public Message startService(Message startMsg) {
        File wd;
        try {
            this.checkMessage(startMsg, Message.MessageType.START);
        }
        catch (BadMessageException ex) {
            return new Message(Message.MessageType.ERROR, ex);
        }
        List<String> command = this.getCommand(startMsg);
        ProcessBuilder pb = new ProcessBuilder(command);
        Map<String, String> env = this.getEnv(startMsg);
        if (env != null && env.size() > 0) {
            Map<String, String> currEnv = pb.environment();
            currEnv.clear();
            currEnv.putAll(env);
        }
        if ((wd = this.getWorkDir(startMsg)) != null && wd.exists()) {
            pb.directory(wd);
        }
        try {
            this.proc = pb.start();
        }
        catch (IOException ex) {
            return new Message(Message.MessageType.ERROR, ex);
        }
        return new Message(Message.MessageType.STARTED, null);
    }

    @Override
    public Message stopService(Message stopMsg) {
        try {
            this.checkMessage(stopMsg, Message.MessageType.STOP);
        }
        catch (BadMessageException ex) {
            return new Message(Message.MessageType.ERROR, ex);
        }
        if (this.proc == null) {
            return new Message(Message.MessageType.ERROR, (Serializable)((Object)"Process was not started"));
        }
        this.proc.destroy();
        try {
            this.proc.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Message rsps = new Message(Message.MessageType.STOPPED, (Serializable)((Object)("Process stopped successfully.\nExit value: " + this.proc.exitValue())));
        return rsps;
    }

    @Override
    public Message isAlive(Message isAlive) {
        try {
            this.checkMessage(isAlive, Message.MessageType.IS_ALIVE);
        }
        catch (BadMessageException ex) {
            return new Message(Message.MessageType.ERROR, ex);
        }
        if (this.proc != null) {
            try {
                int exitValue = this.proc.exitValue();
                return new Message(Message.MessageType.NOT_ALIVE, (Serializable)((Object)("Process already terminated.\nExit value: " + exitValue)));
            }
            catch (IllegalThreadStateException e) {
                return new Message(Message.MessageType.ALIVE, (Serializable)((Object)"Process not terminated yet"));
            }
        }
        return new Message(Message.MessageType.NOT_ALIVE, (Serializable)((Object)"Process already stopped"));
    }

    @Override
    public InputStream getServiceErrorStream() {
        if (this.proc != null) {
            return this.proc.getErrorStream();
        }
        return null;
    }

    @Override
    public InputStream getServiceOutputStream() {
        if (this.proc != null) {
            return this.proc.getInputStream();
        }
        return null;
    }

    public static class BadMessageException
    extends Exception {
    }
}

