/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.report.HTMLWriterEx;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

class BrowserPane
extends JPanel {
    private File baseDir;
    private URL homeURL;
    private File[] files;
    private String textHomePage;
    private JButton homeBtn;
    private JButton backBtn;
    private JButton forwardBtn;
    private JComboBox selectBox;
    private JPanel head;
    private JPanel body;
    private JTextField noteField;
    private HTMLEditorKit htmlKit;
    private JEditorPane textArea;
    private URL currURL;
    private History history;
    private DefaultComboBoxModel model;
    private Listener listener = new Listener();
    private JToolBar toolBar;
    private UIFactory uif;
    private Action homeAction;
    private Action backAction;
    private Action forwardAction;
    private static final int MAX_ROWS_DISPLAY = 20;
    protected static boolean debug = Boolean.getBoolean("debug." + BrowserPane.class.getName());

    BrowserPane(UIFactory uif) {
        this.uif = uif;
        this.history = new History();
        this.initGUI();
    }

    void setBaseDirectory(File base) {
        this.baseDir = base;
    }

    File getBaseDirectory() {
        return this.baseDir;
    }

    void setFile(URL file) {
        if (file != null) {
            this.setFiles(new URL[]{file});
        }
    }

    boolean isEmpty() {
        return this.currURL == null;
    }

    void setPlainText(String text) {
        this.textArea.setContentType("text/html");
        this.textArea.setText(text);
        this.textHomePage = text;
    }

    void setPlainTextHomePage(String text) {
        this.textHomePage = text;
    }

    void setFiles(URL[] files) {
        this.clear();
        for (int i = 0; i < files.length; ++i) {
            if (i == 0) {
                this.homeAction.setEnabled(true);
                this.loadPage(files[i]);
            }
            this.updateCombo(files[i]);
        }
        if (this.model.getSize() > 0) {
            this.selectBox.setSelectedIndex(0);
        }
    }

    URL getPage() {
        return this.textArea.getPage();
    }

    private void initGUI() {
        this.setName("fp");
        this.setFocusable(false);
        this.htmlKit = new HTMLEditorKit();
        this.initActions();
        this.setLayout(new BorderLayout());
        this.initHead();
        this.initBody();
        this.add((Component)this.head, "North");
        this.add((Component)this.body, "Center");
        this.noteField = this.uif.createOutputField("fp.note");
        this.add((Component)this.noteField, "South");
    }

    private void initActions() {
        this.homeAction = new ToolAction(this.uif, "fp.home", true){

            public void actionPerformed(ActionEvent e) {
                if (BrowserPane.this.homeURL == null) {
                    if (BrowserPane.this.textHomePage != null) {
                        BrowserPane.this.currURL = null;
                        BrowserPane.this.updateCombo(null);
                        BrowserPane.this.textArea.setContentType("text/html");
                        BrowserPane.this.textArea.setText(BrowserPane.this.textHomePage);
                    } else {
                        BrowserPane.this.textArea.setDocument(new HTMLDocument());
                    }
                } else {
                    BrowserPane.this.loadPage(BrowserPane.this.homeURL);
                }
            }
        };
        this.backAction = new ToolAction(this.uif, "fp.back", true){

            public void actionPerformed(ActionEvent e) {
                URL url = BrowserPane.this.history.prev();
                if (url != null) {
                    BrowserPane.this.loadPage(url);
                }
            }
        };
        this.forwardAction = new ToolAction(this.uif, "fp.forward", true){

            public void actionPerformed(ActionEvent e) {
                URL url = BrowserPane.this.history.next();
                if (url != null) {
                    BrowserPane.this.loadPage(url);
                }
            }
        };
    }

    private void initHead() {
        this.head = this.uif.createPanel("fp.head", false);
        this.head.setLayout(new GridBagLayout());
        this.head.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 5);
        JLabel fileLbl = this.uif.createLabel("fp.file", true);
        this.head.add((Component)fileLbl, c);
        this.selectBox = this.uif.createChoice("fp.choice", fileLbl);
        this.selectBox.setRenderer(new Renderer());
        this.selectBox.setModel(this.createModel());
        this.selectBox.addItemListener(this.listener);
        this.selectBox.setMaximumRowCount(20);
        this.selectBox.setUI(new BasicComboBoxUI(){

            protected ComboPopup createPopup() {
                BasicComboPopup popup = new BasicComboPopup(BrowserPane.this.selectBox){

                    protected JScrollPane createScroller() {
                        return new JScrollPane(this.list, 20, 30);
                    }
                };
                return popup;
            }
        });
        this.uif.setAccessibleName(this.selectBox, "fp.choice");
        c.gridx = 1;
        c.weightx = 2.0;
        c.fill = 2;
        this.head.add((Component)this.selectBox, c);
        Action[] actions = new Action[]{this.backAction, this.forwardAction, null, this.homeAction};
        this.toolBar = this.uif.createToolBar("fp.toolbar", actions);
        this.toolBar.setFloatable(false);
        c.weightx = 0.0;
        c.gridx = 2;
        c.insets.left = 5;
        this.head.add((Component)this.toolBar, c);
        this.backAction.setEnabled(this.history.hasPrev());
        this.forwardAction.setEnabled(this.history.hasNext());
    }

    private void initBody() {
        this.body = this.uif.createPanel("fp.body", false);
        this.body.setLayout(new BorderLayout());
        this.textArea = new JEditorPane();
        this.textArea.setName("text");
        this.textArea.setEditable(false);
        this.textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.textArea.addHyperlinkListener(this.listener);
        this.uif.setAccessibleInfo(this.textArea, "fp");
        this.body.add((Component)this.uif.createScrollPane(this.textArea, 20, 30), "Center");
    }

    private void clear() {
        if (this.model != null) {
            this.model.removeAllElements();
        }
        this.history.clear();
        this.backAction.setEnabled(false);
        this.forwardAction.setEnabled(false);
        this.homeAction.setEnabled(false);
        this.homeURL = null;
        this.currURL = null;
        this.textArea.setDocument(new HTMLDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadPage(URL url) {
        block15: {
            block17: {
                File file;
                String protocol;
                block16: {
                    if (this.currURL != null && url.toString().equals(this.currURL.toString())) {
                        return;
                    }
                    this.currURL = url;
                    protocol = url.getProtocol();
                    file = new File(url.getFile());
                    if (!protocol.equals("file") || !file.isDirectory()) break block16;
                    String list = this.listLocalDirectory(file);
                    HTMLDocument htmlDoc = (HTMLDocument)this.htmlKit.createDefaultDocument();
                    this.textArea.setDocument(htmlDoc);
                    htmlDoc.setBase(url);
                    this.textArea.setContentType("text/html");
                    this.textArea.setText(list);
                    break block15;
                }
                if (!protocol.equals("file") || url.getFile().endsWith(".htm") || url.getFile().endsWith(".html")) break block17;
                this.textArea.setContentType("text/plain");
                FileReader r = null;
                r = new FileReader(file);
                BufferedReader br = new BufferedReader(r);
                this.textArea.read(br, (Object)url);
                br.close();
                Object var7_12 = null;
                try {
                    if (r != null) {
                        r.close();
                    }
                    break block15;
                }
                catch (IOException e2) {}
                break block15;
                {
                    catch (IOException e) {
                        this.uif.showError("fp.load.error", new Object[]{url, e});
                        Object var7_13 = null;
                        try {
                            if (r != null) {
                                r.close();
                            }
                            break block15;
                        }
                        catch (IOException e2) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_14 = null;
                    try {
                        if (r != null) {
                            r.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                URL loaded = this.textArea.getPage();
                if (loaded == null || !loaded.sameFile(url)) {
                    HTMLDocument htmlDoc = (HTMLDocument)this.htmlKit.createDefaultDocument();
                    this.textArea.setDocument(htmlDoc);
                }
                this.textArea.setPage(url);
            }
            catch (IOException e) {
                this.uif.showError("fp.load.error", new Object[]{url, e});
            }
        }
        this.history.add(url);
        this.backAction.setEnabled(this.history.hasPrev());
        this.forwardAction.setEnabled(this.history.hasNext());
        this.updateCombo(url);
    }

    private String listLocalDirectory(File dir) {
        String p;
        if (!dir.isAbsolute()) {
            dir = dir.getAbsoluteFile();
        }
        String displayPath = dir.getPath();
        if (this.baseDir != null && (p = this.baseDir.getParent()) != null && displayPath.startsWith(p) && displayPath.length() > p.length() && (displayPath = displayPath.substring(p.length())).startsWith(File.separator)) {
            displayPath = displayPath.substring(1);
        }
        String[] filelist = dir.list();
        StringWriter sw = new StringWriter();
        try {
            HTMLWriterEx out = new HTMLWriterEx((Writer)sw, this.uif.getI18NResourceBundle());
            out.startTag("html");
            out.startTag("head");
            out.writeContentMeta();
            out.startTag("title");
            out.write(displayPath);
            out.endTag("title");
            out.endTag("head");
            out.startTag("body");
            out.writeStyleAttr("font-family: SansSerif; font-size: 12pt");
            out.startTag("h3");
            out.writeI18N("fp.head", displayPath);
            out.endTag("h3");
            out.startTag("ul");
            out.writeStyleAttr("margin-left:0");
            File parent = dir.getParentFile();
            if (parent != null) {
                out.startTag("li");
                out.startTag("object");
                out.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                out.writeParam("type", "up");
                out.endTag("object");
                out.writeEntity("&nbsp;");
                try {
                    out.startTag("a");
                    out.writeAttr("href", parent.toURL().toString());
                    out.writeI18N("fp.parent");
                    out.endTag("a");
                }
                catch (MalformedURLException e) {
                    out.writeI18N("fp.parent");
                }
            }
            for (int i = 0; i < filelist.length; ++i) {
                File file = new File(dir, filelist[i]);
                out.startTag("li");
                out.startTag("object");
                out.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                out.writeParam("type", file.isDirectory() ? "folder" : "file");
                out.endTag("object");
                out.writeEntity("&nbsp;");
                try {
                    out.writeLink(file.toURL(), file.getName());
                    continue;
                }
                catch (MalformedURLException e) {
                    out.write(file.getName());
                }
            }
            out.endTag("ul");
            out.endTag("body");
            out.endTag("html");
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sw.toString();
    }

    private void updateCombo(URL s) {
        if (this.model.getIndexOf(s) < 0) {
            this.model.addElement(s);
        }
        URL item = (URL)this.selectBox.getSelectedItem();
        if (s != null && !item.toString().equals(s.toString())) {
            this.selectBox.setSelectedItem(s);
        }
    }

    private DefaultComboBoxModel createModel() {
        if (this.model == null) {
            this.model = new DefaultComboBoxModel();
        }
        return this.model;
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object o, int index, boolean isSelected, boolean cellHasFocus) {
            String name = null;
            if (o instanceof URL) {
                URL url = (URL)o;
                if (!url.getProtocol().equals("file")) {
                    name = url.toString();
                } else {
                    name = this.extractPrefix(url.toString(), "file:");
                    String baseName = null;
                    name = new File(name).getAbsolutePath();
                    if (BrowserPane.this.baseDir != null && BrowserPane.this.baseDir.getParentFile() != null) {
                        baseName = BrowserPane.this.baseDir.getParentFile().getAbsolutePath();
                    }
                    if (baseName != null && name.startsWith(baseName) && name.length() > baseName.length() && (name = name.substring(baseName.length())).startsWith(File.separator)) {
                        name = name.substring(1);
                    }
                }
            } else if (o != null) {
                name = String.valueOf(o);
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, o, index, isSelected, cellHasFocus);
        }

        private String extractPrefix(String origStr, String target) {
            return !origStr.startsWith(target) ? origStr : origStr.substring(target.length());
        }
    }

    private class Listener
    implements HyperlinkListener,
    ItemListener {
        private Listener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            HyperlinkEvent.EventType et = e.getEventType();
            if (et == HyperlinkEvent.EventType.ACTIVATED) {
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLDocument doc = (HTMLDocument)((JEditorPane)e.getSource()).getDocument();
                    doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                } else {
                    BrowserPane.this.loadPage(e.getURL());
                }
            } else if (et == HyperlinkEvent.EventType.ENTERED) {
                URL u = e.getURL();
                if (u != null) {
                    BrowserPane.this.textArea.setCursor(Cursor.getPredefinedCursor(12));
                    BrowserPane.this.noteField.setText(u.toString());
                }
            } else if (et == HyperlinkEvent.EventType.EXITED) {
                BrowserPane.this.textArea.setCursor(Cursor.getPredefinedCursor(0));
                BrowserPane.this.noteField.setText("");
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                URL url = (URL)e.getItem();
                BrowserPane.this.loadPage(url);
            }
        }
    }

    private class History {
        private Vector entries = new Vector();
        private int index;

        private History() {
        }

        boolean hasPrev() {
            return this.index > 0;
        }

        URL prev() {
            if (this.index == 0) {
                return null;
            }
            return (URL)this.entries.elementAt(--this.index);
        }

        boolean hasNext() {
            return this.index < this.entries.size() - 1;
        }

        URL next() {
            if (this.index == this.entries.size() - 1) {
                return null;
            }
            return (URL)this.entries.elementAt(++this.index);
        }

        void add(URL u) {
            if (u == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.entries.size() && this.entries.elementAt(this.index).equals(u)) {
                return;
            }
            if (this.index < this.entries.size() - 1) {
                this.entries.setSize(this.index + 1);
            }
            this.entries.addElement(u);
            this.index = this.entries.size() - 1;
        }

        void clear() {
            this.entries.setSize(0);
            this.index = -1;
        }
    }

    static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }
    }
}

