/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.util.PathClassLoader;
import com.sun.javatest.util.WriterStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaCompileCommand
extends Command {
    public static boolean defaultVerbose = Boolean.getBoolean("javatest.JavaCompileCommand.verbose");
    private boolean verbose = defaultVerbose;
    private PrintWriter log;
    private static final Status passed = Status.passed("Compilation successful");
    private static final Status failed = Status.failed("Compilation failed");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Status s;
        PrintWriter out = new PrintWriter(System.out);
        PrintWriter err = new PrintWriter(System.err);
        try {
            JavaCompileCommand c = new JavaCompileCommand();
            s = c.run(args, out, err);
            Object var6_5 = null;
            out.flush();
            err.flush();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            out.flush();
            err.flush();
            throw throwable;
        }
        s.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status run(String[] args, PrintWriter log, PrintWriter ref) {
        Object result;
        block37: {
            block36: {
                Object compiler;
                Object[] compileMethodArgs;
                Method compileMethod;
                block34: {
                    Object[] constrArgs;
                    Constructor constr;
                    block35: {
                        Class compilerClass;
                        String compilerName;
                        block33: {
                            PathClassLoader loader;
                            block32: {
                                block31: {
                                    int i;
                                    if (args.length == 0) {
                                        return Status.error("No args supplied");
                                    }
                                    String compilerClassName = null;
                                    compilerName = null;
                                    String classpath = null;
                                    String[] options = null;
                                    for (i = 0; i < args.length; ++i) {
                                        if (!args[i].equals("-")) continue;
                                        options = new String[i];
                                        System.arraycopy(args, 0, options, 0, options.length);
                                        args = JavaCompileCommand.shift(args, i + 1);
                                        break;
                                    }
                                    if (options != null) {
                                        for (i = 0; i < options.length; ++i) {
                                            if (options[i].equals("-compiler")) {
                                                String s;
                                                int colon;
                                                if (i + 1 == options.length) {
                                                    return Status.error("No compiler specified after -compiler option");
                                                }
                                                if ((colon = (s = options[++i]).indexOf(":")) == -1) {
                                                    compilerClassName = s;
                                                    compilerName = "java " + s;
                                                    continue;
                                                }
                                                compilerClassName = s.substring(colon + 1);
                                                compilerName = s.substring(0, colon);
                                                continue;
                                            }
                                            if (options[i].equals("-cp") || options[i].equals("-classpath")) {
                                                if (i + 1 == options.length) {
                                                    return Status.error("No path specified after -cp or -classpath option");
                                                }
                                                classpath = options[++i];
                                                continue;
                                            }
                                            if (options[i].equals("-verbose")) {
                                                this.verbose = true;
                                                continue;
                                            }
                                            return Status.error("Unrecognized option: " + options[i]);
                                        }
                                    }
                                    this.log = log;
                                    try {
                                        loader = classpath == null ? null : new PathClassLoader(classpath);
                                        if (compilerClassName == null) break block31;
                                        compilerClass = this.getClass(loader, compilerClassName);
                                        if (compilerClass == null) {
                                            Status colon = Status.error("Cannot find compiler: " + compilerClassName);
                                            Object var18_15 = null;
                                            log.flush();
                                            ref.flush();
                                            return colon;
                                        }
                                        break block32;
                                    }
                                    catch (Throwable throwable) {
                                        Object var18_24 = null;
                                        log.flush();
                                        ref.flush();
                                        throw throwable;
                                    }
                                }
                                compilerName = "javac";
                                compilerClass = this.getClass(loader, "com.sun.tools.javac.Main");
                                if (compilerClass == null) {
                                    compilerClass = this.getClass(loader, "sun.tools.javac.Main");
                                }
                                if (compilerClass != null) break block32;
                                Status colon = Status.error("Cannot find compiler");
                                Object var18_16 = null;
                                log.flush();
                                ref.flush();
                                return colon;
                            }
                            loader = null;
                            compileMethod = this.getMethod(compilerClass, "compile", new Class[]{String[].class, PrintWriter.class});
                            if (compileMethod != null) {
                                compileMethodArgs = new Object[]{args, ref};
                                break block33;
                            }
                            compileMethod = this.getMethod(compilerClass, "compile", new Class[]{String[].class});
                            if (compileMethod != null) {
                                compileMethodArgs = new Object[]{args};
                                break block33;
                            }
                            Status status = Status.error("Cannot find compile method for " + compilerClass.getName());
                            Object var18_17 = null;
                            log.flush();
                            ref.flush();
                            return status;
                        }
                        if (Modifier.isStatic(compileMethod.getModifiers())) {
                            compiler = null;
                            break block34;
                        }
                        constr = this.getConstructor(compilerClass, new Class[]{OutputStream.class, String.class});
                        if (constr != null) {
                            constrArgs = new Object[]{new WriterStream(ref), compilerName};
                            break block35;
                        }
                        constr = this.getConstructor(compilerClass, new Class[0]);
                        if (constr != null) {
                            constrArgs = new Object[]{};
                            break block35;
                        }
                        Status status = Status.error("Cannot find suitable constructor for " + compilerClass.getName());
                        Object var18_18 = null;
                        log.flush();
                        ref.flush();
                        return status;
                    }
                    try {
                        compiler = constr.newInstance(constrArgs);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(log);
                        Status status = Status.error("Cannot instantiate compiler");
                        Object var18_19 = null;
                        log.flush();
                        ref.flush();
                        return status;
                    }
                }
                try {
                    result = compileMethod.invoke(compiler, compileMethodArgs);
                }
                catch (Throwable t) {
                    t.printStackTrace(log);
                    Status status = Status.error("Error invoking compiler");
                    Object var18_20 = null;
                    log.flush();
                    ref.flush();
                    return status;
                }
                if (!(result instanceof Boolean)) break block36;
                boolean ok = (Boolean)result;
                Status status = ok ? passed : failed;
                Object var18_21 = null;
                log.flush();
                ref.flush();
                return status;
            }
            if (!(result instanceof Integer)) break block37;
            int rc = (Integer)result;
            Status status = rc == 0 ? passed : failed;
            Object var18_22 = null;
            log.flush();
            ref.flush();
            return status;
        }
        Status status = Status.error("Unexpected return value from compiler: " + result);
        Object var18_23 = null;
        log.flush();
        ref.flush();
        return status;
    }

    private Class getClass(ClassLoader loader, String name) {
        try {
            return loader == null ? Class.forName(name) : loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Constructor getConstructor(Class c, Class[] argTypes) {
        try {
            return c.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace(this.log);
            }
            return null;
        }
    }

    private Method getMethod(Class c, String name, Class[] argTypes) {
        try {
            return c.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace(this.log);
            }
            return null;
        }
    }

    private static String[] shift(String[] args, int n) {
        String[] newArgs = new String[args.length - n];
        System.arraycopy(args, n, newArgs, 0, newArgs.length);
        return newArgs;
    }
}

