/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec.template;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.ParameterFilter;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;

public class TemplateParameterFilter
extends ParameterFilter {
    private boolean templateEnabled = false;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TemplateParameterFilter.class);

    public void update(InterviewParameters ip) {
        if (ip == null) {
            this.templateEnabled = false;
        } else if (ip.isTemplate()) {
            this.templateEnabled = true;
        } else {
            throw new IllegalStateException();
        }
        super.update(ip);
    }

    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        if (this.templateEnabled) {
            return super.accepts(td);
        }
        return false;
    }

    public boolean accepts(TestDescription td, TestFilter.Observer o) throws TestFilter.Fault {
        if (this.templateEnabled) {
            return super.accepts(td, o);
        }
        if (o != null) {
            o.rejected(td, this);
        }
        return false;
    }

    public String getName() {
        return i18n.getString("tFilter.name");
    }

    public String getDescription() {
        return i18n.getString("tFilter.desc");
    }

    public String getReason() {
        if (!this.templateEnabled) {
            return i18n.getString("tFilter.notAvailable");
        }
        return i18n.getString("tFilter.reason");
    }
}

