/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestFilter;
import com.sun.javatest.exec.ConfigurableTestFilter;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.RenderingUtilities;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.OrderedTwoWayTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;

class FilterSelectionHandler {
    private FilterConfig filterConfig;
    private UIFactory uif;
    private TestFilter activeFilter;
    private JComboBox selectBox;
    private JButton configButton;
    private JMenu editMenu;
    private ButtonGroup menuGroup;
    private Listener listener;
    private Observer[] obs = new Observer[0];
    private OrderedTwoWayTable filterMenuTable;
    private static boolean debug = Debug.getBoolean(FilterConfig.class);

    FilterSelectionHandler(FilterConfig fc, UIFactory uif) {
        this.filterConfig = fc;
        this.uif = uif;
        this.listener = new Listener();
        this.filterConfig.addObserver(this.listener);
    }

    public void addObserver(Observer o) {
        if (o == null) {
            return;
        }
        if (this.obs == null) {
            this.obs = new Observer[0];
        }
        this.obs = (Observer[])DynamicArray.append(this.obs, o);
    }

    public void removeObserver(Observer o) {
        this.obs = (Observer[])DynamicArray.remove((Object[])this.obs, o);
    }

    JComponent getFilterSelector() {
        JPanel panel = this.uif.createPanel("fconfig.sp", new GridBagLayout(), false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 18;
        this.selectBox = this.uif.createLiteralChoice("fconfig.box", this.filterConfig.getFilters());
        this.selectBox.addActionListener(this.listener);
        this.selectBox.setRenderer(RenderingUtilities.createFilterListRenderer());
        this.uif.setAccessibleName(this.selectBox, "fconfig.box");
        panel.add((Component)this.selectBox, gbc);
        gbc.gridx = 1;
        this.configButton = this.uif.createButton("fconfig.config");
        this.configButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        this.configButton.addActionListener(this.listener);
        this.configButton.setMaximumSize(this.configButton.getPreferredSize());
        this.uif.setAccessibleName(this.configButton, "fconfig.config");
        gbc.insets.left = 11;
        gbc.weightx = 0.0;
        panel.add((Component)this.configButton, gbc);
        panel.setMaximumSize(panel.getPreferredSize());
        if (this.activeFilter == null) {
            TestFilter[] filters = this.filterConfig.getFilters();
            if (filters != null && filters.length > 0) {
                this.setFilter(filters[0]);
            }
        } else {
            this.selectBox.setSelectedItem(this.activeFilter);
        }
        this.configButton.setEnabled(this.activeFilter instanceof ConfigurableTestFilter);
        return panel;
    }

    synchronized JMenu getFilterMenu() {
        this.menuGroup = new ButtonGroup();
        this.filterMenuTable = new OrderedTwoWayTable();
        ToolAction showEditorAction = new ToolAction(this.uif, "fconfig.submenu.edit"){

            public void actionPerformed(ActionEvent e) {
                FilterSelectionHandler.this.filterConfig.showEditorDialog(FilterSelectionHandler.this.getActiveFilter());
            }
        };
        this.editMenu = this.uif.createMenu("fconfig.submenu");
        TestFilter[] filters = this.filterConfig.getFilters();
        for (int i = 0; i < filters.length; ++i) {
            this.addToMenu(filters[i], -1);
        }
        if (this.activeFilter == null && filters != null && filters.length > 0) {
            this.setFilter(filters[0]);
        }
        this.editMenu.addSeparator();
        this.editMenu.add(this.uif.createMenuItem(showEditorAction));
        this.updateMenu();
        return this.editMenu;
    }

    synchronized void setFilter(String name) {
        this.setFilter(this.filterConfig.getFilter(name));
    }

    synchronized void setFilter(TestFilter f) {
        if (f == null) {
            return;
        }
        if (this.filterConfig.contains(f)) {
            this.activeFilter = f;
            if (this.selectBox != null) {
                this.selectBox.setSelectedItem(this.activeFilter);
            }
            if (this.configButton != null) {
                this.configButton.setEnabled(f instanceof ConfigurableTestFilter);
            }
            this.updateMenu();
            for (int i = 0; i < this.obs.length; ++i) {
                this.obs[i].filterSelected(f);
            }
        }
    }

    synchronized TestFilter getActiveFilter() {
        return this.activeFilter;
    }

    void updateFilterMetaInfo(TestFilter f) {
        int index;
        if (this.activeFilter == f && this.selectBox != null) {
            this.selectBox.repaint();
        }
        if (this.editMenu != null && (index = this.filterMenuTable.getKeyIndex(f)) >= 0) {
            JMenuItem jmi = (JMenuItem)this.filterMenuTable.getValueAt(index);
            int mne = jmi.getMnemonic();
            if (mne > 0) {
                jmi.setText((char)mne + " " + f.getName());
            } else {
                jmi.setText(f.getName());
            }
        }
    }

    private synchronized void addToMenu(TestFilter f, int location) {
        if (this.editMenu == null) {
            return;
        }
        boolean[] mnemonics = new boolean[10];
        Arrays.fill(mnemonics, false);
        for (int i = 0; i < this.editMenu.getItemCount(); ++i) {
            JMenuItem mi = this.editMenu.getItem(i);
            if (mi == null) continue;
            int itemMne = mi.getMnemonic() - 48 - 1;
            if (itemMne == -1) {
                itemMne = 9;
            }
            if (itemMne < 0 || itemMne > 9) continue;
            mnemonics[itemMne] = true;
        }
        int mne = -1;
        for (int i = 0; i < mnemonics.length; ++i) {
            if (mnemonics[i]) continue;
            mne = i;
            break;
        }
        if (mne == 9) {
            mne = 48;
        } else if (mne >= 0) {
            mne = mne + 1 + 48;
        }
        String text = (mne == 0 ? "" : Character.valueOf((char)mne)) + " " + f.getName();
        JRadioButtonMenuItem b = new JRadioButtonMenuItem(text);
        b.setName(f.getName());
        if (mne != 0) {
            b.setMnemonic(mne);
        }
        b.getAccessibleContext().setAccessibleDescription(f.getDescription());
        b.addActionListener(this.listener);
        this.menuGroup.add(b);
        this.filterMenuTable.put(f, b);
        if (location < 0) {
            this.editMenu.insert(b, this.menuGroup.getButtonCount() - 1);
        } else {
            this.editMenu.insert(b, location);
        }
        if (f == this.activeFilter) {
            b.setEnabled(true);
        }
    }

    private synchronized void removeFromMenu(TestFilter f) {
        if (this.editMenu == null) {
            return;
        }
        int where = this.filterMenuTable.getKeyIndex(f);
        if (where != -1) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.filterMenuTable.getValueAt(where);
            this.editMenu.remove(mi);
            this.filterMenuTable.remove(where);
            this.menuGroup.remove(mi);
        }
    }

    private void updateMenu() {
        if (this.editMenu == null) {
            return;
        }
        int where = this.filterMenuTable.getKeyIndex(this.activeFilter);
        if (where != -1) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.filterMenuTable.getValueAt(where);
            mi.setSelected(true);
        }
    }

    class Listener
    implements ActionListener,
    FilterConfig.Observer {
        Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            int which;
            Object source = e.getSource();
            if (source == FilterSelectionHandler.this.selectBox) {
                String action = e.getActionCommand();
                TestFilter vf = (TestFilter)FilterSelectionHandler.this.selectBox.getSelectedItem();
                if (vf == FilterSelectionHandler.this.getActiveFilter()) {
                    if (debug) {
                        Debug.println("FC - keeping filter");
                    }
                    return;
                }
                if (debug) {
                    Debug.println("FC - changing filter");
                }
                FilterSelectionHandler.this.setFilter(vf);
            } else if (source == FilterSelectionHandler.this.configButton) {
                TestFilter vf = (TestFilter)FilterSelectionHandler.this.selectBox.getSelectedItem();
                FilterSelectionHandler.this.filterConfig.showEditorDialog(vf);
            } else if (source instanceof JRadioButtonMenuItem && (which = FilterSelectionHandler.this.filterMenuTable.getValueIndex(source)) != -1) {
                TestFilter f = (TestFilter)FilterSelectionHandler.this.filterMenuTable.getKeyAt(which);
                FilterSelectionHandler.this.setFilter(f);
            }
        }

        public void filterUpdated(TestFilter f) {
            if (FilterSelectionHandler.this.obs == null) {
                return;
            }
            if (FilterSelectionHandler.this.activeFilter == f) {
                for (int i = 0; i < FilterSelectionHandler.this.obs.length; ++i) {
                    FilterSelectionHandler.this.obs[i].filterUpdated(f);
                }
            }
        }

        public void filterAdded(TestFilter f) {
            if (FilterSelectionHandler.this.selectBox != null) {
                FilterSelectionHandler.this.selectBox.addItem(f);
            }
            FilterSelectionHandler.this.addToMenu(f, -1);
            for (int i = 0; i < FilterSelectionHandler.this.obs.length; ++i) {
                FilterSelectionHandler.this.obs[i].filterAdded(f);
            }
        }

        public void filterRemoved(TestFilter f) {
            if (FilterSelectionHandler.this.selectBox != null) {
                FilterSelectionHandler.this.selectBox.removeItem(f);
            }
            FilterSelectionHandler.this.removeFromMenu(f);
            for (int i = 0; i < FilterSelectionHandler.this.obs.length; ++i) {
                FilterSelectionHandler.this.obs[i].filterRemoved(f);
            }
        }
    }

    public static interface Observer {
        public void filterUpdated(TestFilter var1);

        public void filterSelected(TestFilter var1);

        public void filterAdded(TestFilter var1);

        public void filterRemoved(TestFilter var1);
    }
}

