/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.TestTreeSelectionPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.help.CSH;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CE_TestsPane
extends CE_StdPane {
    private Parameters.TestsParameters testsParameters;
    private Parameters.MutableTestsParameters mutableTestsParameters;
    private ButtonGroup btnGrp;
    private JRadioButton allTestsBtn;
    private JRadioButton selectTestsBtn;
    private TestTreeSelectionPane testsField;
    private JButton loadBtn;
    private FileChooser chooser;

    CE_TestsPane(UIFactory uif, InterviewParameters config) {
        super(uif, config, "tests");
        this.updateConfig();
        this.initGUI();
    }

    boolean isOKToClose() {
        if (this.mutableTestsParameters == null) {
            return true;
        }
        if (this.selectTestsBtn.isSelected() && this.testsField.isSelectionEmpty()) {
            this.uif.showError("ce.tests.noTests");
            return false;
        }
        return true;
    }

    void updateConfig() {
        this.testsParameters = this.config.getTestsParameters();
        this.mutableTestsParameters = this.testsParameters instanceof Parameters.MutableTestsParameters ? (Parameters.MutableTestsParameters)this.testsParameters : null;
    }

    void load() {
        this.updateConfig();
        if (this.mutableTestsParameters != null) {
            int tm = this.mutableTestsParameters.getTestsMode();
            if (tm == 1) {
                this.allTestsBtn.setSelected(true);
            } else {
                this.selectTestsBtn.setSelected(true);
            }
            this.testsField.setSelection(this.mutableTestsParameters.getSpecifiedTests());
            this.testsField.setEnabled(this.selectTestsBtn.isSelected());
        } else {
            this.mutableTestsParameters = null;
            String[] tests = this.testsParameters.getTests();
            if (tests == null || tests.length == 0) {
                this.allTestsBtn.setSelected(true);
                this.testsField.clear();
            } else {
                this.selectTestsBtn.setSelected(true);
                this.testsField.setSelection(tests);
            }
            this.allTestsBtn.setEnabled(false);
            this.selectTestsBtn.setEnabled(false);
            this.testsField.setEnabled(false);
        }
    }

    void save() {
        if (this.mutableTestsParameters != null) {
            if (this.allTestsBtn.isSelected()) {
                this.mutableTestsParameters.setTestsMode(1);
            } else if (this.selectTestsBtn.isSelected()) {
                this.mutableTestsParameters.setTestsMode(2);
            }
            this.mutableTestsParameters.setSpecifiedTests(this.testsField.getSelection());
        }
    }

    private void initGUI() {
        CSH.setHelpIDString(this, "confEdit.testsTab.csh");
        JPanel p = this.uif.createPanel("ce.tests", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.btnGrp = new ButtonGroup();
        this.allTestsBtn = this.uif.createRadioButton("ce.tests.all", this.btnGrp);
        p.add((Component)this.allTestsBtn, c);
        this.selectTestsBtn = this.uif.createRadioButton("ce.tests.select", this.btnGrp);
        this.selectTestsBtn.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean s = CE_TestsPane.this.selectTestsBtn.isSelected();
                CE_TestsPane.this.testsField.setEnabled(s);
                CE_TestsPane.this.loadBtn.setEnabled(s);
            }
        });
        c.gridheight = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)this.selectTestsBtn, c);
        this.testsField = new TestTreeSelectionPane(this.config.getWorkDirectory().getTestResultTable());
        this.testsField.setEnabled(this.selectTestsBtn.isSelected());
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        p.add((Component)this.testsField, c);
        this.loadBtn = this.uif.createButton("ce.tests.load", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CE_TestsPane.this.selectFromFile();
            }
        });
        this.loadBtn.setEnabled(this.selectTestsBtn.isSelected());
        c.anchor = 13;
        c.fill = 0;
        c.insets.top = 5;
        c.weighty = 0.0;
        p.add((Component)this.loadBtn, c);
        this.addBody(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void selectFromFile() {
        ArrayList<String> badPaths;
        ArrayList<String> paths;
        block37: {
            IOException e2222;
            BufferedReader in;
            FileReader fr;
            File file;
            block32: {
                String line;
                int rc;
                if (this.chooser == null) {
                    this.chooser = new FileChooser();
                }
                if ((rc = this.chooser.showDialog(this, this.chooser.getApproveButtonText())) != 0) {
                    return;
                }
                WorkDirectory wd = this.config.getWorkDirectory();
                TestResultTable trt = wd.getTestResultTable();
                file = this.chooser.getSelectedFile();
                paths = new ArrayList<String>();
                badPaths = new ArrayList<String>();
                HashSet<String> seen = new HashSet<String>();
                fr = null;
                in = null;
                fr = new FileReader(file);
                in = new BufferedReader(fr);
                while ((line = in.readLine()) != null) {
                    int sp;
                    String path;
                    if ((line = line.trim()).length() == 0 || line.startsWith("#") || seen.contains(path = (sp = line.indexOf(32)) == -1 ? line : line.substring(0, sp))) continue;
                    if (trt.validatePath(path)) {
                        paths.add(path);
                    } else {
                        badPaths.add(path);
                    }
                    seen.add(path);
                }
                in.close();
                Object var14_18 = null;
                if (in == null) break block32;
                try {
                    in.close();
                }
                catch (IOException e2222) {
                    // empty catch block
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e2222) {}
            }
            break block37;
            {
                catch (FileNotFoundException e3) {
                    IOException e2222;
                    this.uif.showError("ce.tests.cantFindFile", file.toString());
                    Object var14_19 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (IOException e4) {
                    IOException e2222;
                    this.uif.showError("ce.tests.cantReadFile", new Object[]{file, e4.toString()});
                    Object var14_20 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                IOException e2222;
                Object var14_21 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        int MAX_BAD_PATHS = 10;
        if (badPaths.size() > 0) {
            if (badPaths.size() == 1) {
                this.uif.showError("ce.tests.badPath", badPaths.get(0));
            } else {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < Math.min(badPaths.size(), 10); ++i) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append((String)badPaths.get(i));
                }
                boolean more = badPaths.size() > 10;
                this.uif.showError("ce.tests.badPaths", new Object[]{sb.toString(), new Integer(more ? 1 : 0)});
            }
        }
        this.testsField.setSelection(paths.toArray(new String[paths.size()]));
    }
}

