/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.agent.ActiveModeOptions;
import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.AgentPanel;
import com.sun.javatest.agent.Map;
import com.sun.javatest.agent.ModeOptions;
import com.sun.javatest.agent.PassiveModeOptions;
import com.sun.javatest.agent.SerialPortModeOptions;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.MainFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;

public class AgentFrame
extends Frame {
    private Listener listener = new Listener();
    private AgentPanel panel;
    private boolean tracing;
    private static final String EXIT = "Exit";
    static /* synthetic */ Class class$com$sun$javatest$agent$Agent$Observer;
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$java$awt$EventQueue;
    static /* synthetic */ Class class$com$sun$javatest$agent$AgentFrame;

    public static void main(String[] args) {
        Integer delay;
        ModeOptions mode = null;
        String activeHost = null;
        int activePort = -1;
        int passivePort = -1;
        String serialPort = null;
        int concurrency = -1;
        String mapFile = null;
        int history = -1;
        boolean start = false;
        boolean useSharedFrame = true;
        String observerClassName = null;
        boolean tracing = false;
        ActiveModeOptions amo = new ActiveModeOptions();
        PassiveModeOptions pmo = new PassiveModeOptions();
        SerialPortModeOptions smo = new SerialPortModeOptions();
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].equalsIgnoreCase("-active")) {
                    mode = amo;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-passive")) {
                    mode = pmo;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-activeHost")) {
                    mode = amo;
                    activeHost = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-activePort")) {
                    mode = amo;
                    activePort = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-passivePort")) {
                    mode = pmo;
                    passivePort = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-serialPort")) {
                    mode = smo;
                    serialPort = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-concurrency")) {
                    concurrency = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-map")) {
                    mapFile = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-history")) {
                    history = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-start")) {
                    start = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-trace")) {
                    tracing = true;
                    continue;
                }
                if ("-observer".equalsIgnoreCase(args[i]) && i < args.length - 1) {
                    if (observerClassName != null) {
                        System.err.println("duplicate use of -observer");
                        AgentFrame.usage(System.err, 1);
                    }
                    observerClassName = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-useSharedFrame")) {
                    System.err.println("Note: -useSharedFrame is now the default");
                    System.err.println("Use -noSharedFrame to disable this feature.");
                    useSharedFrame = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-noSharedFrame")) {
                    useSharedFrame = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                    AgentFrame.usage(System.err, 0);
                    continue;
                }
                System.err.println("Unrecognised option: " + args[i]);
                AgentFrame.usage(System.err, 1);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("Missing argument for " + args[args.length - 1]);
                AgentFrame.usage(System.err, 1);
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println("Number expected: " + args[i]);
                AgentFrame.usage(System.err, 1);
            }
        }
        if (activeHost != null) {
            amo.setHost(activeHost);
        }
        if (activePort != -1) {
            amo.setPort(activePort);
        }
        if (passivePort != -1) {
            pmo.setPort(passivePort);
        }
        if (serialPort != null) {
            if (smo == null) {
                System.err.println("Could not initialize serial ports");
                System.exit(1);
            } else {
                smo.setPort(serialPort);
            }
        }
        ModeOptions[] modeOptions = new ModeOptions[]{amo, pmo, smo};
        final AgentFrame sf = new AgentFrame(modeOptions);
        if (observerClassName != null) {
            try {
                Class<?> observerClass = Class.forName(observerClassName);
                Agent.Observer observer = (Agent.Observer)observerClass.newInstance();
                sf.panel.addObserver(observer);
            }
            catch (ClassCastException e) {
                System.err.println("observer is not of type " + (class$com$sun$javatest$agent$Agent$Observer == null ? (class$com$sun$javatest$agent$Agent$Observer = AgentFrame.class$("com.sun.javatest.agent.Agent$Observer")) : class$com$sun$javatest$agent$Agent$Observer).getName() + ": " + observerClassName);
                System.exit(1);
            }
            catch (ClassNotFoundException e) {
                System.err.println("cannot find observer class: " + observerClassName);
                System.exit(1);
            }
            catch (IllegalAccessException e) {
                System.err.println("problem instantiating observer: " + e);
                System.exit(1);
            }
            catch (InstantiationException e) {
                System.err.println("problem instantiating observer: " + e);
                System.exit(1);
            }
        }
        if (useSharedFrame) {
            MainFrame.setFrame(sf);
        }
        AgentPanel sp = sf.panel;
        sp.setTracing(tracing, System.out);
        if (mode != null) {
            sp.setMode(mode.getModeName());
        }
        if (concurrency != -1) {
            sp.setConcurrency(concurrency);
        }
        if (mapFile != null) {
            sp.setMapFile(mapFile);
        }
        if (history != -1) {
            sp.setHistoryLimit(history);
        }
        if ((delay = Integer.getInteger("agent.retry.delay")) != null) {
            sp.setRetryDelay(delay);
        }
        JavaTestSecurityManager.install();
        if (start) {
            sp.start();
        }
        try {
            Method invokeLater = (class$java$awt$EventQueue == null ? (class$java$awt$EventQueue = AgentFrame.class$("java.awt.EventQueue")) : class$java$awt$EventQueue).getMethod("invokeLater", class$java$lang$Runnable == null ? (class$java$lang$Runnable = AgentFrame.class$("java.lang.Runnable")) : class$java$lang$Runnable);
            invokeLater.invoke(null, new Runnable(){

                public void run() {
                    sf.showCentered();
                }
            });
        }
        catch (NoSuchMethodException e) {
            sf.showCentered();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void usage(PrintStream out, int exitCode) {
        String className = (class$com$sun$javatest$agent$AgentFrame == null ? (class$com$sun$javatest$agent$AgentFrame = AgentFrame.class$("com.sun.javatest.agent.AgentFrame")) : class$com$sun$javatest$agent$AgentFrame).getName();
        out.println("Usage:");
        out.println("    java " + className + " [options]");
        out.println("        -help             print this message");
        out.println("        -usage            print this message");
        out.println("        -active           set mode to be active");
        out.println("        -activeHost host  set the host for active connections (implies -active)");
        out.println("        -activePort port  set the port for active connections (implies -active)");
        out.println("        -passive          set mode to be passive");
        out.println("        -passivePort port set the port for passive connections (implies -passive)");
        out.println("        -serialPort port  set the port for serial port connections");
        out.println("        -concurrency num  set the maximum number of simultaneous connections");
        out.println("        -map file         map file for translating arguments of incoming requests");
        out.println("        -history num      set the maximum number of requests remembered in the history list");
        out.println("        -start            automatically start a agent");
        out.println("        -trace            trace the execution of the agent");
        out.println("        -observer class   add an observer to the agent");
        out.println("        -useSharedFrame   share the application frame with any tests that require it");
        System.exit(exitCode);
    }

    public AgentFrame(ModeOptions[] modeOptions) {
        super("JT Harness Agent");
        ExitCount.inc();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AgentFrame.this.setVisible(false);
                AgentFrame.this.dispose();
            }

            public void windowClosed(WindowEvent e) {
                ExitCount.dec();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.panel = new AgentPanel(modeOptions, new AgentPanel.MapReader(){

            public Map read(String name) throws IOException {
                if (name == null || name.length() == 0) {
                    return null;
                }
                return Map.readFileOrURL(name);
            }
        });
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.panel, c);
    }

    private void showCentered() {
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        this.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
        this.show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(AgentFrame.EXIT)) {
                AgentFrame.this.dispose();
            }
        }
    }
}

