/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.javatest.agent.AgentWriter;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.Deprecated;
import com.sun.javatest.agent.Map;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.Timer;
import com.sun.javatest.util.WriterStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Vector;

public class Agent
implements Runnable {
    private boolean closing;
    private Thread mainThread;
    private int maxThreads;
    private Vector threads = new Vector();
    private Vector tasks = new Vector();
    private Notifier notifier = new Notifier();
    private Object currSystemStreamOwner = null;
    private PrintStream saveOut;
    private PrintStream saveErr;
    protected boolean tracing = false;
    protected PrintStream traceOut = System.out;
    public static final int DEFAULT_RETRY_DELAY = 5;
    private int retryDelay = 5;
    private ConnectionFactory connectionFactory;
    private Map map;
    private Timer timer;
    private static int threadInitNumber;
    static final short protocolVersion = 104;
    public static final int defaultActivePort = 1907;
    public static final int defaultPassivePort = 1908;
    static final byte CLASS = 67;
    static final byte DATA = 68;
    static final byte LOG = 76;
    static final byte LOG_FLUSH = 108;
    static final byte REF = 82;
    static final byte REF_FLUSH = 114;
    static final byte STATUS = 83;
    static final String productName = "JT Harness Agent";
    static final String productVersion = "JTA_4.6";
    static final String productCopyright = "Copyright (c) 1996, 2014, Oracle and/or its affiliates. All rights reserved.";
    private static Constructor classLoaderConstructor;
    private static Method factoryMethod;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$com$sun$javatest$agent$AgentClassLoader;
    static /* synthetic */ Class class$com$sun$javatest$agent$Agent$Task;

    public Agent(ConnectionFactory connectionFactory, int concurrency) {
        if (!Agent.isValidConcurrency(concurrency)) {
            throw new IllegalArgumentException("bad concurrency: " + concurrency);
        }
        this.connectionFactory = connectionFactory;
        this.maxThreads = concurrency;
    }

    public void setRetryDelay(int delay) {
        if (delay <= 0) {
            throw new IllegalArgumentException("invalid delay");
        }
        this.retryDelay = delay;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public synchronized void setMap(Map map) {
        this.map = map;
        if (this.tracing) {
            if (map == null) {
                this.traceOut.println("set map null");
            } else {
                this.traceOut.println("set map:");
                map.setTracing(this.tracing, this.traceOut);
                Enumeration e = map.enumerate();
                while (e.hasMoreElements()) {
                    String[] entry = (String[])e.nextElement();
                    this.traceOut.println("map-from: " + entry[0]);
                    this.traceOut.println("map-to:   " + entry[1]);
                }
                this.traceOut.println("end of map");
            }
        }
    }

    public void setTracing(boolean state) {
        this.tracing = state;
    }

    public void addObserver(Observer o) {
        this.notifier.addObserver(o);
    }

    public void removeObserver(Observer o) {
        this.notifier.removeObserver(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        if (this.mainThread != null) {
            throw new IllegalStateException("Agent already running");
        }
        this.mainThread = Thread.currentThread();
        this.timer = new Timer();
        this.closing = false;
        try {
            if (this.tracing) {
                this.traceOut.println("AGENT STARTED, maxThreads=" + this.maxThreads);
            }
            this.notifier.started();
            if (this.maxThreads <= 0) {
                return;
            }
            while (!this.closing) {
                while (this.threads.size() < this.maxThreads && !this.closing) {
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Thread curr = Thread.currentThread();
                            if (Agent.this.tracing) {
                                Agent.this.traceOut.println("THREAD " + curr.getName() + " STARTED " + this.getClass().getName());
                            }
                            try {
                                Agent.this.handleRequestsUntilClosed();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            finally {
                                Agent agent = Agent.this;
                                synchronized (agent) {
                                    Agent.this.threads.removeElement(curr);
                                    Agent.this.notifyAll();
                                }
                                if (Agent.this.tracing) {
                                    Agent.this.traceOut.println("THREAD " + curr.getName() + " EXITING");
                                }
                            }
                        }
                    });
                    t.setName("Agent" + Agent.nextThreadNum());
                    int currPrio = Thread.currentThread().getPriority();
                    int slvPrio = (currPrio + 1) / 2;
                    t.setPriority(slvPrio);
                    t.start();
                    this.threads.addElement(t);
                }
                this.wait();
            }
        }
        catch (InterruptedException e) {
            try {
                this.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.timer.finished();
            this.notifier.finished();
            if (this.tracing) {
                this.traceOut.println("AGENT EXITING");
            }
            this.mainThread = null;
        }
    }

    public synchronized void interrupt() {
        if (this.mainThread != null) {
            this.mainThread.interrupt();
        }
    }

    public synchronized void close() throws InterruptedException {
        Object t;
        int i;
        this.closing = true;
        for (i = 0; i < this.threads.size(); ++i) {
            t = (Thread)this.threads.elementAt(i);
            if (this.tracing) {
                this.traceOut.println("INTERRUPTING THREAD " + ((Thread)t).getName());
            }
            ((Thread)t).interrupt();
        }
        this.traceOut.println("WAITING 3s FOR THREADS TO CLEANUP");
        Thread.currentThread();
        Thread.sleep(3000L);
        for (i = 0; i < this.tasks.size(); ++i) {
            t = (Task)this.tasks.elementAt(i);
            if (this.tracing) {
                Connection c = ((Task)t).connection;
                this.traceOut.println("CLOSING TASK " + (c == null ? "[unknown]" : c.getName()));
            }
            ((Task)t).close();
        }
        try {
            if (this.tracing) {
                this.traceOut.println("CLOSING CONNECTION FACTORY");
            }
            this.connectionFactory.close();
        }
        catch (ConnectionFactory.Fault fault) {
            // empty catch block
        }
        this.notifyAll();
        if (this.tracing) {
            this.traceOut.println("WAITING FOR TASKS TO EXIT");
        }
        while (this.tasks.size() > 0) {
            this.wait();
        }
        if (this.tracing) {
            this.traceOut.println("CLOSED");
        }
    }

    static boolean isValidConcurrency(int concurrency) {
        return 1 <= concurrency && concurrency <= 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestsUntilClosed() throws InterruptedException {
        while (!this.closing) {
            try {
                Task t;
                Connection connection = this.connectionFactory.nextConnection();
                Agent agent = this;
                synchronized (agent) {
                    if (this.closing) {
                        Agent.closeIgnoreExceptions(connection);
                        return;
                    }
                    t = new Task(connection);
                    this.tasks.addElement(t);
                }
                try {
                    t.handleRequest();
                }
                finally {
                    agent = this;
                    synchronized (agent) {
                        this.tasks.removeElement(t);
                    }
                }
            }
            catch (ConnectionFactory.Fault e) {
                this.notifier.errorOpeningConnection(e.getException());
                if (this.tracing) {
                    this.traceOut.println("THREAD " + Thread.currentThread().getName() + " " + e);
                }
                if (e.isFatal()) {
                    this.close();
                    return;
                }
                int millis = 1000 * Agent.min(5, this.getRetryDelay());
                Thread.currentThread();
                Thread.sleep(millis);
            }
        }
    }

    private static void closeIgnoreExceptions(Connection c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final int min(int a, int b) {
        return a < b ? a : b;
    }

    private synchronized void setSystemStreams(Object owner, PrintStream out, PrintStream err) throws InterruptedException, SecurityException {
        if (owner == null) {
            throw new NullPointerException();
        }
        while (this.currSystemStreamOwner != null) {
            this.wait();
        }
        this.currSystemStreamOwner = owner;
        this.saveOut = System.out;
        this.saveErr = System.err;
        System.setOut(out);
        System.setErr(err);
    }

    private synchronized void resetSystemStreams(Object owner) throws SecurityException {
        if (owner == null) {
            throw new NullPointerException();
        }
        if (owner != this.currSystemStreamOwner) {
            throw new IllegalStateException("expected: " + owner + " found: " + this.currSystemStreamOwner);
        }
        this.currSystemStreamOwner = null;
        System.setOut(this.saveOut);
        System.setErr(this.saveErr);
        this.notifyAll();
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        factoryMethod = null;
    }

    class Task {
        private Connection connection;
        private DataInputStream in;
        private DataOutputStream out;
        private String tag;
        private String request;

        Task(Connection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.connection = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest() throws ConnectionFactory.Fault {
            try {
                Status status;
                Agent.this.notifier.openedConnection(this.connection);
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("REQUEST FROM " + this.connection.getName());
                }
                this.in = new DataInputStream(this.connection.getInputStream());
                short pVer = this.in.readShort();
                if (pVer != 104) {
                    throw new IOException("protocol mismatch; expected 104 received " + pVer);
                }
                this.tag = this.in.readUTF();
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("TAG IS `" + this.tag + "'");
                }
                this.request = this.in.readUTF();
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("REQUEST IS `" + this.request + "'");
                }
                this.out = new DataOutputStream(new BufferedOutputStream(this.connection.getOutputStream()));
                if (this.request.equals("executeTest") || this.request.equals("executeCommand") || this.request.equals("executeMain")) {
                    status = this.execute();
                } else {
                    if (Agent.this.tracing) {
                        Agent.this.traceOut.println("Unrecognized request for agent: `" + this.request + "'");
                    }
                    status = Status.error("Unrecognized request for agent: `" + this.request + "'");
                }
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("RETURN " + status);
                }
                Agent.this.notifier.result(this.connection, status);
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("SEND STATUS");
                }
                this.sendStatus(status);
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("FLUSH");
                }
                this.out.flush();
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("AWAIT CLOSE");
                }
                this.connection.waitUntilClosed(5000);
                if (Thread.interrupted() && Agent.this.tracing) {
                    Agent.this.traceOut.println("Thread was interrupted - clearing interrupted status!");
                }
                if (this.connection.isClosed()) {
                    Agent.this.notifier.completed(this.connection);
                } else {
                    Agent.this.notifier.exception(this.connection, new IOException("timeout awaiting close from AgentManager"));
                }
            }
            catch (InterruptedException e) {
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("Interrupted");
                }
                Agent.this.notifier.exception(this.connection, e);
            }
            catch (InterruptedIOException e) {
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("Interrupted (IO)");
                }
                Agent.this.notifier.exception(this.connection, e);
            }
            catch (IOException e) {
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("EXCEPTION IS `" + e + "'");
                    e.printStackTrace(Agent.this.traceOut);
                }
                Agent.this.notifier.exception(this.connection, e);
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Status execute() throws IOException {
            Status status;
            byte guard;
            String className = this.in.readUTF();
            if (Agent.this.tracing) {
                Agent.this.traceOut.println("CLASSNAME: " + className);
            }
            short n = this.in.readShort();
            if (Agent.this.tracing) {
                Agent.this.traceOut.println("nArgs: " + n);
            }
            String[] args = new String[n];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.in.readUTF();
                if (!Agent.this.tracing) continue;
                Agent.this.traceOut.println("arg[" + i + "]: " + args[i]);
            }
            boolean mapArgs = this.in.readBoolean();
            if (Agent.this.tracing) {
                Agent.this.traceOut.println("mapArgs: " + mapArgs);
            }
            boolean remoteClasses = this.in.readBoolean();
            if (Agent.this.tracing) {
                Agent.this.traceOut.println("remoteClasses: " + remoteClasses);
            }
            boolean sharedClassLoader = this.in.readBoolean();
            if (Agent.this.tracing) {
                Agent.this.traceOut.println("sharedClassLoader: " + sharedClassLoader);
            }
            if ((guard = this.in.readByte()) != 0) {
                throw new IOException("data format error");
            }
            if (Agent.this.map != null && mapArgs) {
                Agent.this.map.map(args);
            }
            PrintWriter testLog = new PrintWriter(new AgentWriter(76, this));
            PrintWriter testRef = new PrintWriter(new AgentWriter(82, this));
            try {
                Class<?> c;
                ClassLoader cl = null;
                if (remoteClasses) {
                    cl = this.getAgentClassLoader(sharedClassLoader);
                    c = cl.loadClass(className);
                } else {
                    c = Class.forName(className);
                }
                if (this.request.equals("executeTest")) {
                    Status status2 = this.executeTest(c, args, testLog, testRef);
                    return status2;
                }
                if (this.request.equals("executeCommand")) {
                    Status status3 = this.executeCommand(c, args, testLog, testRef, cl);
                    return status3;
                }
                if (this.request.equals("executeMain")) {
                    Status status4 = this.executeMain(c, args, testLog, testRef);
                    return status4;
                }
                Status status5 = Status.error("Unrecognized request for agent: `" + this.request + "'");
                return status5;
            }
            catch (ClassCastException e) {
                if (Agent.this.tracing) {
                    e.printStackTrace(Agent.this.traceOut);
                }
                status = Status.error("Can't execute class `" + className + "': required interface not found");
                return status;
            }
            catch (ClassNotFoundException ex) {
                status = Status.error("Can't find class `" + className + "'");
                return status;
            }
            catch (IllegalAccessException ex) {
                status = Status.error("Illegal access to class `" + className + "'");
                return status;
            }
            catch (InstantiationException ex) {
                status = Status.error("Can't instantiate class`" + className + "'");
                return status;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace(testLog);
                status = Status.error("Unexpected exception: " + e);
                return status;
            }
            catch (Error e) {
                e.printStackTrace(testLog);
                status = Status.error("Unexpected error: " + e);
                return status;
            }
            catch (Throwable e) {
                e.printStackTrace(testLog);
                status = Status.error("Unexpected throwable: " + e);
                return status;
            }
            finally {
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("CLOSE TESTREF");
                }
                testRef.close();
                if (Agent.this.tracing) {
                    Agent.this.traceOut.println("CLOSE TESTLOG");
                }
                testLog.close();
            }
        }

        private Status executeTest(Class c, String[] args, PrintWriter testLog, PrintWriter testRef) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
            Agent.this.notifier.execTest(this.connection, this.tag, c.getName(), args);
            Test t = (Test)c.newInstance();
            return t.run(args, testLog, testRef);
        }

        private Status executeCommand(Class c, String[] args, PrintWriter testLog, PrintWriter testRef, ClassLoader cl) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
            Agent.this.notifier.execCommand(this.connection, this.tag, c.getName(), args);
            Command tc = (Command)c.newInstance();
            tc.setClassLoader(cl);
            return tc.run(args, testLog, testRef);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Status executeMain(Class c, String[] args, PrintWriter testLog, PrintWriter testRef) throws IOException, ClassNotFoundException, IllegalAccessException {
            Agent.this.notifier.execMain(this.connection, this.tag, c.getName(), args);
            PrintStream out = Deprecated.createPrintStream(new WriterStream(testRef));
            PrintStream err = Deprecated.createPrintStream(new WriterStream(testLog));
            try {
                Agent.this.setSystemStreams(this, out, err);
                Method main = c.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Agent.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                main.invoke(null, new Object[]{args});
                Status status = Status.passed("OK");
                return status;
            }
            catch (NoSuchMethodException e) {
                Status status = Status.error("Can't find `public static void main(String[] args)' for `" + c.getName() + "'");
                return status;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                t.printStackTrace(err);
                Status status = Status.failed(t.toString());
                return status;
            }
            catch (InterruptedException e) {
                Status status = Status.failed("interrupted while waiting for access to system streams");
                return status;
            }
            finally {
                Agent.this.resetSystemStreams(this);
                out.flush();
                err.flush();
            }
        }

        synchronized void close() {
            if (!this.connection.isClosed()) {
                Agent.closeIgnoreExceptions(this.connection);
            }
            if (this.in != null) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        synchronized void sendChars(byte type, char[] b, int off, int len) throws IOException {
            this.out.write(type);
            this.out.writeUTF(new String(b, off, len));
            switch (type) {
                case 108: 
                case 114: {
                    this.out.flush();
                }
            }
        }

        private synchronized void sendStatus(Status s) throws IOException {
            this.out.write(83);
            this.out.write((byte)s.getType());
            this.out.writeUTF(s.getReason());
        }

        synchronized byte[] getClassData(String className) throws ClassNotFoundException {
            if (Agent.this.tracing) {
                Agent.this.traceOut.println("REMOTE LOAD " + className);
            }
            try {
                int n;
                this.out.write(67);
                this.out.writeUTF(className);
                this.out.flush();
                int size = this.in.readInt();
                if (size == 0) {
                    throw new ClassNotFoundException(className);
                }
                byte[] data = new byte[size];
                for (int offset = 0; offset < data.length; offset += n) {
                    n = this.in.read(data, offset, data.length - offset);
                    if (n != -1) continue;
                    throw new ClassNotFoundException(className + ": EOF while reading class data");
                }
                return data;
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className + ": " + e);
            }
        }

        synchronized byte[] getResourceData(String resourceName) throws MissingResourceException, IOException {
            int n;
            if (Agent.this.tracing) {
                Agent.this.traceOut.println("REMOTE LOAD " + resourceName);
            }
            this.out.write(68);
            this.out.writeUTF(resourceName);
            this.out.flush();
            int size = this.in.readInt();
            if (size == -1) {
                throw new MissingResourceException(resourceName, null, resourceName);
            }
            byte[] data = new byte[size];
            for (int offset = 0; offset < data.length; offset += n) {
                n = this.in.read(data, offset, data.length - offset);
                if (n != -1) continue;
                throw new IOException(resourceName + ": EOF while reading resource data");
            }
            return data;
        }

        private ClassLoader getAgentClassLoader(boolean useSharedClassLoader) throws InstantiationException, IllegalAccessException {
            Class classLoaderClass;
            try {
                String s = this.getClass().getName();
                String pkg = s.substring(0, s.lastIndexOf(46));
                classLoaderClass = Class.forName(pkg + ".AgentClassLoader2");
            }
            catch (Throwable t) {
                classLoaderClass = class$com$sun$javatest$agent$AgentClassLoader == null ? (class$com$sun$javatest$agent$AgentClassLoader = Agent.class$("com.sun.javatest.agent.AgentClassLoader")) : class$com$sun$javatest$agent$AgentClassLoader;
            }
            Class[] argTypes = new Class[]{class$com$sun$javatest$agent$Agent$Task == null ? (class$com$sun$javatest$agent$Agent$Task = Agent.class$("com.sun.javatest.agent.Agent$Task")) : class$com$sun$javatest$agent$Agent$Task};
            if (useSharedClassLoader && factoryMethod == null) {
                try {
                    factoryMethod = classLoaderClass.getDeclaredMethod("getInstance", argTypes);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            if (classLoaderConstructor == null) {
                try {
                    classLoaderConstructor = classLoaderClass.getDeclaredConstructor(argTypes);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            try {
                Object[] args = new Object[]{this};
                if (useSharedClassLoader && factoryMethod != null) {
                    return (ClassLoader)factoryMethod.invoke(null, args);
                }
                return (ClassLoader)classLoaderConstructor.newInstance(args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Error(e.toString());
            }
        }
    }

    private class Notifier {
        private Observer[] observers = new Observer[0];

        private Notifier() {
        }

        public synchronized void addObserver(Observer o) {
            this.observers = (Observer[])DynamicArray.append(this.observers, o);
        }

        public synchronized void removeObserver(Observer o) {
            this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, o);
        }

        public synchronized void started() {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].started(Agent.this);
            }
        }

        public synchronized void finished() {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].finished(Agent.this);
            }
        }

        public synchronized void openedConnection(Connection connection) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].openedConnection(Agent.this, connection);
            }
        }

        public synchronized void errorOpeningConnection(Exception e) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].errorOpeningConnection(Agent.this, e);
            }
        }

        public synchronized void execTest(Connection cconnection, String tag, String className, String[] args) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].execTest(Agent.this, cconnection, tag, className, args);
            }
        }

        public synchronized void execCommand(Connection cconnection, String tag, String className, String[] args) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].execCommand(Agent.this, cconnection, tag, className, args);
            }
        }

        public synchronized void execMain(Connection connection, String tag, String className, String[] args) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].execMain(Agent.this, connection, tag, className, args);
            }
        }

        public synchronized void result(Connection connection, Status status) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].result(Agent.this, connection, status);
            }
        }

        public synchronized void exception(Connection connection, Exception e) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].exception(Agent.this, connection, e);
            }
        }

        public synchronized void completed(Connection connection) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].completed(Agent.this, connection);
            }
        }
    }

    public static interface Observer {
        public void started(Agent var1);

        public void errorOpeningConnection(Agent var1, Exception var2);

        public void finished(Agent var1);

        public void openedConnection(Agent var1, Connection var2);

        public void execTest(Agent var1, Connection var2, String var3, String var4, String[] var5);

        public void execCommand(Agent var1, Connection var2, String var3, String var4, String[] var5);

        public void execMain(Agent var1, Connection var2, String var3, String var4, String[] var5);

        public void result(Agent var1, Connection var2, Status var3);

        public void exception(Agent var1, Connection var2, Throwable var3);

        public void completed(Agent var1, Connection var2);
    }
}

