/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.AllTestsFilter;
import com.sun.javatest.CompositeFilter;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.HarnessHttpHandler;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.LastRunInfo;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestRunner;
import com.sun.javatest.TestSuite;
import com.sun.javatest.Trace;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.ReadAheadIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Harness {
    private BackupPolicy backupPolicy;
    private int autostopThreshold;
    private HarnessHttpHandler httpHandler;
    private Trace trace;
    private Thread worker;
    private Parameters params;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private ExcludeList excludeList;
    private TestResultTable.TreeIterator testIter;
    private int readAheadMode;
    private ReadAheadIterator raTestIter;
    private int numTestsDone;
    private TestEnvironment env;
    private TestResultTable resultTable;
    private Notifier notifier;
    private long startTime;
    private long finishTime;
    private long cleanupFinishTime;
    private long testsStartTime;
    private boolean isBatchRun;
    private boolean stopping;
    private static File classDir;
    private static final boolean ZERO_TESTS_OK = true;
    private static final boolean ZERO_TESTS_ERROR = false;
    private static final int DEFAULT_READ_AHEAD = 100;
    private static I18NResourceBundle i18n;

    public Harness(File classDir) {
        this();
        Harness.setClassDir(classDir);
    }

    public Harness() {
        Integer i = Integer.getInteger("javatest.autostop.threshold");
        this.autostopThreshold = i == null ? 0 : i;
        this.readAheadMode = 2;
        this.notifier = new Notifier();
        this.startTime = -1L;
        this.finishTime = -1L;
        this.cleanupFinishTime = -1L;
        this.testsStartTime = -1L;
        this.backupPolicy = BackupPolicy.noBackups();
        this.params = null;
        if (!Boolean.getBoolean("javatest.noTraceRequired")) {
            this.trace = new Trace(this.backupPolicy);
            this.addObserver(this.trace);
        }
        if (HttpdServer.isActive()) {
            this.httpHandler = new HarnessHttpHandler(this);
            RootRegistry.getInstance().addHandler("/harness", "JT Harness", this.httpHandler);
        }
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public void setBackupPolicy(BackupPolicy bp) {
        this.backupPolicy = bp;
    }

    public boolean isTracingRequired() {
        return this.trace != null;
    }

    public void setTracingRequired(boolean b) {
        if (b && this.trace == null) {
            this.trace = new Trace(this.backupPolicy);
            this.addObserver(this.trace);
        } else if (!b && this.trace != null) {
            this.removeObserver(this.trace);
            this.trace = null;
        }
    }

    public static File getClassDir() {
        return classDir;
    }

    public static void setClassDir(File classDir) {
        if (Harness.classDir != null && Harness.classDir != classDir) {
            throw new IllegalStateException(i18n.getString("harness.classDirAlreadySet"));
        }
        Harness.classDir = classDir;
    }

    public Parameters getParameters() {
        return this.params;
    }

    public TestEnvironment getEnv() {
        return this.env;
    }

    public TestResultTable getResultTable() {
        WorkDirectory wd = this.params == null ? null : this.params.getWorkDirectory();
        return wd == null ? null : wd.getTestResultTable();
    }

    public void addObserver(Observer o) {
        this.notifier.addObserver(o);
    }

    public void removeObserver(Observer o) {
        this.notifier.removeObserver(o);
    }

    public void start(Parameters p) throws Fault {
        this.startWorker(p);
    }

    public synchronized void waitUntilDone() throws InterruptedException {
        while (this.worker != null) {
            this.wait();
        }
    }

    public synchronized void stop() {
        if (this.worker != null) {
            if (!this.stopping) {
                this.notifier.stoppingTestRun();
                this.stopping = true;
            }
            this.worker.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batch(Parameters params) throws Fault, InterruptedException {
        this.isBatchRun = true;
        if (Boolean.getBoolean("javatest.noReadAhead")) {
            this.readAheadMode = 0;
        }
        Harness harness = this;
        synchronized (harness) {
            if (this.worker != null) {
                throw new Fault(i18n, "harness.alreadyRunning");
            }
            this.worker = Thread.currentThread();
        }
        if (!params.isValid()) {
            throw new Fault(i18n, "harness.incompleteParameters", params.getErrorMessage());
        }
        boolean ok = false;
        try {
            this.workDir = params.getWorkDirectory();
            this.resultTable = this.workDir.getTestResultTable();
            ok = this.runTests(params, true);
        }
        catch (TestSuite.Fault e) {
            throw new Fault(i18n, "harness.testsuiteError", e.getMessage());
        }
        finally {
            Harness harness2 = this;
            synchronized (harness2) {
                this.worker = null;
                this.notifyAll();
            }
            this.notifier.finishedTestRun(ok);
            this.isBatchRun = false;
        }
        return ok;
    }

    public boolean isRunning() {
        return this.worker != null;
    }

    public synchronized boolean isBatchRun() throws IllegalStateException {
        if (!this.isRunning()) {
            throw new IllegalStateException();
        }
        return this.isBatchRun;
    }

    public boolean isAllTestsFound() {
        if (this.isRunning() && this.raTestIter != null) {
            return this.raTestIter.isSourceExhausted();
        }
        return false;
    }

    public long getElapsedTime() {
        long time = 0L;
        if (this.startTime == -1L) {
            time = 0L;
        } else if (this.cleanupFinishTime == -1L) {
            long now = System.currentTimeMillis();
            time = now - this.startTime;
        } else {
            time = this.cleanupFinishTime - this.startTime;
        }
        return time;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getCleanupFinishTime() {
        return this.cleanupFinishTime;
    }

    public long getTotalCleanupTime() {
        if (this.cleanupFinishTime < this.finishTime || this.cleanupFinishTime == -1L) {
            return -1L;
        }
        return this.cleanupFinishTime - this.finishTime;
    }

    public long getTotalSetupTime() {
        if (this.testsStartTime < this.startTime || this.testsStartTime == -1L) {
            return -1L;
        }
        return this.testsStartTime - this.startTime;
    }

    public long getEstimatedTime() {
        if (!this.isRunning() || this.numTestsDone == 0) {
            return 0L;
        }
        long estRemain = this.getElapsedTime() * (long)(this.getTestsFoundCount() - this.numTestsDone) / (long)this.numTestsDone;
        return estRemain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTestsFoundCount() {
        if (this.raTestIter == null) {
            return 0;
        }
        ReadAheadIterator readAheadIterator = this.raTestIter;
        synchronized (readAheadIterator) {
            return this.raTestIter.getUsedElementCount() + this.raTestIter.getOutputQueueSize();
        }
    }

    public void setAutostopThreshold(int n) {
        this.autostopThreshold = n;
    }

    public int getAutostopThreshold(int n) {
        return this.autostopThreshold;
    }

    private synchronized void startWorker(final Parameters p) throws Fault {
        if (this.worker != null) {
            throw new Fault(i18n, "harness.alreadyRunning");
        }
        this.worker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean ok = false;
                try {
                    ok = Harness.this.runTests(p, false);
                }
                catch (Fault e) {
                    Harness.this.notifyLocalizedError(e.getMessage());
                }
                catch (TestSuite.Fault e) {
                    Harness.this.notifyLocalizedError(e.getMessage());
                }
                catch (InterruptedException e) {
                    Harness.this.notifyError(i18n, "harness.interrupted");
                }
                finally {
                    Harness e = Harness.this;
                    synchronized (e) {
                        Harness.this.worker = null;
                        Harness.this.notifyAll();
                    }
                    Harness.this.notifier.finishedTestRun(ok);
                }
            }
        };
        this.worker.setName("Harness:Worker");
        this.worker.setPriority(3);
        this.worker.start();
    }

    private boolean runTests(Parameters p, boolean zeroTestsOK) throws Fault, TestSuite.Fault, InterruptedException {
        File atsr;
        boolean ok = true;
        this.stopping = false;
        this.startTime = System.currentTimeMillis();
        this.testsStartTime = -1L;
        this.cleanupFinishTime = -1L;
        this.finishTime = -1L;
        this.numTestsDone = 0;
        if (!p.isValid()) {
            throw new Fault(i18n, "harness.incompleteParameters", p.getErrorMessage());
        }
        this.params = p;
        this.testSuite = this.params.getTestSuite();
        this.workDir = this.params.getWorkDirectory();
        this.resultTable = this.workDir.getTestResultTable();
        this.excludeList = this.params.getExcludeList();
        this.workDir.log(i18n, "harness.starting");
        float tf = this.params.getTimeoutFactor();
        if (Float.isNaN(tf)) {
            tf = 1.0f;
        }
        String[] timeoutFactors = new String[]{String.valueOf((int)Math.ceil(tf)), String.valueOf(tf)};
        this.env = this.params.getEnv();
        this.env.put("javatestTimeoutFactor", timeoutFactors);
        this.env.putUrlAndFile("javatestClassDir", classDir);
        this.env.putUrlAndFile("harnessClassDir", classDir);
        this.env.putUrlAndFile("javatestWorkDir", this.workDir.getRoot());
        String altTSRoot = this.testSuite.getTestSuiteInfo("env.tsRoot");
        File file = atsr = altTSRoot == null ? null : new File(altTSRoot);
        if (atsr != null && atsr.exists()) {
            this.env.putUrlAndFile("testSuiteRoot", atsr);
            this.env.putUrlAndFile("testSuiteRootDir", atsr.isDirectory() ? atsr : atsr.getParentFile());
        } else {
            this.env.putUrlAndFile("testSuiteRoot", this.testSuite.getRoot());
            this.env.putUrlAndFile("testSuiteRootDir", this.testSuite.getRootDir());
        }
        this.testIter = this.createTreeIterator();
        this.raTestIter = this.getTestsIterator(this.testIter);
        if (this.autostopThreshold > 0) {
            this.addObserver(new Autostop(this.autostopThreshold));
        }
        this.testSuite.starting(this);
        this.notifier.startingTestRun(this.params);
        TestRunner r = this.testSuite.createTestRunner();
        r.setWorkDirectory(this.workDir);
        r.setBackupPolicy(this.backupPolicy);
        r.setEnvironment(this.env);
        r.setExcludeList(this.excludeList);
        int concurrency = this.params.getConcurrency();
        concurrency = Math.max(1, Math.min(concurrency, 256));
        r.setConcurrency(concurrency);
        r.setNotifier(this.notifier);
        TestURLCollector testURLCollector = new TestURLCollector();
        this.notifier.addObserver(testURLCollector);
        this.testsStartTime = System.currentTimeMillis();
        try {
            ok = r.runTests(new Iterator(){

                public boolean hasNext() {
                    return Harness.this.stopping ? false : Harness.this.raTestIter.hasNext();
                }

                public Object next() {
                    TestResult tr = (TestResult)Harness.this.raTestIter.next();
                    try {
                        return tr.getDescription();
                    }
                    catch (TestResult.Fault e) {
                        Harness.this.stopping = true;
                        throw new JavaTestError(i18n, "harness.trProb", tr.getWorkRelativePath(), (Throwable)e);
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.notifier.removeObserver(testURLCollector);
        this.finishTime = System.currentTimeMillis();
        this.notifier.finishedTesting();
        int[] stats = this.testIter.getResultStats();
        int iteratorCount = 0;
        for (int i = 0; i < stats.length; ++i) {
            iteratorCount += stats[i];
        }
        if (iteratorCount == 0 && !zeroTestsOK) {
            TestFilter[] filters = this.params.getFilters();
            this.notifyError(i18n, "harness.noTests", Harness.formatFilterList(Harness.listFilterNames(filters)));
            ok = false;
        }
        if (ok && (this.notifier.getErrorCount() > 0 || this.notifier.getFailedCount() > 0)) {
            ok = false;
        }
        try {
            LastRunInfo.writeInfo(this.workDir, this.startTime, this.finishTime, this.env.getName(), testURLCollector.testURLs);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.resultTable.waitUntilReady();
        this.workDir.log(i18n, "harness.done", new Integer(ok ? 0 : 1));
        this.cleanupFinishTime = System.currentTimeMillis();
        return ok;
    }

    public ReadAheadIterator getTestsIterator(TestResultTable.TreeIterator iter) throws Fault {
        if (iter == null) {
            iter = this.createTreeIterator();
        }
        return new ReadAheadIterator(iter, this.readAheadMode, 100);
    }

    private TestResultTable.TreeIterator createTreeIterator() throws Fault {
        TestResultTable.TreeIterator iter;
        String[] tests = this.params.getTests();
        TestFilter[] filters = this.params.getFilters();
        this.resultTable.waitUntilReady();
        if (tests == null || tests.length == 0) {
            iter = this.resultTable.getIterator(filters);
        } else {
            try {
                File[] files = new File[tests.length];
                for (int i = 0; i < tests.length; ++i) {
                    files[i] = new File(tests[i]);
                }
                iter = this.resultTable.getIterator(files, filters);
            }
            catch (TestResultTable.Fault err) {
                throw new Fault(i18n, "harness.badInitFiles", err.getMessage());
            }
        }
        return iter;
    }

    private static ArrayList<String> listFilterNames(TestFilter[] filters) {
        ArrayList<String> result = new ArrayList<String>();
        if (filters == null || filters.length == 0) {
            return result;
        }
        for (TestFilter f : filters) {
            if (f instanceof CompositeFilter) {
                result.addAll(Harness.listFilterNames(((CompositeFilter)f).getFilters()));
                continue;
            }
            if (f instanceof AllTestsFilter) continue;
            result.add(f.getName());
        }
        return result;
    }

    private static String formatFilterList(ArrayList<String> names) {
        if (names == null || names.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : names) {
            sb.append("- ");
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void notifyError(I18NResourceBundle i18n, String key) {
        this.notifyLocalizedError(i18n.getString(key));
    }

    private void notifyError(I18NResourceBundle i18n, String key, Object arg) {
        this.notifyLocalizedError(i18n.getString(key, arg));
    }

    private void notifyError(I18NResourceBundle i18n, String key, Object[] args) {
        this.notifyLocalizedError(i18n.getString(key, args));
    }

    private void notifyLocalizedError(String msg) {
        this.notifier.error(msg);
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(Harness.class);
    }

    class TestURLCollector
    implements Observer {
        final ArrayList testURLs = new ArrayList();

        TestURLCollector() {
        }

        public void startingTestRun(Parameters p) {
        }

        public synchronized void startingTest(TestResult tr) {
            this.testURLs.add(tr.getTestName());
        }

        public void finishedTest(TestResult tr) {
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean allOK) {
        }

        public void error(String msg) {
        }
    }

    class Autostop
    implements Observer {
        private int level;
        private int threshold;

        Autostop(int threshold) {
            this.threshold = threshold;
        }

        public void startingTestRun(Parameters p) {
        }

        public void startingTest(TestResult tr) {
        }

        public void finishedTest(TestResult tr) {
            switch (tr.getStatus().getType()) {
                case 1: {
                    ++this.level;
                    break;
                }
                case 2: {
                    this.level += 5;
                    break;
                }
                default: {
                    this.level = Math.max(this.level - 2, 0);
                }
            }
            if (this.level >= this.threshold) {
                Harness.this.notifyError(i18n, "harness.tooManyErrors");
                Harness.this.stop();
            }
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean allOK) {
        }

        public void error(String msg) {
        }
    }

    private class Notifier
    implements Observer {
        private Observer[] observers = new Observer[0];
        private volatile int errCount;
        private volatile int failCount;

        private Notifier() {
        }

        void addObserver(Observer o) {
            if (o == null) {
                throw new NullPointerException();
            }
            this.observers = (Observer[])DynamicArray.append(this.observers, o);
        }

        void removeObserver(Observer o) {
            this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, o);
        }

        public void startingTestRun(Parameters params) {
            Harness.this.resultTable.starting();
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].startingTestRun(params);
            }
        }

        public void startingTest(TestResult tr) {
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].startingTest(tr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishedTest(TestResult tr) {
            Harness.this.numTestsDone++;
            Harness.this.resultTable.update(tr);
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].finishedTest(tr);
            }
            switch (tr.getStatus().getType()) {
                case 1: {
                    Notifier notifier = this;
                    synchronized (notifier) {
                        ++this.failCount;
                        break;
                    }
                }
                case 2: {
                    Notifier notifier = this;
                    synchronized (notifier) {
                        ++this.errCount;
                        break;
                    }
                }
            }
        }

        public void stoppingTestRun() {
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].stoppingTestRun();
            }
        }

        public void finishedTesting() {
            Harness.this.resultTable.finished();
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].finishedTesting();
            }
        }

        public void finishedTestRun(boolean allOK) {
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].finishedTestRun(allOK);
            }
        }

        public void error(String msg) {
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].error(msg);
            }
        }

        synchronized int getErrorCount() {
            return this.errCount;
        }

        synchronized int getFailedCount() {
            return this.failCount;
        }
    }

    public static interface Observer {
        public void startingTestRun(Parameters var1);

        public void startingTest(TestResult var1);

        public void finishedTest(TestResult var1);

        public void stoppingTestRun();

        public void finishedTesting();

        public void finishedTestRun(boolean var1);

        public void error(String var1);
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Throwable cause) {
            super(i18n.getString(s), cause);
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }
    }
}

