/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionListDataListener;
import com.sun.interview.wizard.FileList;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.SwingFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FileListQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        final FileListQuestion q = (FileListQuestion)qq;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setName("flst");
        panel.setFocusable(false);
        JLabel label = new JLabel(i18n.getString("flst.lbl"));
        label.setName("flst.lbl");
        label.setDisplayedMnemonic(i18n.getString("flst.mne").charAt(0));
        label.setToolTipText(i18n.getString("flst.tip"));
        panel.add((Component)label, "North");
        final FileList list = this.createFileList("flst", q.getValue());
        list.setDuplicatesAllowed(q.isDuplicatesAllowed());
        list.addListDataListener(new ActionListDataListener(panel, listener, "edited"));
        list.setBaseDirectory(q.getBaseDirectory());
        label.setLabelFor(list);
        FileFilter[] filters = q.getFilters();
        if (filters == null || filters.length == 0) {
            list.setFileSelectionMode(0);
        } else {
            int mode = -1;
            for (int i = 0; i < filters.length; ++i) {
                FileFilter filter = filters[i];
                list.addFilter(SwingFileFilter.wrap(filter));
                if (filter.acceptsDirectories()) {
                    if (mode == -1) {
                        mode = 2;
                        continue;
                    }
                    if (mode != 0) continue;
                    mode = 2;
                    continue;
                }
                if (mode == -1) {
                    mode = 0;
                    continue;
                }
                if (mode != 1) continue;
                mode = 2;
            }
            list.setFileSelectionMode(mode);
        }
        panel.add((Component)list, "Center");
        Runnable valueSaver = new Runnable(){

            public void run() {
                q.setValue(list.getFiles());
            }
        };
        panel.putClientProperty("valueSaver", valueSaver);
        return panel;
    }

    protected FileList createFileList(String uiKey, File[] files) {
        return new FileList(uiKey, files);
    }

    public String getInvalidValueMessage(Question q) {
        return null;
    }
}

