/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NaturalComparator
implements Comparator<String> {
    public static final NaturalComparator INSTANCE = new NaturalComparator();
    private final HashMap<String, CompoundString> hash = new HashMap();

    private NaturalComparator() {
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return this.getCS(s1).compareTo(this.getCS(s2));
        }
        if (s1 != null) {
            return -1;
        }
        if (s2 != null) {
            return 1;
        }
        return 0;
    }

    private CompoundString getCS(String s) {
        CompoundString cs = this.hash.get(s);
        if (cs == null) {
            cs = new CompoundString(s);
            this.hash.put(s, cs);
        }
        return cs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompoundString
    implements Comparable<CompoundString> {
        ArrayList<String> chars = new ArrayList();
        ArrayList<Long> nums = new ArrayList();

        CompoundString(String s) {
            int len = s.length();
            int prev = 0;
            int pos = 0;
            while (true) {
                if (pos < len && !Character.isDigit(s.charAt(pos))) {
                    ++pos;
                    continue;
                }
                if (pos == len) {
                    this.chars.add(s.substring(prev));
                    break;
                }
                this.chars.add(s.substring(prev, pos));
                prev = pos++;
                while (pos < len && Character.isDigit(s.charAt(pos))) {
                    ++pos;
                }
                if (pos == len) {
                    this.nums.add(Long.parseLong(s.substring(prev)));
                    break;
                }
                this.nums.add(Long.parseLong(s.substring(prev, pos)));
                prev = pos;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.chars.size(); ++i) {
                sb.append(this.chars.get(i));
                if (i >= this.nums.size()) continue;
                sb.append(this.nums.get(i));
            }
            return sb.toString();
        }

        @Override
        public int compareTo(CompoundString s2) {
            int k = 0;
            while (true) {
                int res;
                if (k < this.chars.size() && k < s2.chars.size()) {
                    res = this.chars.get(k).compareTo(s2.chars.get(k));
                    if (res != 0) {
                        return res;
                    }
                } else {
                    return this.chars.size() - s2.chars.size();
                }
                if (k < this.nums.size() && k < s2.nums.size()) {
                    res = this.nums.get(k).compareTo(s2.nums.get(k));
                    if (res != 0) {
                        return res;
                    }
                } else {
                    return this.nums.size() - s2.nums.size();
                }
                ++k;
            }
        }
    }
}

