/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.util;

import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class DebugUtils {
    public static final Logger log;

    public static void flushInstrumentedClass(String flushPath, String className, byte[] data) {
        File root = new File(flushPath);
        String path = root.getAbsolutePath() + File.separator + className + ".class";
        File classFile = DebugUtils.prepareFile(path);
        try {
            FileOutputStream fos = new FileOutputStream(classFile);
            fos.write(data);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public static byte[] readClass(String className, String flushPath) {
        FileInputStream fis;
        File root = new File(flushPath);
        String path = root.getAbsolutePath() + File.separator + className + ".class";
        File f = new File(path);
        int classLength = (int)f.length();
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            byte[] classBuf = new byte[classLength];
            fis.read(classBuf, 0, classLength);
            fis.close();
            return classBuf;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static PrintWriter getPrintWriter(String className, String flushPath) {
        File root = new File(flushPath);
        String path = root.getAbsolutePath() + File.separator + className + ".java";
        File classFile = DebugUtils.prepareFile(path);
        try {
            return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(classFile), Charset.defaultCharset()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void attachLogger() {
        try {
            FileHandler fh = new FileHandler("jcov.log");
            fh.setFormatter(new SimpleFormatter());
            log.addHandler(fh);
            log.setLevel(Level.ALL);
        }
        catch (Exception e) {
            log.warning("File jcov.log could not be opened");
        }
    }

    private static File prepareFile(String path) {
        File classFile = new File(path);
        if (!classFile.exists()) {
            try {
                File parent = classFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                classFile.createNewFile();
            }
            catch (IOException e) {
                System.out.println("Can't create file: " + path);
                System.out.println(e.getMessage());
            }
        }
        return classFile;
    }

    static {
        Utils.initLogger();
        log = Logger.getLogger("com.sun.tdk.jcov");
    }
}

