/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.tools;

import com.sun.tdk.jcov.tools.ScaleCompressor;
import com.sun.tdk.jcov.util.Utils;

public class SimpleScaleCompressor
implements ScaleCompressor {
    public static final String sccsVersion = "%I% $LastChangedDate: 2009-06-08 18:52:39 +0400 (Mon, 08 Jun 2009) $";
    char[] buf = new char[32];

    public void decompress(char[] src, int len, byte[] dst, int scale_size) throws Exception {
        int dst_ind = 0;
        int dst_len = Utils.halfBytesRequiredFor(scale_size);
        int src_ind = 0;
        do {
            int buf_cnt = 0;
            byte hex_val = -1;
            try {
                char ch;
                while (src_ind < len && (hex_val = (byte)Utils.hexChar2Int(ch = src[src_ind++])) < 0) {
                    this.buf[buf_cnt++] = ch;
                }
                if (hex_val < 0) {
                    throw new Exception("malformed scale");
                }
                int expand_cnt = buf_cnt == 0 ? 1 : 0;
                int i = 0;
                --buf_cnt;
                while (buf_cnt >= 0) {
                    expand_cnt += Utils.convert2Int(this.buf[buf_cnt]) * Utils.pow(Utils.radix, i);
                    --buf_cnt;
                    ++i;
                }
                if (dst_ind + expand_cnt > dst_len) {
                    throw new ArithmeticException();
                }
                for (i = 0; i < expand_cnt; ++i) {
                    Utils.writeHalfByteAt(hex_val, dst_ind++, dst);
                }
            }
            catch (ArithmeticException e) {
                throw new Exception("invalid scale compression");
            }
            catch (IndexOutOfBoundsException e) {
                throw new Exception("invalid scale size");
            }
        } while (src_ind < len);
    }

    public int compress(byte[] src, StringBuffer dst, int scale_size) {
        byte old_quad = Utils.getHalfByteAt(0, src);
        int digit_cnt = 1;
        int dst_ind = 0;
        if (scale_size <= 4) {
            dst.setCharAt(0, Utils.int2HexChar(old_quad));
            return 1;
        }
        int size = Utils.halfBytesRequiredFor(scale_size);
        for (int i = 1; i < size; ++i) {
            byte cur_quad = Utils.getHalfByteAt(i, src);
            if (cur_quad != old_quad || i == size - 1) {
                if (cur_quad == old_quad) {
                    ++digit_cnt;
                }
                if (digit_cnt > 2) {
                    dst_ind = Utils.convert2BigRadix(digit_cnt, dst, dst_ind);
                } else if (digit_cnt == 2) {
                    dst.setCharAt(dst_ind++, Utils.int2HexChar(old_quad));
                }
                dst.setCharAt(dst_ind++, Utils.int2HexChar(old_quad));
                if (i == size - 1 && cur_quad != old_quad) {
                    dst.setCharAt(dst_ind++, Utils.int2HexChar(cur_quad));
                }
                digit_cnt = 1;
            } else {
                ++digit_cnt;
            }
            old_quad = cur_quad;
        }
        return dst_ind;
    }
}

