/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.runtime;

import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.runtime.FileSaver;
import com.sun.tdk.jcov.runtime.JCovSocketSaver;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentSocketSaver
extends JCovSocketSaver {
    private DataRoot root;
    private String file;

    public AgentSocketSaver(DataRoot root, String file) {
        this.root = root;
        this.file = file;
        if (this.file == null) {
            this.file = "result.xml";
        }
    }

    public AgentSocketSaver(DataRoot root, String file, String host, int port) {
        super(host, port);
        this.root = root;
        this.file = file;
    }

    public synchronized void saveResults() {
        try {
            String testname;
            if (this.host == null) {
                this.host = AgentSocketSaver.detectHost();
            }
            if (this.port == -1) {
                this.port = AgentSocketSaver.detectPort();
            }
            if ((testname = PropertyFinder.findValue("testname", null)) == null) {
                testname = PropertyFinder.findValue("file", this.file);
            } else if ("<jcov.ignore>".equals(testname)) {
                return;
            }
            Socket s = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    s = new Socket(this.host, this.port);
                    break;
                }
                catch (UnknownHostException e) {
                    System.err.println("JCovRT: Can't resolve hostname " + this.host + " - unknown host. Exiting. ");
                    return;
                }
                catch (IOException e) {
                    System.err.println("JCovRT: Attempt to connect to " + this.host + ":" + this.port + " failed: ");
                    System.err.println(e.getMessage());
                    Thread.sleep(3000L);
                    continue;
                }
            }
            if (s == null) {
                return;
            }
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            out.writeBytes("JCOV");
            out.write(0);
            out.writeUTF(System.getProperty("user.name"));
            out.writeUTF(testname);
            out.writeUTF(PropertyFinder.findValue("product", ""));
            out.writeBoolean(this.root.getParams().isDynamicCollect());
            this.root.writeObject(out);
            out.close();
            s.close();
        }
        catch (InterruptedException ex) {
        }
        catch (IOException ex) {
            Logger.getLogger(FileSaver.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

