/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.report.AbstractCoverage;
import com.sun.tdk.jcov.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MemberCoverage
extends AbstractCoverage {
    protected long count;
    protected int startLine;
    protected String name;
    protected String signature;
    protected String modifiers;
    protected int access;
    protected Scale scale;

    public Long getHitCount() {
        return this.count;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCovered() {
        return this.getHitCount() > 0L;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getReadableSignature() {
        return Utils.convertVMtoJLS(this.name, this.signature);
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public boolean isCoveredByTest(int testnum) {
        return this.scale != null && this.scale.isBitSet(testnum);
    }

    public List<Integer> getCoveringTests() {
        if (this.scale == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(this.scale.size() / 10);
        for (int i = 0; i < this.scale.size(); ++i) {
            if (!this.scale.isBitSet(i)) continue;
            list.add(i);
        }
        return list;
    }

    public Scale getScale() {
        return this.scale;
    }

    public int getScaleSize() {
        return this.scale.size();
    }

    public boolean isPublicAPI() {
        return (this.access & 5) != 0;
    }

    public boolean isPublic() {
        return (this.access & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.access & 2) != 0;
    }

    public boolean isProtected() {
        return (this.access & 4) != 0;
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    public int getAccess() {
        return this.access;
    }
}

