/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument.reader;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.data.ScaleOptions;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.reader.Reader;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import com.sun.tdk.jcov.instrument.reader.ReaderFactoryStAX;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataFieldStAX
implements Reader {
    private DataField fld;
    private XMLStreamReader parser;
    private ReaderFactory rf;

    public void readData(Object dest) throws FileFormatException {
        this.fld = (DataField)dest;
        try {
            this.readData();
        }
        catch (XMLStreamException ex) {
            throw new FileFormatException(ex.getMessage());
        }
    }

    void readData() throws XMLStreamException, FileFormatException {
        if (this.fld.getParent().getSource() != null && this.fld.getParent().getSource().endsWith(".fx")) {
            Reader r = this.rf.getSuperReaderFor(DataField.class);
            r.readData(this.fld);
        }
        long count = 0L;
        String s = this.parser.getAttributeValue(null, "count");
        if (s != null) {
            count = Long.parseLong(s);
        }
        this.fld.setCount(count);
        this.readScale();
        this.fld.setSignature(this.parser.getAttributeValue(null, "signature"));
        this.parser.nextTag();
    }

    private void readScale() {
        String s = this.parser.getAttributeValue(null, "scale");
        if (s != null && s.length() > 0) {
            try {
                DataRoot r = DataRoot.getInstance(this.fld.rootId());
                ScaleOptions opts = r.getScaleOpts();
                if (opts.needReadScales()) {
                    this.fld.setScale(new Scale(s.toCharArray(), s.length(), opts.getScaleSize(), opts.getScaleCompressor(), opts.scalesCompressed()));
                }
            }
            catch (FileFormatException fileFormatException) {
                // empty catch block
            }
        }
    }

    public void setReaderFactory(ReaderFactory r) {
        this.rf = r;
        this.parser = ((ReaderFactoryStAX)r).parser;
    }
}

