/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Stack;

public class XmlContext
extends PrintWriter {
    final String indentDelta;
    String indent = "";
    Stack<String> indentHistory = new Stack();
    boolean showAbstract = true;
    boolean showNonNested = true;
    boolean showBodiesInExitSubBlocks = true;
    boolean showBasicBlocks = false;
    boolean showDetailBlocks = true;
    boolean showLineTable = true;
    boolean showRangeTable = true;
    InstrumentationParams params;
    boolean skipNotCoveredClasses = false;

    public XmlContext(String filename, InstrumentationParams params) throws FileNotFoundException {
        super(new BufferedOutputStream(new FileOutputStream(filename)));
        this.indentDelta = "\t";
        this.configureContext(params);
    }

    public XmlContext(OutputStream out, InstrumentationParams params) throws FileNotFoundException {
        super(out);
        this.indentDelta = "\t";
        this.configureContext(params);
    }

    public XmlContext() throws FileNotFoundException {
        super(System.out);
        this.indentDelta = "\t";
    }

    public XmlContext(OutputStream out) throws FileNotFoundException {
        super(out);
        this.indentDelta = "\t";
    }

    public void configureContext(InstrumentationOptions.InstrumentationMode mode, boolean showAbstract) {
        if (mode.equals((Object)InstrumentationOptions.InstrumentationMode.BLOCK)) {
            this.showNonNested = false;
            this.showBasicBlocks = true;
            this.showDetailBlocks = false;
        }
        this.showAbstract = showAbstract;
    }

    void incIndent() {
        this.indentHistory.push(this.indent);
        this.indent = this.indent + this.indentDelta;
    }

    void decIndent() {
        this.indent = this.indentHistory.pop();
    }

    void indent() {
        this.print(this.indent);
    }

    void indentPrintln(String str) {
        this.indent();
        this.println(str);
    }

    void attr(String name, String value) {
        this.print(" " + name + "=\"");
        this.writeEscaped(value);
        this.print("\"");
    }

    void attr(String name, Object value) {
        this.print(" " + name + "=\"");
        this.writeEscaped(value.toString());
        this.print("\"");
    }

    void attr(String name, int value) {
        this.print(" " + name + "=\"" + value + "\"");
    }

    void attr(String name, long value) {
        this.print(" " + name + "=\"" + value + "\"");
    }

    void attr(String name, boolean value) {
        this.print(" " + name + "=\"" + value + "\"");
    }

    void attrNormalized(String name, String value) {
        this.print(" " + name + "=\"");
        this.writeEscaped(value);
        this.print("\"");
    }

    public final void configureContext(InstrumentationParams params) {
        this.params = params;
        if (params.getMode().equals((Object)InstrumentationOptions.InstrumentationMode.BLOCK)) {
            this.showNonNested = false;
            this.showBasicBlocks = true;
            this.showDetailBlocks = false;
        }
        this.showAbstract = params.isInstrumentAbstract();
    }

    public void setSkipNotCoveredClasses(boolean skipNotCoveredClasses) {
        this.skipNotCoveredClasses = skipNotCoveredClasses;
    }

    private void writeEscaped(String str) {
        int j = str.length();
        block7: for (int i = 0; i < j; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    this.write("&amp;");
                    continue block7;
                }
                case '<': {
                    this.write("&lt;");
                    continue block7;
                }
                case '>': {
                    this.write("&gt;");
                    continue block7;
                }
                case '\'': {
                    this.write("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.write("&quot;");
                    continue block7;
                }
                default: {
                    this.write(ch);
                }
            }
        }
    }
}

