/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.instrument.BasicBlock;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockMethEnter;
import com.sun.tdk.jcov.instrument.MergeException;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.tools.OneElemIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBasicBlock
extends BasicBlock {
    private final DataBlock block;

    public SimpleBasicBlock(int rootId) {
        this(rootId, -1, -1, true);
    }

    public SimpleBasicBlock(int rootId, int startBCI) {
        this(rootId, startBCI, startBCI, true);
    }

    public SimpleBasicBlock(int rootId, int startBCI, int endBCI, boolean attached) {
        super(rootId, startBCI, endBCI);
        this.block = attached ? (startBCI == 0 ? new DataBlockMethEnter(rootId) : new DataBlock(rootId){

            public String kind() {
                return "bl";
            }
        }) : (startBCI == 0 ? new DataBlockMethEnter(rootId, 0, false, 0L) : new DataBlock(rootId, 0, false, 0L){

            public String kind() {
                return "bl";
            }
        });
        this.block.setConcreteLocation(this);
        this.add(this.block);
    }

    public int getId() {
        return this.block.getId();
    }

    public DataBlock getBlock() {
        return this.block;
    }

    public Scale getScale() {
        return this.block.scale;
    }

    @Override
    void xmlGen(XmlContext ctx) {
        this.block.xmlGen(ctx);
    }

    @Override
    boolean wasHit() {
        return this.block.wasHit();
    }

    public long getCount() {
        return this.block.getCount();
    }

    @Override
    public void checkCompatibility(BasicBlock other) throws MergeException {
        super.checkCompatibility(other);
        if (!(other instanceof SimpleBasicBlock)) {
            throw new MergeException("Block has other type than it's merging copy, type is SimpleBasicBlock", "", 1);
        }
        SimpleBasicBlock so = (SimpleBasicBlock)other;
        if (!this.getDataRoot().getParams().isDynamicCollect() && !other.getDataRoot().getParams().isDynamicCollect() && this.getId() != so.getId()) {
            throw new MergeException("Block has other id than it's merging copy, id is " + this.getId(), "", 1);
        }
    }

    @Override
    public void merge(BasicBlock other) {
        SimpleBasicBlock so = (SimpleBasicBlock)other;
        this.block.mergeScale(so.block);
        this.block.setCount(this.getCount() + so.getCount());
    }

    @Override
    public Iterator<DataBlock> getIterator() {
        return new OneElemIterator<DataBlock>(this.block);
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        if (this.block instanceof DataBlockMethEnter) {
            out.write(1);
        } else {
            out.write(2);
        }
        this.block.writeObject(out);
    }

    SimpleBasicBlock(int rootId, DataInput in) throws IOException {
        super(rootId, in);
        byte code = in.readByte();
        switch (code) {
            case 1: {
                this.block = new DataBlockMethEnter(rootId, in);
                break;
            }
            case 2: {
                this.block = new DataBlock(rootId, in){

                    public String kind() {
                        return "bl";
                    }
                };
            }
            default: {
                throw new IOException("DataBlock with unknown code in SimpleBasicBlock " + code);
            }
        }
    }
}

