/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.JREInstr;
import com.sun.tdk.jcov.instrument.OffsetLabelingClassReader;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class OverriddenClassWriter
extends ClassWriter {
    private final ClassLoader loader;
    private static String[] customExtentions = PropertyFinder.findValue("clext", "").split(":");
    private static final HashMap<String, String> class_superclass = new HashMap();
    private static final HashMap<String, List<String>> class_interfaces = new HashMap();
    private static final List<String> EMPTY_LIST = new ArrayList<String>();

    public OverriddenClassWriter(ClassReader classReader, int flags, ClassLoader loader) {
        super(classReader, flags);
        this.loader = loader;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        return OverriddenClassWriter.getCommonSuperClassAlt(type1, type2, this.loader);
    }

    static String getCommonSuperClassAlt(String type1, String type2, ClassLoader loader) {
        if (OverriddenClassWriter.isAssignableFrom(type2, type1, loader)) {
            return type2;
        }
        String type = type1;
        while (!OverriddenClassWriter.isAssignableFrom(type, type2, loader)) {
            type = OverriddenClassWriter.getSuperClass(type, loader);
        }
        return type;
    }

    public static void clean() {
        class_superclass.clear();
        class_interfaces.clear();
    }

    public static boolean isAssignableFrom(String t1, String t2, ClassLoader loader) {
        if (t1 == null) {
            throw new RuntimeException("Can't read superclass bytecode. Please add it to the classpath. ");
        }
        if (t1.equals(t2)) {
            return true;
        }
        if (t2 == null || t2.equals("java/lang/Object")) {
            return false;
        }
        String superType = OverriddenClassWriter.getSuperClass(t2, loader);
        List<String> t2Interfaces = class_interfaces.get(t2);
        if (t2Interfaces != null && !t2Interfaces.isEmpty()) {
            for (String in2 : t2Interfaces) {
                if (!t1.equals(in2)) continue;
                return true;
            }
        }
        return OverriddenClassWriter.isAssignableFrom(t1, superType, loader);
    }

    public static String getSuperClass(String clName, ClassLoader loader) {
        if (clName == null) {
            return null;
        }
        String loaded = class_superclass.get(clName);
        if (loaded != null) {
            return loaded;
        }
        try {
            ClassReader cr = OverriddenClassWriter.openClassReader(clName, loader);
            String superName = cr.getSuperName();
            class_superclass.put(clName, superName);
            OverriddenClassWriter.detectInterfaces(clName, cr, loader);
            return superName;
        }
        catch (IOException e) {
            System.err.println("Failed to read class: " + clName + ". Reason: " + e.getMessage());
            return null;
        }
    }

    static void detectInterfaces(String clName, ClassReader cr, ClassLoader loader) throws IOException {
        if (class_interfaces.get(clName) != null) {
            return;
        }
        if (cr == null) {
            cr = OverriddenClassWriter.openClassReader(clName, loader);
            String superName = cr.getSuperName();
            class_superclass.put(clName, superName);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] interfaces = cr.getInterfaces();
        if (interfaces != null) {
            for (String itf : interfaces) {
                list.add(itf);
                OverriddenClassWriter.detectInterfaces(itf, null, loader);
                list.addAll((Collection)class_interfaces.get(itf));
            }
        }
        if (list.isEmpty()) {
            class_interfaces.put(clName, EMPTY_LIST);
        } else {
            class_interfaces.put(clName, list);
        }
    }

    public static ClassReader openClassReader(String clName, ClassLoader loader) throws IOException {
        if (loader instanceof JREInstr.StaticJREInstrClassLoader) {
            InputStream in = OverriddenClassWriter.getInputStreamForName(clName, loader, false, ".class");
            if (in == null) {
                in = OverriddenClassWriter.getInputStreamForName(clName, ClassLoader.getSystemClassLoader(), false, ".class");
                if (in == null) {
                    throw new IOException("Can't read class " + clName + " from classloader " + loader);
                }
                return new OffsetLabelingClassReader(in);
            }
            return new OffsetLabelingClassReader(in);
        }
        InputStream in = OverriddenClassWriter.getInputStreamForName(clName, ClassLoader.getSystemClassLoader(), false, ".class");
        if (in == null && (in = OverriddenClassWriter.getInputStreamForName(clName, ClassLoader.getSystemClassLoader(), false, ".clazz")) == null) {
            if (!ClassLoader.getSystemClassLoader().equals(loader)) {
                in = OverriddenClassWriter.getInputStreamForName(clName, loader, false, ".class");
                if (in != null) {
                    return new OffsetLabelingClassReader(in);
                }
                throw new IOException("Can't read class " + clName + " from classloader " + loader);
            }
            throw new IOException("Can't read class " + clName + " from classloader " + loader);
        }
        return new OffsetLabelingClassReader(in);
    }

    private static InputStream getInputStreamForName(final String name, final ClassLoader loader, boolean priveleged, final String ext) {
        try {
            InputStream in = loader.getResourceAsStream(name + ext);
            if (in != null) {
                return in;
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        for (int i = 0; i < customExtentions.length; ++i) {
            try {
                InputStream in = loader.getResourceAsStream(name + "." + customExtentions[i]);
                if (in == null) continue;
                return in;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        if (!priveleged) {
            return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return OverriddenClassWriter.getInputStreamForName(name, loader, true, ext);
                }
            });
        }
        return null;
    }
}

