/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.BlockCodeMethodAdapter;
import com.sun.tdk.jcov.instrument.BranchCodeMethodAdapter;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethodEntryOnly;
import com.sun.tdk.jcov.instrument.DataMethodInvoked;
import com.sun.tdk.jcov.instrument.DataMethodWithBlocks;
import com.sun.tdk.jcov.instrument.EntryCodeMethodAdapter;
import com.sun.tdk.jcov.instrument.FieldAnnotationVisitor;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.instrument.InvokeMethodAdapter;
import com.sun.tdk.jcov.instrument.MethodAnnotationAdapter;
import com.sun.tdk.jcov.instrument.NativeWrappingMethodAdapter;
import com.sun.tdk.jcov.instrument.SavePointsMethodAdapter;
import com.sun.tdk.jcov.instrument.StaticInvokeMethodAdapter;
import com.sun.tdk.jcov.util.Utils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

class DeferringMethodClassAdapter
extends ClassVisitor {
    private final DataClass k;
    private final InstrumentationParams params;

    public DeferringMethodClassAdapter(ClassVisitor cv, DataClass k, InstrumentationParams params) {
        super(262144, cv);
        this.k = k;
        this.params = params;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.k.setInfo(access, signature, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor fv = super.visitField(access, name, desc, signature, value);
        if (this.params.isInstrumentFields() && ((access & 8) == 0 || value == null)) {
            DataField fld = new DataField(this.k, access, name, desc, signature, value);
            fv = new FieldAnnotationVisitor(fv, fld);
        }
        return fv;
    }

    public void visitSource(String source, String debug) {
        this.k.setSource(source);
        super.visitSource(source, debug);
    }

    public MethodVisitor visitMethodCoverage(int access, String name, String desc, String signature, String[] exceptions) {
        if (!InstrumentationOptions.isSkipped(this.k.getFullname(), name, access) && this.params.isDynamicCollect() && this.params.isInstrumentNative() && (access & 0x100) != 0) {
            int accessNative = access;
            if ((accessNative & 8) == 0) {
                accessNative |= 0x10;
            }
            accessNative &= 0xFFFFFFFA;
            MethodVisitor mvNative = this.cv.visitMethod(accessNative |= 2, "$$generated$$_" + name, desc, signature, exceptions);
            if (mvNative == null) {
                throw new InternalError("Should not happen!");
            }
            MethodNode methodWrapper = new MethodNode(access & 0xFFFFFEFF, name, desc, signature, exceptions);
            DataMethodEntryOnly meth = new DataMethodEntryOnly(this.k, access, name, desc, signature, exceptions);
            return new NativeWrappingMethodAdapter(mvNative, methodWrapper, this.cv, meth, this.params);
        }
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (InstrumentationOptions.isSkipped(this.k.getFullname(), name, access) || mv == null || (access & 0x400) != 0 || (access & 0x100) != 0) {
            if ((access & 0x400) != 0 && this.params.isInstrumentAbstract() || (access & 0x100) != 0 && this.params.isInstrumentNative() || InstrumentationOptions.isSkipped(this.k.getFullname(), name, access)) {
                DataMethodInvoked meth = new DataMethodInvoked(this.k, access, name, desc, signature, exceptions);
                return new MethodAnnotationAdapter(mv, meth);
            }
            return mv;
        }
        if (this.k.getFullname().equals("sun/awt/X11/XWindowPeer") && name.equals("handleButtonPressRelease")) {
            DataMethodEntryOnly meth = new DataMethodEntryOnly(this.k, access, name, desc, signature, exceptions);
            return new EntryCodeMethodAdapter(mv, meth, this.params);
        }
        switch (this.params.getMode()) {
            case METHOD: {
                DataMethodEntryOnly meth = new DataMethodEntryOnly(this.k, access, name, desc, signature, exceptions);
                return new EntryCodeMethodAdapter(mv, meth, this.params);
            }
            case BLOCK: {
                DataMethodWithBlocks meth = new DataMethodWithBlocks(this.k, access, name, desc, signature, exceptions);
                return new BlockCodeMethodAdapter(mv, meth, this.params);
            }
            case BRANCH: {
                DataMethodWithBlocks meth = new DataMethodWithBlocks(this.k, access, name, desc, signature, exceptions);
                return new BranchCodeMethodAdapter(mv, meth, this.params);
            }
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.params.isInstrumentSynthetic() && (access & 0x1000) != 0) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodVisitor mv = this.visitMethodCoverage(access, name, desc, signature, exceptions);
        if ("<clinit>".equals(name) && !this.params.isDynamicCollect() && this.k.getPackageName().startsWith("java/lang/")) {
            mv = new MethodVisitor(262144, mv){

                public void visitCode() {
                    this.mv.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/Collect", "init", "()V");
                    super.visitCode();
                }
            };
        }
        if (this.params.isCallerFilterOn() && this.params.isCallerFilterAccept(this.k.getFullname()) && !this.params.isDynamicCollect() && name.equals("<clinit>")) {
            int id = (name + desc).hashCode();
            mv.visitLdcInsn(id);
            mv.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "setExpected", "(I)V");
        }
        if (this.params.isInnerInvacationsOff() && Utils.isAdvanceStaticInstrAllowed(this.k.getFullname(), name) && name.equals("<clinit>")) {
            mv.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "enterClinit", "()V");
        }
        if (this.params.isDataSaveFilterAccept(this.k.getFullname(), name, true)) {
            mv = new SavePointsMethodAdapter(mv, true);
        }
        if (this.params.isDataSaveFilterAccept(this.k.getFullname(), name, false)) {
            mv = new SavePointsMethodAdapter(mv, false);
        }
        mv = new MethodVisitor(262144, mv){

            public void visitLocalVariable(String arg0, String arg1, String arg2, Label arg3, Label arg4, int arg5) {
            }
        };
        mv = this.params.isDynamicCollect() ? new InvokeMethodAdapter(mv, this.k.getFullname(), this.params) : new StaticInvokeMethodAdapter(mv, this.k.getFullname(), name, access, this.params);
        return mv;
    }

    public AnnotationVisitor visitAnnotation(String anno, boolean b) {
        this.k.addAnnotation(anno);
        return super.visitAnnotation(anno, b);
    }

    public void visitInnerClass(String fullClassName, String parentClass, String className, int i) {
        if (!this.params.isInstrumentAnonymous()) {
            return;
        }
        try {
            if (this.k.getFullname().equals(fullClassName)) {
                this.k.setInner(true);
                this.k.setAnonym(className == null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        super.visitInnerClass(fullClassName, parentClass, className, i);
    }
}

