/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockMethEnter;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBranch;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.LocationConcrete;
import com.sun.tdk.jcov.instrument.MergeException;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.tools.OneElemIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMethodEntryOnly
extends DataMethod
implements Iterable<DataBlock> {
    private final DataBlockMethEnter entryBlock;

    public DataMethodEntryOnly(DataClass k, int access, String name, String desc, String signature, String[] exceptions) {
        this(k, access, name, desc, signature, exceptions, -1);
    }

    public DataMethodEntryOnly(DataClass k, int access, String name, String desc, String signature, String[] exceptions, int id) {
        super(k, access, name, desc, signature, exceptions, false);
        boolean newData = id == -1;
        int slot = newData ? Collect.newSlot() : id;
        this.entryBlock = new DataBlockMethEnter(this.rootId, slot, newData, 0L){

            void xmlAttrs(XmlContext ctx) {
                ctx.attr("id", this.getId());
                ctx.attr("count", this.getCount());
                this.printScale(ctx);
            }
        };
        LocationConcrete loc = new LocationConcrete(0){

            public String kind() {
                return "trash";
            }
        };
        this.entryBlock.setConcreteLocation(loc);
    }

    public DataMethodEntryOnly(DataClass k, int access, String name, String desc, String signature, String[] exceptions, int id, long count) {
        super(k, access, name, desc, signature, exceptions, false);
        boolean newData = id == -1;
        int slot = newData ? Collect.newSlot() : id;
        this.entryBlock = new DataBlockMethEnter(this.rootId, slot, newData, count){

            void xmlAttrs(XmlContext ctx) {
                ctx.attr("id", this.getId());
                ctx.attr("count", this.getCount());
                this.printScale(ctx);
            }
        };
        LocationConcrete loc = new LocationConcrete(0){

            public String kind() {
                return "trash";
            }
        };
        this.entryBlock.setConcreteLocation(loc);
    }

    public DataMethodEntryOnly(DataMethod other) {
        super(other);
        boolean newData = other.getSlot() == -1;
        int slot = newData ? Collect.newSlot() : other.getSlot();
        this.entryBlock = new DataBlockMethEnter(this.rootId, slot, newData, other.getCount()){

            void xmlAttrs(XmlContext ctx) {
                ctx.attr("id", this.getId());
                ctx.attr("count", this.getCount());
                this.printScale(ctx);
            }
        };
        LocationConcrete loc = new LocationConcrete(0){

            public String kind() {
                return "trash";
            }
        };
        this.entryBlock.setConcreteLocation(loc);
    }

    @Override
    public DataMethod clone(DataClass newClass, int newAccess, String newName) {
        return new DataMethodEntryOnly(newClass, newAccess, newName, this.getVmSignature(), this.getSignature(), this.getExceptions());
    }

    public int getId() {
        return this.entryBlock.getId();
    }

    @Override
    public boolean wasHit() {
        return this.entryBlock.wasHit();
    }

    @Override
    public long getCount() {
        return this.entryBlock.getCount();
    }

    @Override
    public void setCount(long count) {
        this.entryBlock.setCount(count);
    }

    public void setScale(String s) {
        this.entryBlock.readScale(s);
    }

    @Override
    public Scale getScale() {
        return this.entryBlock.scale;
    }

    @Override
    public int getSlot() {
        return this.entryBlock.slot;
    }

    @Override
    void xmlGen(XmlContext ctx) {
        super.xmlGenBodiless(ctx);
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        super.xmlAttrs(ctx);
        this.entryBlock.xmlAttrs(ctx);
    }

    @Override
    public void checkCompatibility(DataMethod other, String trace) throws MergeException {
        if (!(other instanceof DataMethodEntryOnly)) {
            throw new MergeException("Method has other type than it's merging copy, expected DataMethodEntryOnly; found " + other.getClass().getSimpleName(), trace, 0);
        }
        DataMethodEntryOnly m = (DataMethodEntryOnly)other;
        if (!this.getDataRoot().getParams().isDynamicCollect() && !other.getDataRoot().getParams().isDynamicCollect() && this.getId() != m.getId()) {
            throw new MergeException("Method has other id than it's merging copy, expected " + this.getId() + "; found " + m.getId(), trace, 0);
        }
    }

    @Override
    public void merge(DataMethod other) {
        DataMethodEntryOnly m = (DataMethodEntryOnly)other;
        this.entryBlock.mergeScale(m.entryBlock);
        this.entryBlock.setCount(this.getCount() + m.getCount());
    }

    @Override
    public Iterator<DataBlock> iterator() {
        return new OneElemIterator<DataBlock>(this.entryBlock);
    }

    @Override
    public List<DataBlock> getBlocks() {
        ArrayList<DataBlock> list = new ArrayList<DataBlock>(1);
        list.add(this.entryBlock);
        return list;
    }

    @Override
    public List<DataBranch> getBranches() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<DataBlockTarget> getBranchTargets() {
        return Collections.EMPTY_LIST;
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.entryBlock.writeObject(out);
    }

    DataMethodEntryOnly(DataClass parent, DataInput in) throws IOException {
        super(parent, in);
        this.entryBlock = new DataBlockMethEnter(parent.rootId, in){

            void xmlAttrs(XmlContext ctx) {
                ctx.attr("id", this.getId());
                ctx.attr("count", this.getCount());
                this.printScale(ctx);
            }
        };
    }
}

