/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.BasicBlock;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataMethodEntryOnly;
import com.sun.tdk.jcov.instrument.DataMethodInvoked;
import com.sun.tdk.jcov.instrument.DataMethodWithBlocks;
import com.sun.tdk.jcov.instrument.DataPackage;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.instrument.InvokeClassAdapter;
import com.sun.tdk.jcov.instrument.StaticInvokeMethodAdapter;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.util.DebugUtils;
import java.util.Iterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.TraceClassVisitor;

public class ClassMorph2 {
    private final InstrumentationParams params;

    public ClassMorph2(InstrumentationParams params, String template) {
        this.params = params;
        try {
            DataRoot root = Reader.readXML(template, true, null);
            for (DataPackage pack : root.getPackages()) {
                for (DataClass clazz : pack.getClasses()) {
                    String className;
                    int id;
                    for (DataMethod meth : clazz.getMethods()) {
                        if (!meth.access(meth.getAccess()).matches(".*abstract.*") && !meth.access(meth.getAccess()).matches(".*native.*")) continue;
                        id = 0;
                        if (meth instanceof DataMethodInvoked) {
                            id = ((DataMethodInvoked)meth).getId();
                        } else if (meth instanceof DataMethodEntryOnly) {
                            id = ((DataMethodEntryOnly)meth).getId();
                        } else {
                            BasicBlock bb;
                            Iterator<DataBlock> i$;
                            int i$2 = 0;
                            DataMethodWithBlocks mb = (DataMethodWithBlocks)meth;
                            BasicBlock[] arr$ = mb.getBasicBlocks();
                            int len$ = arr$.length;
                            if (i$2 < len$ && (i$ = (bb = arr$[i$2]).blocks().iterator()).hasNext()) {
                                DataBlock db = i$.next();
                                id = db.getId();
                            }
                        }
                        className = pack.getName().equals("") ? clazz.getName() : pack.getName().replace('.', '/') + "/" + clazz.getName();
                        StaticInvokeMethodAdapter.addID(className, meth.getName(), meth.getVmSignature(), id);
                    }
                    for (DataField fld : clazz.getFields()) {
                        id = fld.getId();
                        className = pack.getName().equals("") ? clazz.getName() : pack.getName().replace('.', '/') + "/" + clazz.getName();
                        StaticInvokeMethodAdapter.addID(className, fld.getName(), fld.getVmSig(), id);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public boolean isTransformed(String className) {
        return className != null && !className.startsWith("com/sun/tdk/jcov") && !className.startsWith("org/objectweb/asm");
    }

    public boolean shouldTransform(String className) {
        return this.isTransformed(className) && this.params.isIncluded(className);
    }

    public byte[] morph(byte[] classfileBuffer, String flushPath) {
        ClassReader cr = new ClassReader(classfileBuffer);
        String fullname = cr.getClassName();
        if (!this.isTransformed(fullname)) {
            return null;
        }
        if (!this.shouldTransform(fullname)) {
            return null;
        }
        ClassWriter cw = new ClassWriter(cr, 1);
        boolean shouldFlush = flushPath != null;
        ClassVisitor cv = shouldFlush ? new TraceClassVisitor(cw, DebugUtils.getPrintWriter(fullname, flushPath)) : cw;
        cv = new InvokeClassAdapter(cv, this.params){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
                StaticInvokeMethodAdapter instr = new StaticInvokeMethodAdapter(mv, this.className, name, access, ClassMorph2.this.params);
                return instr;
            }
        };
        cr.accept(cv, 0);
        return cw.toByteArray();
    }
}

