/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.data;

import com.sun.tdk.jcov.tools.ScaleCompressor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ScaleOptions {
    private boolean read_scales;
    private int scale_size;
    private boolean scales_compressed;
    private ScaleCompressor compressor;
    private String[] testIDs;
    private String outTestList;

    public ScaleOptions() {
    }

    public ScaleOptions(boolean read_scales, int scale_size, ScaleCompressor compressor) {
        this.setReadScales(read_scales);
        this.setScaleSize(scale_size);
        this.setScaleCompressor(compressor);
    }

    public void setReadScales(boolean read_scales) {
        this.read_scales = read_scales;
    }

    public boolean needReadScales() {
        return this.read_scales;
    }

    public void setScaleSize(int scale_size) {
        this.scale_size = scale_size;
    }

    public int getScaleSize() {
        return this.scale_size;
    }

    public void setScalesCompressed(boolean scales_compressed) {
        this.scales_compressed = scales_compressed;
    }

    public boolean scalesCompressed() {
        return this.scales_compressed;
    }

    public void setScaleCompressor(ScaleCompressor compressor) {
        this.compressor = compressor;
    }

    public ScaleCompressor getScaleCompressor() {
        return this.compressor;
    }

    public boolean hasCompressor() {
        return this.compressor != null;
    }

    public void setTestList(String[] testIDs) {
        this.testIDs = testIDs;
    }

    public String[] getTestList() {
        return this.testIDs;
    }

    public void setOutTestList(String outTestList) {
        this.outTestList = outTestList;
    }

    public String getOutTestList() {
        return this.outTestList;
    }

    public void writeObject(DataOutput out) throws IOException {
        out.writeBoolean(this.read_scales);
        out.writeShort(this.scale_size);
        out.writeBoolean(this.scales_compressed);
        if (this.compressor != null) {
            out.writeBoolean(true);
            out.writeUTF(this.compressor.getClass().getName());
        } else {
            out.writeBoolean(false);
        }
        if (this.testIDs != null) {
            out.writeShort(this.testIDs.length);
            for (int i = 0; i < this.testIDs.length; ++i) {
                out.writeUTF(this.testIDs[i]);
            }
        } else {
            out.writeShort(Short.MAX_VALUE);
        }
        if (this.outTestList != null) {
            out.writeBoolean(true);
            out.writeUTF(this.outTestList);
        } else {
            out.writeBoolean(false);
        }
    }

    public ScaleOptions(DataInput in) throws IOException {
        int len;
        this.read_scales = in.readBoolean();
        this.scale_size = in.readShort();
        this.scales_compressed = in.readBoolean();
        if (in.readBoolean()) {
            in.readUTF();
        }
        if ((len = in.readShort()) != Short.MAX_VALUE) {
            this.testIDs = new String[len];
            for (int i = 0; i < len; ++i) {
                this.testIDs[i] = in.readUTF();
            }
        } else {
            this.testIDs = null;
        }
        if (in.readBoolean()) {
            this.outTestList = in.readUTF();
        }
    }
}

